/* File: AmbiguousArray.h */
//prr

#ifndef __AmbiguousArray_cpp__
#define __AmbiguousArray_cpp__
/*
#include <sys/stat.h>
#include <iostream>
#include <cassert>
#include <fstream>
//#include <individual.h>
#include <string>
#include <iostream>
//#include <math.h>
#include <cmath>
#include <stdio.h>//
#include "ExceptionsBasic.h"
#include "basic.h"
#include "list.h"
*/
using namespace std;

namespace BIOS
{

 
    AmbiguousArray::AmbiguousArray(): MultidimensionalEmptyTable<int>()
    {
    };
    /*______________________________________________________*/

    AmbiguousArray::AmbiguousArray(intList* dimensionList): MultidimensionalEmptyTable<int>(dimensionList)
    {
   };
      /*______________________________________________________*/

    AmbiguousArray::AmbiguousArray(AmbiguousArray &source): MultidimensionalEmptyTable<int>(source)
    {
         }

       /*______________________________________________________*/


    AmbiguousArray::~AmbiguousArray()
{
};
    
 
      /*____________________________________________________________ */

long long int  AmbiguousArray::changePhase(long long int conf)
{
int *positions=getPositions(conf), *positions2=new int[this->totalDimensions];
long long int result;
int al1, al2;
for (int i=0; i<this->totalDimensions; i++)
{
positions2[i]=positions[i];
if (isAKnownPosition (positions[i], i) && (isAPositionWithDifferentValues(positions[i], i)))
{
al1=getKnownValue (positions[i], i, true);
al2=getKnownValue (positions[i], i, false);
positions2[i]=this->getAmbiguousPosition (al2, al1, i);
//cout <<"\nnew pos at : " << i <<": " << positions2[i] <<" bbefore was " << positions[i];
}
//else cout <<"\nunknown pos or equal values at : " << i <<": " << positions[i];
}
result=getPos(positions2);
zaparr(positions);
zaparr(positions2);
return result;
};
    /*____________________________________________________________ */

long long int  AmbiguousArray::getTotalSolvedConfs(long long int conf)
{
if (conf<0) return 0;
int* confArr=getPositions(conf);
int result=getTotalSolvedConfs(confArr);
zaparr(confArr);
return result;
};
    /*____________________________________________________________ */

long long int  AmbiguousArray::getTotalSolvedConfs(int* confArr)
{
// it returns the total number of pairs of solved configurations for a given ambiguous configuration
int totalUnknown=0, totalKnownDifferentValues=0, total;
for (int i=0; i<this->totalDimensions; i++)
if (!isAKnownPosition (confArr[i], i)) totalUnknown++;
total=pow(2, totalUnknown);
return total;
};
/*____________________________________________________________ */

int  AmbiguousArray::getTotalSolvedPos (int variable) 
{
// it returns the number of different pos at the known array (as alleles)
// It is the inverse of getTotalAmbiguousValues computed as totalValues^2+(combinations(totalValues, 2)
try
{
int totalAmbiguousValues=this->dimensionList->getElement(variable);
double v=(1+sqrt(1+24*totalAmbiguousValues))/(double)6;
if (v!=floor(v)) throw NonInteger(v, "AmbiguousArray::getTotalSolvedPos");
return (int)v;
}
catch (NonInteger nni){nni.PrintMessage();};
}
/*____________________________________________________________ */

bool  AmbiguousArray::isAKnownPosition (int pos, int variable)
{
return isAKnownPos(pos, this->getTotalSolvedPos(variable));
};
/*____________________________________________________________ */

bool  AmbiguousArray::isAKnownPos (int pos, int totalValuesAtCurrentPos)
{
return pos < pow(totalValuesAtCurrentPos,2);
};
/*____________________________________________________________ */

bool  AmbiguousArray::isAPositionWithDifferentValues (int pos, int variable)
{
// precondition: it must be a known position
int left=this->getKnownValue(pos, variable, true);
int right=this->getKnownValue(pos, variable, false);
return left!=right;
};
/*____________________________________________________________ */

bool  AmbiguousArray::hasSameValues (long long int conf)
{
int* positions=getPositions(conf);
for (int i=0; i<totalDimensions;i++)
{
if (!isAKnownPosition(positions[i], i) || isAPositionWithDifferentValues(positions[i], i)) {zaparr(positions); return false;}
}
zaparr(positions);
return true;
};
/*____________________________________________________________ */

int  AmbiguousArray::getAmbiguousPosition (int solvedPos1, int solvedPos2, int variable) 
{
return getAmbiguousPos(solvedPos1, solvedPos2, getTotalSolvedPos(variable));
}
/*____________________________________________________________ */

int AmbiguousArray::getAmbiguousPos (int solvedPos1, int solvedPos2, int totalSolvedPosAtCurrentVariable)
{

int result=0;
BidimensionalTable<int>* t=NULL;

if (solvedPos1==solvedPos2 || (solvedPos1>=0 && solvedPos2>=0)) // both known
{
t=new BidimensionalTable<int>(totalSolvedPosAtCurrentVariable, totalSolvedPosAtCurrentVariable);
result=t->getPos((solvedPos1), (solvedPos2)); 
zap(t);
}
else 
{
result=pow(totalSolvedPosAtCurrentVariable,2);
result=result+getUnknownPos(abs(solvedPos1), abs(solvedPos2), totalSolvedPosAtCurrentVariable);
}
return result;
}
/*_______________________________________________________________*/


long long int AmbiguousArray::getSolvedConf(int* confArr, long long int binaryKnownConf, bool left, MultidimensionalEmptyTable<int>* solvedArray)
{
// It returns the configuration in the solved table corresponding with the configuration (arg)knownConf compatible with the ambiguous (arg)confArr in the ambiguous array
// left for returning the left or the right pair
intList* dimList=new intList();
for (int i=0; i<totalDimensions;i++)
{
 if (isAKnownPosition(confArr[i], i)) dimList->insertElement(1); 
 else dimList->insertElement(2);
}
MultidimensionalTable<int>* tab=new MultidimensionalTable<int>(dimList);
zap(dimList);
int* resultPos=tab->getPositions(binaryKnownConf), al1, al2;
zap(tab);
int totalAmbiguous=0;
//cout <<"\n";
for (int i=0; i<totalDimensions;i++)
{
  if (isAKnownPosition(confArr[i], i)) 
  resultPos[i]=getKnownValue(confArr[i], i, left);
  else 
  {
    al1=inferValue(confArr[i], i, true);
    al2=inferValue(confArr[i], i, false);
    if ((resultPos[i]==0 && left)  || (resultPos[i]==1 && !left)) resultPos[i]=al1; else resultPos[i]=al2;
   }
}
long long int result=solvedArray->getPos(resultPos);
zaparr(resultPos);
return result;
};


/*_______________________________________________________________*/


long long int  AmbiguousArray::getSolvedConf(long long int conf, long long int binaryKnownConf, bool left, MultidimensionalEmptyTable<int>* solvedArray)
{
if (conf<0) return -1;
int* positions=getPositions(conf);
long long int result=getSolvedConf(positions, binaryKnownConf, left, solvedArray);
zaparr(positions);
return result;
};
/*_______________________________________________________________*/


long long int AmbiguousArray::getPartnerSolvedConf(long long int myBinaryKnownConf, long long int myConf, long long int partnerConf, bool left, MultidimensionalEmptyTable<int>* solvedArray)
{
// it computes the solved position for the ambiguous "partnerConf" at the left/right side (left argument), considering myConf was solved as myBinaryKnownConf
long long int mySolvedConfiguration=getSolvedConf(myConf, myBinaryKnownConf, left, solvedArray);
int *myAmb=NULL;
if (myConf>=0) myAmb=getPositions(myConf);
if (partnerConf<0) return -1;
int *partnerAmb=getPositions(partnerConf);
int *mySolvedConf=NULL;
if (mySolvedConfiguration>=0) mySolvedConf=solvedArray->getPositions(mySolvedConfiguration);
int* partnerConfiguration=new int[totalDimensions];
for (int i=0; i<totalDimensions;i++)
if (isAKnownPosition(partnerAmb[i], i)) partnerConfiguration[i]=getKnownValue (partnerAmb[i], i, left);
else
if (myConf>=0 && ((isAKnownPosition(myAmb[i],i) && mySolvedConf[i]==getKnownValue(myAmb[i], i, left)) ||
(!isAKnownPosition(myAmb[i],i) && mySolvedConf[i]==inferValue(myAmb[i], i, left))))
partnerConfiguration[i]=inferValue(partnerAmb[i], i, !left);
else 
partnerConfiguration[i]=inferValue(partnerAmb[i], i,left);


//if (mySolvedConf[i]==inferValue (partnerAmb[i], i, left))
//partnerConfiguration[i]=inferValue (partnerAmb[i], i, !left);
// else partnerConfiguration[i]=inferValue (partnerAmb[i], i, left);
zaparr(myAmb);
zaparr(mySolvedConf);
zaparr(partnerAmb);
long long int result=solvedArray->getPos(partnerConfiguration);
zaparr(partnerConfiguration);
return result;
}

/*____________________________________________________________ */

int  AmbiguousArray::getKnownValue (int pos, int variable, bool left)
{
// it returns the value at the left in pos, thus pos has to be known
if (!isAKnownPosition(pos, variable))
 throw OutOfRange<int>(pos, "AmbiguousArray::getKnownPos"); 
int *positions, totalValues=getTotalSolvedPos(variable);
BidimensionalTable<int>* t=new BidimensionalTable<int>(totalValues, totalValues);
positions=t->getPositions(pos); 
zap(t);
int result=positions[1-left];
zaparr(positions);
return result;
}
/*____________________________________________________________ */

int  AmbiguousArray::inferValue (int pos, int variable, bool left) throw (OutOfRange<int>)
{
// it infers the value at the left in pos, pos represents an unknown value of variable
if (isAKnownPosition(pos, variable))
 throw OutOfRange<int>(pos, string("AmbiguousArray::inferValue_1, var is ")+tos(variable)+" and dimensionlist is:  "+tos(*dimensionList)); 
for (int pos1=0; pos1<getTotalSolvedPos(variable); pos1++)
for (int pos2=pos1+1; pos2<getTotalSolvedPos(variable); pos2++)
{
if (getAmbiguousPosition(-pos1, -pos2, variable)==pos)
{
//cout << "\nfound for amb pos " << ambiguousPos <<", al1:" << pos1 << ", al2:" << pos2;
if (left) return pos1; else return pos2;
}
}
throw OutOfRange<int>(pos, "AmbiguousArray::inferValue_2");
}
  /*____________________________________________________________ */

int  AmbiguousArray::getUnknownPosition (int knownPos1, int knownPos2, int variable)
{
return getUnknownPos(knownPos1, knownPos2, getTotalSolvedPos(variable));
}

  /*____________________________________________________________ */

int  AmbiguousArray::getUnknownPos (int knownPos1, int knownPos2, int totalValuesAtCurrentPos)
{
if (knownPos1==knownPos2) throw OutOfRange<int>(knownPos1, "AmbiguousArray::getUnknownPos");
if (knownPos1>knownPos2) change(knownPos1, knownPos2);
int knownValues=totalValuesAtCurrentPos, result=0;
for (int i=0; i<knownPos1; i++)
 for (int j=0; j<knownValues-i-1; j++)
  result++;
result=result+knownPos2-knownPos1-1;  
return result;
}
/*____________________________________________________________ */

int AmbiguousArray::getTotalKnownPositions (int variable)
{
return pow(this->getTotalSolvedPos(variable), 2);
}
/*____________________________________________________________ */

int AmbiguousArray::getTotalPos (int totalSolvedPos)
{
if (totalSolvedPos==1) 
return 1; 
else return pow(totalSolvedPos,2)+((int)combinations(totalSolvedPos, 2));
}
/*____________________________________________________________ */

int  AmbiguousArray::getTotalUnknownPos (int totalSolvedPos)
{
if (totalSolvedPos==1) return 0;
else return (int) combinations(totalSolvedPos, 2);
}

  /*_________________________________________________________________________*/

double AmbiguousArray::getTotalFreq (double totalCounts, int totalSolvedConfs, long long int ambiguousConfPos, MultidimensionalTable<double> * ambiguousCounts, MultidimensionalTable<double>* currentEstimation, MultidimensionalTable<double>* secondCurrentEstimation, MultidimensionalTable<double>* newEstimation, MultidimensionalTable<double>* newEstimation2, bool together, bool compatibilityPairs, longLongList *partnerPointer, int ambiguousPos, double pAcc, MultidimensionalEmptyTable<int>* solvedArray)
{
double denominator;
double result=0, partial;
long long int solvedConfPos, complementarySolvedConfPos, solvedConfPosPartner, complementarySolvedConfPosPartner;
for (int j=0; j<totalSolvedConfs; j++) // for each possible complete configuration pair, as haplotype pairs 
{
solvedConfPos=getSolvedConf(ambiguousConfPos, j, true, solvedArray);
complementarySolvedConfPos=getSolvedConf(ambiguousConfPos, j, false, solvedArray);

if (compatibilityPairs)
{
solvedConfPosPartner=getPartnerSolvedConf(j, ambiguousConfPos, 
partnerPointer->getElement(ambiguousPos), true, solvedArray);
complementarySolvedConfPosPartner=getPartnerSolvedConf(j, ambiguousConfPos, partnerPointer->getElement(ambiguousPos), false, solvedArray);
}
if (together)
{
partial=currentEstimation->getValue(solvedConfPos)*currentEstimation->getValue(complementarySolvedConfPos);
//if (ambiguousConfPos==7196) cout <<"\npartial is:" << partial <<"\n";
if (compatibilityPairs) partial=partial*currentEstimation->getValue(solvedConfPosPartner)*currentEstimation->getValue(complementarySolvedConfPosPartner);
}
else 
{
partial=currentEstimation->getValue(solvedConfPos)*secondCurrentEstimation->getValue(complementarySolvedConfPos);
if (compatibilityPairs) partial=partial*currentEstimation->getValue(solvedConfPosPartner)*secondCurrentEstimation->getValue(complementarySolvedConfPosPartner);
}
if (pAcc==0)
result=result+partial;
else
{
result=partial/pAcc;
denominator=totalCounts/2;
if (together) denominator=denominator*2;
//if (compatibilityPairs && !together) denominator=denominator*2;
if (together)
{
newEstimation->addValue(solvedConfPos, result/denominator); // known
newEstimation->addValue(complementarySolvedConfPos, result/denominator); // known
if (compatibilityPairs)
{
newEstimation->addValue(solvedConfPosPartner, result/denominator); // known
newEstimation->addValue(complementarySolvedConfPosPartner, result/denominator); // known
}
}
else
{
//cout <<"solvedconf: " << solvedConfPos <<"\n";
newEstimation->addValue(solvedConfPos, result/denominator); // known
//cout <<"complementarySolvedConfPos: " << complementarySolvedConfPos <<"\n";

newEstimation2->addValue(complementarySolvedConfPos, result/denominator); // known
if (compatibilityPairs)
{
newEstimation->addValue(solvedConfPosPartner, result/denominator); // known
newEstimation2->addValue(complementarySolvedConfPosPartner, result/denominator); // known
}
}
}
}// for each configuration pair
return result;
};
  /*_________________________________________________________________________*/

void  AmbiguousArray::estimateMLE (MultidimensionalTable<double>*& currentEstimation, MultidimensionalTable<double> * ambiguousCounts, MultidimensionalTable<longLongList*> * ambiguousPartnerPointers, double totalCounts, int it, MultidimensionalTable<double>*& secondCurrentEstimation, MultidimensionalTable<double>*& thirdCurrentEstimation, MultidimensionalTable<double>*& fourthCurrentEstimation, MultidimensionalEmptyTable<int>* solvedArray)
{
//cout << "\ninside:"<< *currentEstimation <<"\n";
//cout << "\nambigous counts:" << *ambiguousCounts <<"\n";
// when used for compatibilityPairs=true, ambiguosCounts must have only integer values, 
bool together=false, compatibilityPairs=false;
if (secondCurrentEstimation==NULL) together=true;
if (ambiguousPartnerPointers!=NULL) compatibilityPairs=true;
//cout <<"\ncompatibility pair is :" << compatibilityPairs;
//cout <<"together:" << together <<"and compa: " << compatibilityPairs;
double tot;
intList* dimList=currentEstimation->dimensionList;
MultidimensionalTable<double>* result=new MultidimensionalTable<double>(dimList);
MultidimensionalTable<double>* result2=NULL;
if (!together) result2=new MultidimensionalTable<double>(dimList);
double totalItemsAtAmbiguousPos, val2, pVal, pVal2, ppS, pAcc, *p1, p2, p3;
longLongList* partnerPointers;
long long int totalSolvedConfs, solvedConfPos, complementarySolvedConfPos, solvedConfPosPartner, complementarySolvedConfPartner;
//cout <<"size is:" << ambiguousCounts->getSize() <<"\n";
for (long long int i=0; i<ambiguousCounts->getSize(); i++) // for each ambiguous configuration (as genotypes)
{
totalItemsAtAmbiguousPos=ambiguousCounts->getValue(i);
if (totalItemsAtAmbiguousPos>zero) //ambiguous conf 
{
if (compatibilityPairs) 
{
if (std::ceil(totalItemsAtAmbiguousPos)>totalItemsAtAmbiguousPos) throw BadFormat(string("AmbiguosArray::estimateMLE"));
partnerPointers=ambiguousPartnerPointers->getValue(i);
}
totalSolvedConfs=getTotalSolvedConfs(i);
//cout <<"totalsolved confs:" << totalSolvedConfs <<"\n";
for (int itemAtAmbiguousPos=0; itemAtAmbiguousPos<totalItemsAtAmbiguousPos; itemAtAmbiguousPos++) // for each item with that configuration or pair of items if compatibilityPairs
//if (compatibilityPairs==false && gene==0 || compatibilityPairs)
{
pAcc=getTotalFreq (totalCounts, totalSolvedConfs, i, ambiguousCounts, currentEstimation, secondCurrentEstimation, result, result2, together, compatibilityPairs, partnerPointers, itemAtAmbiguousPos, 0, solvedArray);
//cout <<"\nresultF:\n" << *result << " and pAcc" << pAcc << "\n";
//if (1==0)
if (pAcc==0)
{
cout << "\nError in MLE, \ntotalconfs:" << totalSolvedConfs;
cout <<"\nambiguouscount:" << i;
cout <<"\ncompatibility pair is :" << compatibilityPairs <<"\n";
cout << "\ngenotype pos:" << i;
cout << "\ntotal freqs:" << totalItemsAtAmbiguousPos;
if (compatibilityPairs)
{
cout << "\n, partner genotype pos:" << partnerPointers->getElement(itemAtAmbiguousPos);
cout <<"\npointers:\n";
cout <<*partnerPointers <<"\n";
 }
if (together) cout <<"together\n"; else cout <<"two distributions\n";
exit(0);
}
getTotalFreq (totalCounts, totalSolvedConfs, i, ambiguousCounts, currentEstimation, secondCurrentEstimation, result, result2, together, compatibilityPairs, partnerPointers, itemAtAmbiguousPos, pAcc, solvedArray);
}
}
}
double t=0, t2=0, check=0, check2=0;
for (int i=0; i<result->getSize(); i++)
{
 t=t+fabs(result->getValue(i)-currentEstimation->getValue(i));
  check=check+result->getValue(i);
 if (!together) 
 {
  t2=t2+fabs(result2->getValue(i)-secondCurrentEstimation->getValue(i));
  check2=check2+result2->getValue(i);
 }
}
if (!together) zap(secondCurrentEstimation);
if ((check > (1+zero) || check < (1-zero)) 
|| (!together && ((check > (1+zero) || check < (1-zero))))) 
{
cout << "error in EM, check is " << check;
cout <<"\nresult is:\n" <<* result;
if (!together) cout <<"\nresultU is: \n" <<*result2;
cout <<"\ntotalCounts:" << totalCounts <<"\n";
cout <<"\niterations: " << it; 
cout <<"\ntogether is:" << together;
cout <<"\ncompatibility pair is :" << compatibilityPairs;
exit(0);
zap (result);
if (!together) zap (result2);
return;
}
zap(currentEstimation);
currentEstimation=result;
if (!together) secondCurrentEstimation=result2;
//cout <<"it is" << it << "dif is:" << t << "\n";
if (t>= 0.00005 && (together || t2>= 0.00005) && it>0) estimateMLE (currentEstimation, ambiguousCounts, ambiguousPartnerPointers, totalCounts, it-1, secondCurrentEstimation, thirdCurrentEstimation, fourthCurrentEstimation, solvedArray);
};

   


  

}
#endif
