/* File: AssociateContainer.cpp */


#ifndef __AssociateContainer_cpp__
#define __AssociateContainer_cpp__




#include "AssociateContainer.h"




/**
@memo Declaration of a list (FIFO)
@doc
*/


namespace BIOS
{

  /************************/
  /* list DEFINITION */
  /************************/


  /**
  @memo list 

    @doc
    Definition:
    A set of list's features 
    
  	Memory space: O(SizeP), which SizeP being the number of elements in the list
  	
  	  @author Maria Mar Abad Grau<< "\n
  	  @version 1.0
  */



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/

  /*____________________________________________________________ */

  template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> >class Cont, class T> 
  AssociateContainer<Cont, T>::AssociateContainer(char* filename, char* tokens, char outputSeparator):Cont<T>()
  {
   init(outputSeparator);
   this->getInfo(filename, tokens);
  }

  /*___________________________________________________________________________________________*/

   template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> >class Cont, class T> 
   AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::clone()
   {
      return new AssociateContainer<Cont, T>(*this); 
      //return new AssociateContainer((AssociateContainer&)*this);
   }
 /*___________________________________________________________________________________________*/

  template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> >class Cont, class T> 
  void AssociateContainer<Cont, T>::init(char outputSeparator)
  {    
     this->outputSeparator=outputSeparator;
  }
/*____________________________________________________________ */

  template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> >class Cont, class T> 
  AssociateContainer<Cont, T>::AssociateContainer(char outputSeparator):Cont<T>()
  {
    init(outputSeparator);
  }
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  int AssociateContainer<Cont, T>::size()
  {
     return (int)this->Cont<T>::size();
  }

/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::empty() 
  {
     if (this->begin()!=this->end())this->removeNode(this->begin(), this->end()); 
  };
 /*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T>   
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::getFirst() 
  {
     return this->begin();
  };

/*____________________________________________________________ */


  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::getNext(typename AssociateContainer<Cont, T>::iterator iterator2) 
  {
     return ++iterator2;
  };

/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T>  
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::getLast() 
  {
     return this->end();
  };

/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T& AssociateContainer<Cont, T>::getFirstElement() 
  {
     return this->front();
  };
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T& AssociateContainer<Cont, T>::getLastElement() 
  {
     return this->back();
  };
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T& AssociateContainer<Cont, T>::getElement(typename AssociateContainer<Cont, T>::iterator it) 
  {
     return (T&)*it;
  };

/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T& AssociateContainer<Cont, T>::getElement(int position) 
  {
     return this->at(position);
  };

/***************************************/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::removeNode(typename AssociateContainer<Cont, T>::iterator it, typename AssociateContainer<Cont, T>::iterator it2) 
  {
     typename AssociateContainer<Cont, T>::iterator i2=it;

     while (i2!=this->end() && i2!=it2) 
     {
        //cout << "\n" << this->getElement(i2);
        //i3=this->getNext(i2);
        i2=removeNode(i2);
        //erase(i2);
        //i2=i3;
     }

     //for (typename AssociateContainer<Cont, T>::iterator i=it; i!=it2 && i!=this->end();i++)
     //erase(i);
     //i2=removeNode(i);

     //cout <<"end\n";
     return i2;
  };

/******************************************************************/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::removeNode(typename AssociateContainer<Cont, T>::iterator it) 
  {
     typename AssociateContainer<Cont, T>::iterator it2=this->getNext(it);
     zap(this->getElement(it));
     return it2; //this->erase(it);
  };

/*______________________________________________________*/
/*
  template<> intList::iterator intList::removeNode(intList::iterator it) 
  {
     return erase(it);//this->getNext(it);
     //cout << "insiderem\n";
     //return this->erase(it);
  };

/******************************************************************/
/*
  template <> floatList::iterator floatList::removeNode(floatList::iterator it) 
  {
     return erase(it);
     //cout << "insiderem\n";
     //return this->getNext(it);
     //zap(this->getElement(it));
     //return it2; //this->erase(it);
  };
/******************************************************************/
/*
  template <> stringList::iterator stringList::removeNode(stringList::iterator it) 
  {
    return erase(it);
  };
/******************************************************************/
/*
  template <> doubleList::iterator doubleList::removeNode(doubleList::iterator it) 
  {
    return erase(it);
  };

/******************************************************************/
/*
  template <> longLongList::iterator longLongList::removeNode(longLongList::iterator it) 
  {
    return erase(it);
  };

  /*____________________________________________________________ */

 
  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::removeNode(int position) 


  {
     return removeNode(getNode(position));
  };

  /*____________________________________________________________ */

   template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::getNode(int position)   
{
     typename AssociateContainer<Cont, T>::iterator it=this->begin(); for (int i=0;i<position;i++) ++it; return it;
  };

  /*____________________________________________________________ */


  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  int AssociateContainer<Cont, T>::getPosition(typename AssociateContainer<Cont, T>::iterator it) 
  {
    typename AssociateContainer<Cont, T>::iterator it2; 
    int pos=0; 
    for (it2=this->begin();it2<it;++it2)
       ++pos; 
    return pos;
  };



  /*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  bool AssociateContainer<Cont, T>::includes(AssociateContainer<Cont, T>* Source)  
  {
   if (Source==NULL) 
   {
      cout <<"Error in AssociateContainer<Cont, T>::includes";
      end();
   }
 
   if(this->size()<Source->size()) return false;
   typename AssociateContainer<Cont,T>::iterator p=Source->getFirst();
   while(p!=Source->end())
   {
      if (findElement(getElement(p))==this->end()) return false;
      p=Source->getNext(p);
   }
   return true;
  }
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::changeElementAtPos(T element, int pos)
  {
     this->removeNode(pos);
     this->insertElementAtPos(element, pos);
  }

/*____________________________________________________________ */

  template <template   <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>::AssociateContainer(int t, char outputSeparator):Cont<T>()
  {
    init(outputSeparator);
    for (int i=0; i<t;i++)
      this->insertElement(i);
  }
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>::AssociateContainer( AssociateContainer<Cont, T> &source):Cont<T>(source) 
  {
   // this->outputSeparator=source.outputSeparator;
/*
   typename AssociateContainer<Cont, T>::iterator it=source.getFirst();
   T* val;
   while (it!=source.end())
   {
   val=new T(source.getElement(it));
   insertElement(*val);
cout << "\n" << *val;
   it=source.getNext(it);
   }
*/
      init(source.outputSeparator);
   }

/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>::AssociateContainer(typename AssociateContainer< Cont, T>::iterator first, typename AssociateContainer<Cont, T>::iterator last, char outputSeparator):Cont<T>(first, last) 
  {
     init(outputSeparator);
  }


/*___________________________________________________________ */
/*
   template <template <class> class Cont, class T> void AssociateContainer<Cont, T>::readInfo (ifstream * is, char* tokens)
  {

char a,b;
 a=is->get();
 if (a!=EOF) b=is->get();
int i =0;
    while (a!=EOF && b!=EOF)
    {
     is->putback(b);
     is->putback(a);
    insertElement(readElement(is, tokens));
a=is->get();
 if (a!=EOF) b=is->get();
i++;
//cout << "\nsig: " << i;
  }

  }

/*___________________________________________________________ */
/*
   template <template <class> class Cont, class T> void AssociateContainer<Cont, T>::readInfo (ifstream * is, char* tokens)
  {

    while (!is->eof())
    {
//     is->putback(b);
//     is->putback(a);
    insertElement(readElement(is, tokens));
//a=is->get();
 //if (a!=EOF) b=is->get();
//cout << "\nsig: " << i;
  }

  }


  /* _____________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T AssociateContainer<Cont, T>::readElement (ifstream * source, char* tokens)
  {
    T val, val2;
    char* genotypebuf=NULL;//new char[100000];//NULL;
//source->getline(&genotypebuf[0], 100000);
//cout <<"\ntotal read chars:" << source->gcount() <<"\n";
    genotypebuf=CaptureLine(source);
    val2=fromString(val, string(genotypebuf));
    zaparr(genotypebuf);
    return val2;
  };
 /*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::getInfo(const char *FileName, char* tokens)
  {
    OpenInput(FileName, &InputFile);
  while (!InputFile.eof() && InputFile.peek()!=EOF && InputFile.peek()!='\n'  && InputFile.peek()!='\r')
    insertElement(readElement(&InputFile, tokens));
    InputFile.close();
  };
/*___________________________________________________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::insertElement(T element)
  {
     // it should not work for Cont=set; if Cont=set, use just insert(element)
     insert(this->end(), (const T&)element);
  }  

/*___________________________________________________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::insertElementAtPos(T element, int pos)
  {
    insert(getNode(pos), (const T&)element);
  }  
/*___________________________________________________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::insertElementAtPointer(T element, typename Cont<T>::iterator it)
  {
    insert(it, element);
  }  

/*___________________________________________________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::insertElementFromString(string s)
  {
    T e;
    insertElement(fromString(e, s));
  }
    
/*___________________________________________________________________________________________*/

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  typename AssociateContainer<Cont, T>::iterator AssociateContainer<Cont, T>::findElement(T& element)
  {
     return find(this->begin(), this->end(), element);
  }
   
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T* AssociateContainer<Cont, T>::getTable()
  {
    T*elements=new T[this->size()];
    int i=0;
    typename AssociateContainer<Cont, T>::iterator p=this->getFirst();
    while (p!=this->end())
    {
      elements[i]=this->getElement(p);
      p=this->getNext(p);
      i++;
    }
    return elements;
  }
  
/*___________________________________________________________________________________________*/
/*
  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  intList* AssociateContainer<Cont, T>::getIntList()
  {
//it converts other primitive number list (like float or double) in an intList
    intList *primitiveList=new intList();
    typename AssociateContainer<Cont, T>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement((int)*p);
     
    return primitiveList;
  }
  
/*___________________________________________________________________________________________*/
/*
  template <> AssociateContainer<vector, int>* AssociateContainer<vector, string>::getListFromString()
  {
//it converts other primitive number list (like float or double) in an intList
    AssociateContainer<vector, int> *primitiveList=new AssociateContainer<vector, int>();
    int wilk;
    AssociateContainer<vector, string>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement(fromString(wilk, (string)*p));
     
    return primitiveList;
  }
  
/*___________________________________________________________________________________________*/
  /*
  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, string>* AssociateContainer<Cont, T>::getStringList()
  {
//it converts other primitive number list (like float or double) in an intList
    AssociateContainer<Cont, string> *primitiveList=new AssociateContainer<Cont, string>();
    typename AssociateContainer<Cont, T>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement(tos(*p));
     
    return primitiveList;
  }
/*___________________________________________________________________________________________*/

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  T AssociateContainer<Cont, T>::pop()
  {
    T val=this->back();
    this->pop_back();
    return val;
  }

/*___________________________________________________________________________________________*/
/*
  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  intList* AssociateContainer<Cont, T>::getIntListFromPointerList()
  {
    intList *primitiveList=new intList();
    typename AssociateContainer<Cont, T>::iterator p=this->GetFirst();
    while (p!=this->end())
    {
      primitiveList->insertElement(this->GetElement(p)->getValue());
      p=this->GetNext(p);
    }
    return primitiveList;
  }
   /*___________________________________________________________________________________________*/
 /*___________________________________________________________________________________________*/
/*
    template <> Container<vector, Integer*>* AssociateContainer<set, >::getIntegerList()
  {
    Container<vector, Integer*> *integerList=new Container<vector, Integer*>();
    typename Container<Cont, T>::iterator p=this->getFirst();
    Integer* i;
    while (p!=this->end())
    {
      i=new Integer(this->getElement(p));
      integerList->insertElement(i);
      zap(i);
      p=this->getNext(p);
    }
    return integerList;
  }
 


/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::removeElements(bool* table)
  {
    int i=0;
    typename AssociateContainer::iterator p=getFirst(), p2;
    while (p!=this->end())
    {
      if (table[i])
       this->removeNode(p);
      p=this->getNext(p);
      i++;
     }
  }
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::removeElementsIn(AssociateContainer<Cont, T>* sourceList)
  {
    if (sourceList==NULL)
    {
      cout <<"Error in list::selectElementsByContents";
      end();
    }

    typename AssociateContainer::iterator p=sourceList->getFirst(), p2;
    while (p!=sourceList->end())
    {
      if (this->findElement(sourceList->getElement(p))!=this->end())
       this->removeNode(find(this->begin(), this->end(), sourceList->getElement(p)));
      p=sourceList->getNext(p);
     }
  }
  /*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<set, int>* AssociateContainer<Cont, T>::copyPositionsByContents(AssociateContainer<Cont, T>* sourceList, int type)
  {
    if (sourceList==NULL)
    {
      cout <<"Error in list::selectElementsByContents";
      end();
    }

    typename AssociateContainer<Cont, T>::iterator p=this->getFirst();
    int i=0;
//cout <<"spaatorthisis" << this->outputSeparator <<"her\n";

    intSet* newList=new intSet(this->outputSeparator);
//cout <<"spaatornewsis" << newList->outputSeparator <<"her\n";
//cout <<"this size is:" << this->size() <<"\n";
    while (p!=this->end())
    {
      if ((type==1 && sourceList->findElement(this->getElement(p))==sourceList->end()) ||  (type==0 && sourceList->findElement(this->getElement(p))!=sourceList->end()))
        newList->insertElement(i);
      ++p;
      i++;
    }
    return newList;
  }
  /*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsByContents(AssociateContainer<Cont, T> * Source, int type, bool orderedByThis)
  {
    // type=0: common, 1: different
//cout <<"2spaatorthisis" << this->outputSeparator <<"her\n";

    intList* newList=this->copyPositionsByContents(Source, type);
//cout <<"intsize:" << newList->size() <<"\n";
//cout <<"2spaatornewsis" << newList->outputSeparator <<"her\n";
    AssociateContainer<Cont, T> *result=this->copyElementsWithPositionsIn(newList, orderedByThis);

    zap(newList);
    return result;
  }


  /*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsByPositions(intSet* sourceList, int type, bool orderedByThis)
  // type 0; copywith, 1: copyWithout
  {
    if (sourceList==NULL)
    {
      cout <<"Error 1 in AssociateContainer::copyElementsByPositions";
      end();
    }
       AssociateContainer<Cont, T>* newList=this->clone();
    newList->empty();
    if (orderedByThis)
    {
     typename AssociateContainer::iterator p;
      p=this->getFirst();
      int pos=0;
      while (p!=this->end())
      {
        if ((type==0 && sourceList->findElement(pos)!=sourceList->end() ) || (type==1 && sourceList->findElement(pos)==sourceList->end()))
          newList->insertElement(this->getElement(p));
        ++p;
        pos++;
      }
    }
    else
    {
     typename intSet::iterator p2;
    if (type==1) 
    {
       cout <<"Error 2 in AssociateContainer::copyElementsByPositions";
      end();
    }
      p2=sourceList->getFirst();
      while (p2!=sourceList->end())
      {
        newList->insertElement(this->getElement(sourceList->getElement(p2)));
        ++p2;
      }
    }
    return newList;
  }
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::extractElementsByPositions(intSet* sourceList, int type, bool orderedByThis)
  // type 0: extractWith, 1: extractWithout
  {
     typedef typename vector<struct node*>::iterator NP;
     vector<NP>* listPos=new vector<NP>();
     int i=0;
     typename AssociateContainer<Cont, T>::iterator p=this->GetFirst();
     while (p!=this->end())
     {
        if ((type==0 && sourceList->findElement(i)!=sourceList->end() ) || (type==1 && sourceList->findElement(i)==sourceList->end())) 
           listPos->insertElement((NP)p);
        p=this->getNext(p);
        i++;
     }
     if (listPos->size()!=sourceList->size())
     {
        cout <<"Error in AssociateContainer::extractElementsByPositions";
        cout <<"Some positions of " <<*sourceList << "are beyond the size of the container, which has size " << this->GetSize() <<" or the position list has repeated positions";
     }

     AssociateContainer<Cont, T>* newList=copyElementsByPositions(sourceList, type, orderedByThis);
     typename vector<NP>::iterator p2;

     p2=listPos->GetFirst();
     while (p2!=listPos->end())
     {
        this->removeNode((typename AssociateContainer<Cont, T>::iterator)listPos->getElement(p2));
        p2=listPos->GetNext(p2);
     }
     zap(listPos);
     return newList;
  };

 /*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::mergeWith(AssociateContainer<Cont, T>* secondList)
  {
     AssociateContainer<Cont, T>* result=new  AssociateContainer<Cont, T>();

     merge(this->begin(), this->end(),    // merge sequences
        secondList->begin(), secondList->end(),
        result->begin());


	/*
	   AssociateContainer<Cont, T>* result=new  AssociateContainer<Cont, T>();
	   typename AssociateContainer<Cont, T>::iterator p=this->GetFirst(), p2=secondList->GetFirst();
	   while (p!=this->end() || p2!=NULL)
	 {
	 while (p!=this->end() && 
	(p2!=NULL && this->GetElement(p)>=secondList->GetElement(p2)) || p2==NULL)
	{
	  result->insertElement(GetElement(p));
	  p=this->GetNext(p);
	}
	 while (p2!=NULL && 
	(p!=this->end() && this->GetElement(p)<secondList->GetElement(p2)) || p==NULL)
	{
	  result->insertElement(secondList->GetElement(p2));
	  p2=secondList->GetNext(p2);
	}
	 }
	*/
    return result;
  }
 /*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsWithPositionsIn(intSet * sourceList, bool orderedByThis)
  {
    return copyElementsByPositions(sourceList, 0, orderedByThis);
  }
  
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsWithoutPositionsIn(intSet* sourceList)
  {
    return copyElementsByPositions(sourceList, 1);
  }
   
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::copyPaste(AssociateContainer<Cont, T>* sourceList)
  {
    AssociateContainer<Cont, T>* copy=sourceList->clone();
    this->insert(this->end(), copy->begin(), copy->end()); 
  };
   /*____________________________________________________________ */


  template <template   <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::extractElementsWithPositionsIn(intSet * sourceList)
  {
    return extractElementsByPositions(sourceList, 0);
  };
  /*____________________________________________________________ */


  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::extractElementsWithoutPositionsIn(intSet * sourceList)
  {
    return extractElementsByPositions(sourceList, 1);
  };
  
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T>
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsIn(AssociateContainer<Cont, T> * Source, bool orderedByThis)
  {
    return copyElementsByContents(Source, 0, orderedByThis);
  }
  
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::copyElementsNotIn(AssociateContainer<Cont, T> * Source, bool orderedByThis)
  {
    return copyElementsByContents(Source, 1, orderedByThis);
  }
  
/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<set, int>* AssociateContainer<Cont, T>::copyPositionsWithElementsIn(AssociateContainer<Cont, T> * Source)
  {
    return copyPositionsByContents(Source, 0);
  }
  
/*____________________________________________________________ */

  template <template  <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<set, int>* AssociateContainer<Cont, T>::copyPositionsWithoutElementsIn(AssociateContainer<Cont, T> * Source)
  {
    return copyPositionsByContents(Source, 1);
  }

/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::order(bool ascendant) 
  {
    if (ascendant) sort(this->begin(), this->end(), compare<T>);
    else sort(this->begin(), this->end(), compareinv<T>);
  };

/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::orderPointer(bool ascendant) 
  {
    if (ascendant) sort(this->begin(), this->end(), comparePointer<T>);
    else sort(this->begin(), this->end(), compareinvPointer<T>);
  };

/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  void AssociateContainer<Cont, T>::basicOrder() 
  {
    sort(this->begin(), this->end());
  };

/*____________________________________________________________ */

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> 
  AssociateContainer<Cont, T>* AssociateContainer<Cont, T>::reverse()
  {
    AssociateContainer<Cont, T>* result=new AssociateContainer<Cont, T>();
    typename AssociateContainer<Cont, T>::iterator p=this->GetLast();

    while (p!=this->end())
    {
      result->insertElement(this->GetElement(p));
      p=this->GetPrevious(p);
    }
    return result;
  }
    /*______________________________________________________*/

  template <template <class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T>
  ostream& operator<<(ostream& out, AssociateContainer<Cont, T>& l)
  {
    for (typename AssociateContainer<Cont, T>::iterator p = l.begin(); p != l.end(); p++)
    {
       out << l.getElement(p); 
       if (l.size()>1) if (p!= l.end()-1 && l.outputSeparator!='\0') out <<l.outputSeparator; 
       //if (p==l.end()-1) out <<")";
    }
    return out;
  }

  
/*______________________________________________________*/

  ostream& operator<<(ostream& out, longLongSet& lista)
  {
    out <<"(";
    longLongSet::iterator p=lista.getFirst();
    while (p!=lista.end())
    {
      out << lista.getElement(p);
      p=lista.getNext(p); 
      if (p!=lista.end()) out <<","; else out <<")";
    }
    out <<"\n";
 
    return out;
  }

/*______________________________________________________*/

  ostream& operator<<(ostream& out, intSet& lista)
  {
    out <<"(";
    intSet::iterator p=lista.getFirst();
    while (p!=lista.end())
    {
       out << lista.getElement(p);
       p=lista.getNext(p); 
      if (p!=lista.end()) out <<","; else out <<")";
    }
     out <<"\n";
 
    return out;
  }

/*______________________________________________________*/

  ostream& operator<<(ostream& out, floatSet& lista)
  {
    out <<"(";
    floatSet::iterator p=lista.getFirst();
    while (p!=lista.end())
    {
       out << lista.getElement(p);
       p=lista.getNext(p); 
       if (p!=lista.end()) out <<","; else out <<")";
    }
    out <<"\n";
 
    return out;
  }

/*______________________________________________________*/

  ostream& operator<<(ostream& out, stringSet& lista)
  {
    stringSet::iterator p=lista.getFirst();
    //out <<"(";
    while (p!=lista.end())
    {
      out << lista.getElement(p);
      p=lista.getNext(p); 
      if (p!=lista.end()) out <<lista.outputSeparator; //else out <<")";
    }
    out <<"\n";
    return out;
  }

/*______________________________________________________*/

  ostream& operator<<(ostream& out, doubleSet& lista)
  {
    doubleSet::iterator p=lista.getFirst();
    out <<"(";
    while (p!=lista.end())
    {
      out << lista.getElement(p);
      p=lista.getNext(p); 
      if (p!=lista.end()) out <<","; else out <<")";
    }
    out <<"\n";
    return out;
  }

/*______________________________________________________*/
/*
  template <class T, class U> ostream& operator<<(ostream& out, map<T, U>& lista)
  {
    typename map<T, U>::iterator pointer;
    for (pointer=lista.begin(); pointer!=lista.end(); pointer++)
      out <<"\n" <<pointer->first <<"\t---->\t" << pointer->second;
    out <<"\n";
    return out;
  }

  /*____________________________________________________________ */

  
 
  
} // end namespace
#endif

/* Fin Fichero: list.cpp */
// void zap<list<float>::node*>(list<float>::node*&);


