/* File: Container.cpp */


#ifndef __Container_cpp__
#define __Container_cpp__




#include "Container.h"




/**
@memo Declaration of a list (FIFO)
@doc
*/


namespace BIOS
{

  /************************/
  /* list DEFINITION */
  /************************/


  /**
  @memo list 

    @doc
    Definition:
    A set of list's features 
    
  	Memory space: O(SizeP), which SizeP being the number of elements in the list
  	
  	  @author Maria Mar Abad Grau<< "\n
  	  @version 1.0
  */


  


 /*______________________________________________________*/

  template <class Cont, class T> 
void order (Container<Cont, T>* const & l, bool ascendant)
{
l->sort(ascendant);
}

 /*______________________________________________________*/

  template <class Cont, class T> 
void order (Container<Cont, T*>* const  & l, bool ascendant)
{
l->sortPointer(ascendant);
}




 /*______________________________________________________*/

  template <class Cont, class T> 
ostream& operator<<(ostream& out, Container<Cont, T>& l)
{
int pos;
    for (typename Container<Cont, T>::iterator p = l.begin(); p != l.end(); p++)
{
if (p==l.begin() && l.leftDelimiter!='\0') out << l.leftDelimiter;
       out << *p; 
   
p++;
if (l.size()>1 && p!= l.end() && l.outputSeparator!='\0') out <<l.outputSeparator; 
if (p==l.end() && l.rightDelimiter!='\0') out <<l.rightDelimiter;
p--;
}
return out;
}
 /*______________________________________________________*/

  template <class Cont, class T> 
ostream& operator<<(ostream& out, Container<Cont, T*>& l)
{
    for (typename Container<Cont, T*>::iterator p = l.begin(); p != l.end(); p++)
{
if (p==l.begin() && l.leftDelimiter!='\0') out << l.leftDelimiter;
     if (*p!=NULL)  out << **p; else out <<"null\n";

p++;
   if (l.size()>1 && p!= l.end() && l.outputSeparator!='\0') out <<l.outputSeparator; 
if (p==l.end() && l.rightDelimiter!='\0') out <<l.rightDelimiter;
p--;
}
return out;
}

  
/*______________________________________________________*/

//  template <> 
//ostream& operator<<(ostream& out, Container<vector, long long int>& lista)
/*
   ostream& operator<<(ostream& out, longLongList& lista)
  {
out <<"(";
    longLongList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         out << lista.getElement(p);
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<","; else out <<")";
    }
     out <<"\n";
    return out;
  }
/*______________________________________________________*/
/*
   ostream& operator<<(ostream& out, intList& lista)
  {
out <<"(";
    intList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         out << lista.getElement(p);
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<","; else out <<")";
    }
     out <<"\n";
 
    return out;
  }


  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/


/*____________________________________________________________ */

 template <class Cont, class T> 
Container<Cont, T>::Container(int t, bool startAtOne, char outputSeparator, char leftDelimiter, char rightDelimiter):Cont()
  {
    init(outputSeparator, leftDelimiter, rightDelimiter);
for (int i=startAtOne; i<(t+startAtOne);i++)
 this->insertElement(i);
  }
/*____________________________________________________________ */

   template <class Cont, class T> Container<Cont, T>::Container( Container<Cont, T> &source):Cont() 
  {
for (typename Container<Cont,T>::iterator it=source.begin(); it!=source.end(); it++)
 this->insertHardElement(*it);
   init(source.outputSeparator, source.leftDelimiter, source.rightDelimiter);
   }

/*____________________________________________________________ */

   template <class Cont, class T>    template <class Cont2, class U> Container<Cont, T>::Container( Container<Cont2, U> &source):Cont() 
  {
   // this->outputSeparator=source.outputSeparator;

   for (typename Container<Cont2, T>::iterator it=source.getFirst(); it!=source.end(); it++)
   insertElement(*it);

   init(source.outputSeparator, source.leftDelimiter, source.rightDelimiter);
   }

/*____________________________________________________________ */

   template <class Cont, class T>    template <class Cont2, class U> Container<Cont, T>::Container( Container<Cont2, U*> &source):Cont() 
  {
   // this->outputSeparator=source.outputSeparator;

   for (typename Container<Cont2, T>::iterator it=source.getFirst(); it!=source.end(); it++)
   insertElement(new U(*it));

   init(source.outputSeparator, source.leftDelimiter, source.rightDelimiter);
   }

/*____________________________________________________________ */

 template <class Cont, class T> 
Container<Cont, T>::Container(Container &source, typename Container< Cont, T>::iterator first, typename Container<Cont, T>::iterator last):Cont(source) 
  {
   if (first>last) throw BadFormat("Container(Container &source, typename Container< Cont, T, STL2>::iterator first, typename Container<Cont, T>::iterator last");
   int iniPos=source.getPosition(first), lastPos=source.getPosition(last);
   this->removeObjects(this->begin()+lastPos+1, this->end());
   this->removeObjects(this->begin(), this->begin()+iniPos);
     init(outputSeparator, leftDelimiter, rightDelimiter);
   }




  /*____________________________________________________________ */

template <class Cont, class T> 
Container<Cont, T>::Container(const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter):Cont()
  {
 init(outputSeparator, leftDelimiter, rightDelimiter);
   this->getInfo(filename, tokens);
  }

  /*___________________________________________________________________________________________*/


   template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::clone()
{
return new Container<Cont, T>(*this); 
}

  /*___________________________________________________________________________________________*/


   template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::emptyCopy()
{
Container<Cont,T>* result=new Container<Cont, T>(); 
result->init(this->outputSeparator, this->leftDelimiter, this->rightDelimiter);
return result;
}
 /*___________________________________________________________________________________________*/

template <class Cont, class T> void Container<Cont, T>::init(char outputSeparator, char leftDelimiter, char rightDelimiter)
  {
    
    this->outputSeparator=outputSeparator;
    this->leftDelimiter=leftDelimiter;
    this->rightDelimiter=rightDelimiter;
     }
/*____________________________________________________________ */

      template <class Cont, class T> Container<Cont, T>::Container(char outputSeparator, char leftDelimiter, char rightDelimiter):Cont()
  {
    init(outputSeparator, leftDelimiter, rightDelimiter);
  }
/*____________________________________________________________ */

template <class Cont, class T> int Container<Cont, T>::size()
  {
return (int)this->Cont::size();
  }

/*____________________________________________________________ */

template <class Cont, class T> void Container<Cont, T>::empty() 
{
//if (this->begin()!=this->end()) 
this->removeObjects(0, this->size()); 
};
 /*____________________________________________________________ */

template <class Cont, class T>   typename Container<Cont, T>::iterator Container<Cont, T>::getFirst() 
{
return (typename Container<Cont, T>::iterator) this->begin();
};

/*____________________________________________________________ */

 template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNext(typename Container<Cont, T>::iterator iterator2) 
{
return ++iterator2;
};
/*____________________________________________________________ */

template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getPrevious(typename Container<Cont, T>::iterator iterator2) 
{
return --iterator2;
};

/*____________________________________________________________ */

 template <class Cont, class T>  typename Container<Cont, T>::iterator Container<Cont, T>::getLast() 
{
return (typename Container<Cont, T>::iterator)this->end();
};

/*____________________________________________________________ */

 template <class Cont, class T> T& Container<Cont, T>::getFirstElement() 
{
return this->front(); //getElement(this->end()); // this->front()
};
/*____________________________________________________________ */

 template <class Cont, class T> T& Container<Cont, T>::getLastElement() 
{
return this->back(); //getElement(this->begin()); //this->back();
};
/*____________________________________________________________ */

 template <class Cont, class T> T& Container<Cont, T>::getElement(typename Container<Cont, T>::iterator it) 
{
return (T&)*it;
//return this->getElement(this->getPosition(it));
};
/*____________________________________________________________ */
/*
 Container<Cont, T>T* Container<Cont, T*, STL2>::getElement(typename Container<Cont, T*, STL2>::iterator it) 
{
return (T*)*it;
};


/*____________________________________________________________ */

 template <class Cont, class T> void Container<Cont, T>::setOutputSeparator(char outputSeparator) 
{
this->outputSeparator=outputSeparator;
};

/*____________________________________________________________ */

 template <class Cont, class T> void Container<Cont, T>::setDelimiters(char leftDelimiter, char rightDelimiter) 
{
this->leftDelimiter=leftDelimiter;
this->rightDelimiter=rightDelimiter;
};

/*____________________________________________________________ */

template <class Cont, class T> void Container<Cont, T>::insertElement(typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second) 
{
return this->insert(this->end(), first, second);
};

/*____________________________________________________________ */

/*
template <class T, template <class> class STL2=std::less>
void Set<T>::Class::insertElement(typename Set<T>::iterator first, typename Set<T>::iterator second) 
{
return this->insert(this->end(), first, second);
};

/*____________________________________________________________ */

template<>// gcc 4.1.2. Try template template partial specialization in future g++ compilers (with 
void Container<set<Node*>, Node*>::insertElement(Container<set<Node*>, Node*>::iterator first, Container<set<Node*>, Node*>::iterator second) 
{
return this->insert(first, second);
};


/*____________________________________________________________ */

 template <class Cont, class T> T& Container<Cont, T>::getElement(int position) 
{
return this->at(position);

//return this->getElement(this->getNode(position));
};



/*____________________________________________________________ */


template <>
Attribute*& SetOfAttributes::getElement(int position) 
{
throw NonImplemented("Attribute*& SetOfAttributes::getElement(int position) , nonsense");
//return this->at(position);
//return this->getElement(this->getNode(position));
};

/*____________________________________________________________ */

//template <class T, template <class> class STL2>
//T&  Set< T>::Class::getElement(int position) 
template <>
Clique*& SetOfCliques::getElement(int position) 
{
throw NonImplemented("Clique*& SetOfCliques::getElement(int position) , nonsense");
//return this->at(position);
//return this->getElement(this->getNode(position));
};
/*____________________________________________________________ */

//template <class T, template <class> class STL2>
//T&  Set< T>::Class::getElement(int position) 
template <>
Node*& NodeSet::getElement(int position) 
{
throw NonImplemented("Node*& NodeSet::getElement(int position) , nonsense");

//return this->at(position);
//return this->getElement(this->getNode(position));
};



/*____________________________________________________________ */
/*
// Container<Cont, T>
template <template <class T, typename _Alloc=std::allocator<T> > class Vector<T>::Class, class T> 
//template < template < class T, typename _Alloc=std::allocator<T> > class classCont=vector, class T > 
 T&  Container<vector<T>, T>::getElement(int position) 

//template <> int& intV::getElement(int position)
{
return this->at(position);
};


/***************************************/

template <class Cont, class T> 
void Container<Cont, T>::removeNode(typename Container<Cont, T>::iterator it) 
{
//T val=this->getElement(it);
//
//this->removeNodeWithObject(p, it);
zap(it);
this->erase(it);
};
/***************************************/
/*
 Container<Cont, T>
void Container<Cont, typename Selec<IsPrimitive<T>::r, T, void>::R NewT, STL2>::removeNodeWithObject(Primitive p, typename Container<Cont, T>::iterator it) 
{
this->erase(it);
}
};
/***************************************/

template <class Cont, class T> 
void Container<Cont, T>::removeObjects(typename Container<Cont, T>::iterator it, typename Container<Cont, T>::iterator it2) 
{
for (typename Container<Cont, T>::iterator it1=it; it1!=it2; it1++)
zap(*it1);
this->erase(it, it2);
};
/***************************************/

template <class Cont, class T> 
void Container<Cont, T>::removeObjects(int firstPos, int lastPos) 
{
this->removeObjects(this->getNode(firstPos), this->getNode(lastPos));
};



    	/*___________________________________________________________________________________*/

 
template <class Cont, class T> 
template <class U>   
typename Container<Cont, T>::iterator  
Container<Cont, T>::findElementContainingInternalElement(U& element)
{
typename Container<Cont, T>::iterator p=this->getFirst();
 Container<Cont, U> * secondContainer;
 while (p!=this->end())
{
	 secondContainer=getElement(p);
  if (secondContainer->findElement(element)!=secondContainer->end()) return p;
p=this->getNext(p);
}
return this->end();

  };

 /*____________________________________________________________ */

template <class Cont, class T> 
void Container<Cont, T>::removeNode(int position) 
{
removeNode(getNode(position));
};

  /*____________________________________________________________ */

template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNode(int position) 
{
typename Container<Cont, T>::iterator it=this->begin(); 
for (int i=0;i<position;i++) ++it; return it;
};
  /*____________________________________________________________ */


template <class Cont, class T> int Container<Cont, T>::getPosition(typename Container<Cont, T>::iterator it) 
{
typename Container<Cont, T>::iterator it2; 
int pos=0; 
for (it2=this->begin();it2!=it;++it2)
 ++pos; 
return pos;
};
 /*____________________________________________________________ */


 template <class Cont, class T> 
Container<set<Integer*>, Integer*>* Container<Cont,T>::getIntegerSetFromIntegerList()
  {
    Container<set<Integer*>, Integer*> *integerSet=new Container<set<Integer*>, Integer*>();
    typename Container<vector<Integer*>, Integer*>::iterator p=this->getFirst();
    Integer* i;
    while (p!=this->end())
    {
      i=new Integer(*this->getElement(p));
      integerSet->insert(i);
      zap(i);
      p=this->getNext(p);
    }
    return integerSet;
  }

  /*____________________________________________________________ */

  template <class Cont, class T> bool Container<Cont, T>::includes(Container<Cont, T> * Source)
  {
   if (Source==NULL) 
   {
	   cout <<"Error in Container<Cont, T>::includes";
	   end();
   }
 
   if(this->size()<Source->size()) return false;
   typename Container<Cont,T>::iterator p=Source->getFirst();
   while(p!=Source->end())
   {
	   if (findElement(getElement(p))==this->end()) return false;
	   p=Source->getNext(p);
   }
   return true;
  }
/*____________________________________________________________ */

template <class Cont, class T> void Container<Cont, T>::changeElementAtPos(T element, int pos)
  {
this->removeNode(pos);
 this->insertElementAtPos(element, pos);
 
  }


  /*___________________________________________________________ */

   template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getClosestGreaterPointerToElement(T argument, bool checkOrder)
  {
// precond: this must be ordered
    if (checkOrder==true)
    {
      cout <<"Error in list<T>::getClosestGreaterPointerToElement, not ordered";
      exit(0);
    }
    // it returns a pointer to the element in the list which has the closest upper value than argument
    typename Container<Cont, T>::iterator pk=this->getFirst();


    while (pk!=this->end())
    {
   
      if (*this->getElement(pk)>*argument) return pk;// change to make it works for primitive values

      pk=this->getNext(pk);
    }
    return pk;
  };
/*___________________________________________________________ */
/*
    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
  {

char a,b;
 a=is->get();
 if (a!=EOF) b=is->get();
int i =0;
    while (a!=EOF && b!=EOF)
    {
     is->putback(b);
     is->putback(a);
    insertElement(readElement(is, tokens));
a=is->get();
 if (a!=EOF) b=is->get();
i++;
//cout << "\nsig: " << i;
  }

  }

/*___________________________________________________________ */
/*
    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
  {

    while (!is->eof())
    {
//     is->putback(b);
//     is->putback(a);
    insertElement(readElement(is, tokens));
//a=is->get();
 //if (a!=EOF) b=is->get();
//cout << "\nsig: " << i;
  }

  }


  /* _____________________________________________________*/

    template <class Cont, class T> T Container<Cont, T>::readElement (ifstream * source, const char* tokens, int* pos, int size)
  {
    T val, val2;
    char* genotypebuf=NULL;//new char[100000];//NULL;
//source->getline(&genotypebuf[0], 100000);
//cout <<"\ntotal read chars:" << source->gcount() <<"\n";
    genotypebuf=CaptureLine(source);
    val2=BIOS::fromString(val, string(genotypebuf));
    zaparr(genotypebuf);
    return val2;
  };
 /*____________________________________________________________ */

    template <class Cont, class T> void Container<Cont, T>::getInfo(const char *FileName, const char* tokens, int* pos, int size)
  {
T element;
    OpenInput(FileName, &InputFile);
  while (!InputFile.eof() && InputFile.peek()!=EOF && InputFile.peek()!='\n'  && InputFile.peek()!='\r')
{
T el=readElement(&InputFile, tokens, pos, size);
    insertElement(el);
}
    InputFile.close();
  };
/*___________________________________________________________________________________________*/

   template <class Cont, class T> void Container<Cont, T>::insertHardElement(const T*& element)
  {
// it should not work for Cont=set; if Cont=set, use just insert(element)
//cout << "lement " << element << " is about to be inserted\n";
T* element2=new T(element);
this->insert(this->end(), (const T&)element2);

//cout << "lsat element inserted was:" << getLastElement() <<"\n";

  }  
/*___________________________________________________________________________________________*/

   template <class Cont, class T> void Container<Cont, T>::insertHardElement(const T& element)
  {
this->insertElement(element);

  }  


/*___________________________________________________________________________________________*/

   template <class Cont, class T> void Container<Cont, T>::insertElement(T element)
  {
this->insert(this->end(), (const T&)element);
  }  

/*___________________________________________________________________________________________*/

  template <class Cont, class T> void Container<Cont, T>::insertElementAtPos(T element, int pos)
  {
    insert(getNode(pos), (const T&)element);

  }  
/*___________________________________________________________________________________________*/

   template <class Cont, class T> void Container<Cont, T>::insertElementAtPointer(T element, typename Container<Cont, T>::iterator it)
  {
    insert(it, element);
  }  
/*___________________________________________________________________________________________*/

    template <class Cont, class T> void Container<Cont, T>::insertElementFromString(string s)
  {
T e;
   insertElement(fromString(e, s));
  }
    /*___________________________________________________________________________________________*/

    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T& element)
  {
 return find(this->begin(), this->end(), element);
  }

    /*___________________________________________________________________________________________*/

    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T*& element)
  {
 return find(this->begin(), this->end(), *element);
  }

    	/*___________________________________________________________________________________*/
/*
   Container<Cont, T>typename Container<Cont, T>::iterator  Container<Cont, T>::findElementContainingInternalElement(void* element)//
  {
// it only works whether element 	T is another container (void is used to avoid compiling errors when this condition does not hold
 iterator p=this->GetFirst();
 T * secondContainer;
 while (p!=this->end())
{
	 secondContainer=getElement(p);
  if (secondContainer->findElement((T&*)element)!=secondContainer->end()) return p;
p=this->GetNext(p);
}
return end();

  };
   /*____________________________________________________________ */

    template <class Cont, class T> T* Container<Cont, T>::getTable()
  {
	T*elements=new T[this->size()];
  int i=0;
   typename Container<Cont, T>::iterator p=this->getFirst();
    while (p!=this->end())
    {
      elements[i]=this->getElement(p);
      p=this->getNext(p);
	  i++;
    }
	return elements;
  }

 /*___________________________________________________________________________________________*/

    template <class Cont, class T> 
template <class Cont2, class U> 
Container<Cont2, U>* Container<Cont, T>::convertPrimitiveList(Container<Cont2, U> * cont)
  {
//it converts among different primitive lists
    cont=new Container<Cont2, U>();
    typename Container<Cont, T>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          cont->insertHardElement((U)*p);
     
    return cont;
  }

  /*___________________________________________________________________________________________*/

    template <class Cont, class T> 
intList* Container<Cont, T>::getIntList()
  {
//it converts other primitive number list (like float or double) in an intList

intList *primitiveList;
       return convertPrimitiveList(primitiveList);
  }

  /*___________________________________________________________________________________________*/

    template <class Cont, class T> 
floatList* Container<Cont, T>::getFloatList()
  {
//it converts other primitive number list (like float or double) in an intList
floatList *primitiveList;
       return convertPrimitiveList(primitiveList);
  }

  /*___________________________________________________________________________________________*/
/*
    Container<Cont, T>floatList* Container<Cont, T>::getFloatList()
  {
//it converts other primitive number list (like float or double) in an intList
    floatList *primitiveList=new intList();
    typename Container<Cont, T>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement((float)*p);
     
    return primitiveList;
  }
  /*___________________________________________________________________________________________*/
   template <> intList* stringList::getListFromString()
  {
//it converts a stringList in an intList
    intList *primitiveList=new intList();
    int wilk;
    stringList::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement(BIOS::fromString(wilk, (string)*p));
     
    return primitiveList;
  }
  /*___________________________________________________________________________________________*/
   template <class Cont, class T> stringList* Container<Cont, T>::getStringList()
  {
//it converts other primitive number list (like float or double) in a stringList
    stringList*primitiveList=new stringList();
    typename Container<Cont, T>::iterator p;
    for (p=this->begin(); p!=this->end();++p)
          primitiveList->insertElement(tos(*p));
     
    return primitiveList;
  }
/*___________________________________________________________________________________________*/

     template <class Cont, class T> T Container<Cont, T>::pop()
  {
T val=this->back();
this->pop_back();
return val;
  }

/*___________________________________________________________________________________________*/

     template <class Cont, class T> intList* Container<Cont, T>::getIntListFromPointerList()
  {
    intList *primitiveList=new intList();
    typename Container<Cont, T>::iterator p=this->getFirst();
    while (p!=this->end())
    {
      primitiveList->insertElement(*p->getValue());
      p=this->getNext(p);
    }
    return primitiveList;
  }
  /*___________________________________________________________________________________________*/

  template <> Container<vector<Integer*>, Integer*>* intList::getIntegerList()
  {
    Container<vector<Integer*>, Integer*> *integerList=new Container<vector<Integer*>, Integer*>();
    intList::iterator p=this->getFirst();
    Integer* i;
    while (p!=this->end())
    {
      i=new Integer(*p);
      integerList->insertHardElement(i);
      p=this->getNext(p);
    }
    return integerList;
  }
  /*___________________________________________________________________________________________*/

//template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator> 
 // template <>  
 template <>  
IntegerSet* intList::getIntegerSet()
  {
  Container<vector<Integer*>, Integer*> *integerList=this->getIntegerList();
  IntegerSet *integerSet=integerList->getIntegerSetFromIntegerList();
  zap(integerList);
  
    return integerSet;
  }

/*____________________________________________________________ */

    template <class Cont, class T> void Container<Cont, T>::removeElements(bool* table)
  {
    int i=0;
    typename Container::iterator p=getFirst(), p2;
    while (p!=this->end())
    {
      if (table[i])
       this->removeNode(p);
      p=this->getNext(p);
      i++;
     }
  }
/*____________________________________________________________ */

    template <class Cont, class T> void Container<Cont, T>::removeElementsIn(Container<Cont, T>* sourceList)
  {
    if (sourceList==NULL)
    {
      cout <<"Error in list::selectElementsByContents";
      end();
    }

    typename Container::iterator p=sourceList->getFirst(), p2;
    while (p!=sourceList->end())
    {
      if (this->findElement(sourceList->getElement(p))!=this->end())
       this->removeNode(find(this->begin(), this->end(), sourceList->getElement(p)));
      p=sourceList->getNext(p);
     }
  }
  /*____________________________________________________________ */

    template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsByContents(Container<Cont, T>* sourceList, bool within, bool orderedByThis)
  {
    if (sourceList==NULL)
    {
      cout <<"Error in list::selectElementsByContents";
      end();
    }

    intList* newList=new intList(this->outputSeparator, this->leftDelimiter, this->rightDelimiter);
    typename Container<Cont,T>::iterator p2;
    for (typename Container<Cont, T>::iterator p=sourceList->getFirst(); p!=sourceList->end(); p++)
    {
      p2=this->findElement(*p);
      if ((!within && p2==this->end()) ||  (within && p2!=this->end()))
{
//cout <<"\nelement " << *p <<" found at pos " << this->getPosition(p2);
        newList->insertElement(this->getPosition(p2));
}
    }
   if (within && orderedByThis) order(newList);
    return newList;
  }
  /*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsByContents(Container<Cont, T> * Source, bool within, bool orderedByThis)
  {
    // type=0: common, 1: different
//cout <<"2spaatorthisis" << this->outputSeparator <<"her\n";

    intList* newList=this->copyPositionsByContents(Source, within);
//cout <<"intsize:" << newList->size() <<"\n";
//cout <<"2spaatornewsis" << newList->outputSeparator <<"her\n";
    Container<Cont, T> *result=this->copyElementsWithPositionsIn(newList, orderedByThis);
    zap(newList);
    return result;
  }


  /*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn(intList* sourceList, bool orderedByThis)
  {
    if (sourceList==NULL) throw NullValue("Error 1 in Container::copyElementsByPositions");
 
       Container<Cont, T>* newList=this->emptyCopy();
    intList* sourceList2=new intList(*sourceList);

    if (orderedByThis)
    {
     typename Container::iterator p;
      p=this->getFirst();
      int pos=0;
      while (p!=this->end())
      {
        while (sourceList2->findElement(pos)!=sourceList2->end() )
        {
          newList->insertHardElement(*p);
          sourceList2->removeNode(sourceList2->findElement(pos));
         }
        ++p;
        pos++;
      }
    }
    else
    {
    
      intList::iterator p2=sourceList->getFirst();
      while (p2!=sourceList->end())
      {
        newList->insertHardElement(*this->getNode(*p2));
        ++p2;
      }
    }
    return newList;
  }
 /*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn(intList* sourceList)
  {
    if (sourceList==NULL) throw NullValue("Error 1 in Container::copyElementsWithoutPositionsIn");
 
       Container<Cont, T>* newList=new Container<Cont, T>();

  
     typename Container::iterator p;
      p=this->getFirst();
      int pos=0;
      while (p!=this->end())
      {
        if (sourceList->findElement(pos)==sourceList->end() )
          newList->insertHardElement(*p);
        ++p;
        pos++;
      }
   
    return newList;
  }

  /*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn(intSet* sourceSet, bool orderedByThis)
  // type 0; copywith, 1: copyWithout
  {
   intList* sourceList=new intList(*sourceSet);
   Container<Cont, T>* result=copyElementsWithPositionsIn(sourceList, orderedByThis); 
   zap(sourceList);
    return result;
  }
  /*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn(intSet* sourceSet)
  // type 0; copywith, 1: copyWithout
  {
   intList* sourceList=new intList(*sourceSet);
   Container<Cont, T>* result=copyElementsWithoutPositionsIn(sourceList); 
   zap(sourceList);
    return result;
  }
/*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsByPositions(intSet* sourceList, bool within, bool orderedByThis)
  // type 0: extractWith, 1: extractWithout
  {
typedef typename vector<struct node*>::iterator NP;
 vector<NP>* listPos=new vector<NP>();
  int i=0;
    typename Container<Cont, T>::iterator p=this->GetFirst();
    while (p!=this->end())
    {
if ((within && sourceList->findElement(i)!=sourceList->end() ) || (!within && sourceList->findElement(i)==sourceList->end())) 
    listPos->insertElement((NP)p);
    p=this->getNext(p);
i++;
    }
if (listPos->size()!=sourceList->size())
{
cout <<"Error in Container::extractElementsByPositions";
cout <<"Some positions of " <<*sourceList << "are beyond the size of the container, which has size " << this->GetSize() <<" or the position list has repeated positions";
}
   Container<Cont, T>* newList;
  if (within) newList=copyElementsWithPositionsIn(sourceList, orderedByThis);
  else newList=copyElementsWithoutPositionsIn(sourceList);
     typename vector<NP>::iterator p2;
      p2=listPos->GetFirst();
        while (p2!=listPos->end())
      {
       this->removeNode((typename Container<Cont, T>::iterator)listPos->getElement(p2));
       p2=listPos->GetNext(p2);
        }
   zap(listPos);
    return newList;
  };

 /*____________________________________________________________ */

   template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::mergeWith(Container<Cont, T>* secondList)
  {

  Container<Cont, T>* result=new  Container<Cont, T>();

  merge(this->begin(), this->end(),    // merge sequences
        secondList->begin(), secondList->end(),
        result->begin());


/*
   Container<Cont, T>* result=new  Container<Cont, T>();
   typename Container<Cont, T>::iterator p=this->GetFirst(), p2=secondList->GetFirst();
   while (p!=this->end() || p2!=NULL)
 {
 while (p!=this->end() && 
(p2!=NULL && this->GetElement(p)>=secondList->GetElement(p2)) || p2==NULL)
{
  result->insertElement(GetElement(p));
  p=this->GetNext(p);
}
 while (p2!=NULL && 
(p!=this->end() && this->GetElement(p)<secondList->GetElement(p2)) || p==NULL)
{
  result->insertElement(secondList->GetElement(p2));
  p2=secondList->GetNext(p2);
}
 }
*/
return result;
  }



   /*____________________________________________________________ */


    template <class Cont, class T> void Container<Cont, T>::copyPaste(Container<Cont, T>* sourceList)
  {
    Container<Cont, T>* copy=sourceList->clone();
    this->insertElement(copy->begin(), copy->end()); 
  };
   /*____________________________________________________________ */


    template <class Cont, class T> void Container<Cont, T>::paste(Container<Cont, T>* sourceList)
  {
    this->insertElement(sourceList->begin(), sourceList->end()); 
  };
   /*____________________________________________________________ */


    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithPositionsIn(intSet * sourceList)
  {
    return extractElementsByPositions(sourceList, true);
  };
  /*____________________________________________________________ */


    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithoutPositionsIn(intSet * sourceList)
  {
    return extractElementsByPositions(sourceList, false);
  };

  /*____________________________________________________________ */

    template <class Cont, class T> 
 Container<Cont, T>* Container<Cont, T>::copyElementsIn(Container<Cont, T> * Source, bool orderedByThis)
  {
    return copyElementsByContents(Source, true, orderedByThis);
  }
  /*____________________________________________________________ */

    template <class Cont, class T> 
Container<Cont, T>* Container<Cont, T>::copyElementsNotIn(Container<Cont, T> * Source, bool orderedByThis)
  {
    return copyElementsByContents(Source, false, orderedByThis);
  }
  /*____________________________________________________________ */
/*
    template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInUnrepeatedList(Container<Cont, T> * Source, bool orderedByThis)
  {
    intList* list= copyPositionsByContents(Source, true);
    intSet* result=new intSet(*list);
    zap(list);
    return result;
  }
/*____________________________________________________________ */

    template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInSet(Container<set<T>,T> * Source, bool orderedByThis)
  {
    Container<vector<T>,T>* source=new Container<vector<T>,T>(*Source);
    intList* list= copyPositionsByContents(source, true);
    intSet* result=new intSet(*list);
    zap(source);
    zap(list);
    return result;
  }
  /*____________________________________________________________ */

    template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithElementsIn(Container<Cont, T> * Source, bool orderedByThis)
  {
    return copyPositionsByContents(Source, true, orderedByThis);
  }
  /*____________________________________________________________ */

    template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithoutElementsIn(Container<Cont, T>* Source)
  {
    return copyPositionsByContents(Source, false);
  }

/*____________________________________________________________ */

/*
 Container<Cont, T>
void Container<Cont, T>::sort(typename Container<Cont, T>::ierator begin, typename Container<Cont, T>::iterator end, Compare comp)
{
return std::sort(begin, end, comp);
}

/*____________________________________________________________ */

 template <class Cont, class T> 
void Container<Cont, T>::sortPointer(bool ascendant)
{
//struct Compare<T> compare;
//struct CompareInv<T> compareinv;

//throw NonImplemented("Container<Cont, T>::order(bool ascendant)");
//__gnu_cxx::__normal_iterator<Container<Cont, T> > it=this->getFirst();
if (ascendant) std::sort((typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), comparePointer<T>);
else std::sort((typename Container<Cont, T>::iterator) this->begin(), (typename Container<Cont, T>::iterator) this->end(), compareInvPointer<T>);
};
/*____________________________________________________________ */

 template <class Cont, class T> 
void Container<Cont, T>::shuffle()
{
int originalSize=this->size();
Sampling *sampling=new Sampling(this->size());
for (int i=0; i<originalSize;i++)
insertElement(this->getElement(sampling->getPositionsTable()[i]));
erase(this->getNode(0), this->getNode(originalSize));
zap(sampling);
}
/*____________________________________________________________ */

 template <class Cont, class T> 
void Container<Cont, T>::sort(bool ascendant)
{
//struct Compare<T> compare;
//struct CompareInv<T> compareinv;

//throw NonImplemented("Container<Cont, T>::order(bool ascendant)");
//__gnu_cxx::__normal_iterator<Container<Cont, T> > it=this->getFirst();

if (ascendant) std::sort((typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), BIOS::compare<T>);
else std::sort((typename Container<Cont, T>::iterator) this->begin(), (typename Container<Cont, T>::iterator) this->end(), BIOS::compareInv<T>);
};
/*____________________________________________________________ */

 template <class Cont, class T> void Container<Cont, T>::orderFunction(bool compareArg(const T& arg1, const T& arg2) )
{
sort(this->begin(), this->end(), compareArg);
};
/*____________________________________________________________ */
/*
 Container<Cont, T>void Container<Cont, T>::orderPointer(bool ascendant) 
{
 if (ascendant) sort(this->begin(), this->end(), comparePointer<T>);
 else sort(this->begin(), this->end(), compareinvPointer<T>);
};
/*____________________________________________________________ */
/*
 Container<Cont, T>void Container<Cont, T>::orderPointer(bool compareArg(const T& arg1, const T& arg2)) 
{
sort(this->begin(), this->end(), compareArg);
};
/*____________________________________________________________ */
/*
template <class Cont, class T> void Container<Cont, T>::basicOrder() 
{
 sort(this->begin(), this->end());
 };
/*____________________________________________________________ */

    template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::reverse()
  {
  Container<Cont, T>* result=new Container<Cont, T>();
  typename Container<Cont, T>::iterator p=this->GetLast();
while (p!=this->end())
{
 result->insertHardElement(*p);
p=this->GetPrevious(p);
}
    return result;
  }

  /* _____________________________________________________*/

   template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::fromString (string s)
  {
throw NonImplemented("Container<Cont, T>");
}
   
  /*____________________________________________________________ */

  /*
template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator> 
struct IT
{
typedef Container<Cont, T>::iterator Class;
};

template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator> 
T& IT::Class::getElement()
{
return (T&)*this;
}
 */
/*
template <class T>
T& std::_Rb_tree_const_iterator<T>::getElement()
{
return (T&)*this;
}
*/
  
} // end namespace
#endif

/* Fin Fichero: list.cpp */
// void zap<list<float>::node*>(list<float>::node*&);

//BIOS::Container::Container< Cont, T >(char * file, const char * tokens, char outputSeparator, bool delimiter)
//{
//}


