/* File: DiagonalTable.h */


#ifndef __DiagonaTable_cpp__
#define __DiagonaTable_cpp__



using namespace std;

namespace BIOS {


template <class T> DiagonalTable<T>::DiagonalTable(int sizeX, int sizeY) {if (sizeY==0) this->sizeY=sizeX; else this->sizeY=sizeY; this->sizeX=sizeX; size=this->sizeX*(this->sizeY-1)/2; table=new T[size];};
template <class T>  DiagonalTable<T>::~DiagonalTable(){zaparr(table);};
template <class T> void DiagonalTable<T>::setValue(int posX, int posY, T value) {table[getPos(posX, posY)]=value;};
template <class T> int DiagonalTable<T>::getFirstPosInSameRow(int posX){if (posX==0) return 0; return sizeY*posX-getGauss(posX);};
template <class T> int DiagonalTable<T>::getPos(int posX, int PosY) {return getFirstPosInSameRow(posX)+(sizeX-posX-1)-(sizeY-PosY-1);};
template <class T> T DiagonalTable<T>::getValue(int posX, int posY) {return table[getPos(posX, posY)];}
template <class T> void DiagonalTable<T>::initialize(T value){for (int i=0;i<size;i++) table[i]=value;};
template <class T> int DiagonalTable<T>::getSizeX(){return sizeX;};
template <class T> int DiagonalTable<T>::getSizeY(){return sizeY;};
 


 template <class T> ostream& operator<<(ostream& out, DiagonalTable<T>& p)
  {
for (int i=0;i<p.getSizeX();i++)
{
for (int j=0;j<p.getSizeY();j++)
if (j<=i) out <<"-\t";
else out << p.getValue(i,j) <<"\t";
out <<"\n";
}
    return out;
  }
//#include "DiagonalTable.cpp"
}
#endif
