
#ifndef __ExcepBasic__
#define __ExcepBasic__

#include <iostream>


using namespace std;

namespace BIOS
{

template <class T> string tos(T i);

	class NullValue
	{
		public:
			string message;

			NullValue ( string message )
			{
				this->message=string ( message );
//PrintMessage(this->message.c_str());
			}
			NullValue() {};
			void PrintMessage()
			{
				cout << "\nNull value (pointer == NULL) at " << message << ".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* f )
			{
				cout << "\nNull value (pointer == NULL) at function " << f <<" called from " << message << ".\n";
				exit ( 1 );
			}

	};

	class NonImplemented
	{
		public:
			string message;

			NonImplemented ( string message )
			{
				this->message=string ( message );
//PrintMessage(this->message.c_str());
			}
			NonImplemented() {};
			void PrintMessage()
			{
				cout << "\nNon implemented at " << message << ".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* f )
			{
				cout << "\nNon implemented at function " << f <<" called from " << message << ".\n";
				exit ( 1 );
			}

	};

	
	class MissingArguments
	{
		public:
			string message;

			MissingArguments ( string message )
			{
				this->message=string ( message );
			}
			MissingArguments() {};
			void PrintMessage()
			{
				cout << "\nMissing arguments at " << message << ".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* f )
			{
				cout << "\nMissing arguments at function " << f <<" called from " << message << ".\n";
				exit ( 1 );
			}

	};

	class NanValue
	{
		public:
                        string message;
                        NanValue(string message)
                       { this->message=string(message);}
                        NanValue(){};
			void PrintMessage()
			{
				cout << "\nNaN value.\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* f )
			{
				cout << "\nNaN value at function " << f <<" called from " << message <<  ".\n";
				exit ( 1 );
			}

	};


	class NoMemory
	{
		public:
			string message;
			NoMemory() {};
			NoMemory ( string s )
			{this->message=s;};
			void PrintMessage()
			{
				cout << "\nNot enough memory.\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* f )
			{
				cout << "\nMemory fault at function " << f << ".\n";
				exit ( 1 );
			}
	};

	class OutOfBounds
	{
		public:
			int first, second;
			OutOfBounds ( int first, int second )
			{
				this->first=first;
				this->second=second;
			}
			void PrintMessage ( string s )
			{
				cout << "\nTrying to access position: " << first <<" at " << s << " but there are only " << second <<" positions [0:" << second-1 << "].\n";
				exit ( 1 );
			};
	};


	template <class T> class OutOfRange
	{
		public:
			T val;
			string message;
			OutOfRange(){};
			OutOfRange ( T val, const char* message )
			{
				this->val=val;
//if (message!=NULL)
				this->message=string ( message );
			}

			OutOfRange ( T val, string message )
			{
				this->val=val;
//if (message!=NULL)
				this->message= message;
			}

			void PrintMessage ( T value )
			{
				cout << "Some metric for value " << value << " is out of range, val is :" << val << " called from " << message << ".\n";
				exit ( 1 );
			}
			void PrintMessage()
			{
				cout << "Some metric is out of range, val is:" << val << " at " << message << ".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char * message )
			{
				cout << "Some metric is out of range, val is: " << val << " at " << message <<" called from " << this->message <<".\n";
				exit ( 1 );
			}
	};
	
typedef OutOfRange<int> ORI;
typedef OutOfRange<double> ORD; 
typedef OutOfRange<long long int> ORLLI;

	class BadSize
	{
			const char* f;
			int first, second;
		public:

			BadSize() {};

			BadSize ( const char* f )
			{
				this->f=f;
			};
			BadSize ( const char * t, int first, int second )
			{
				f=t;
				this->first=first;
				this->second=second;
			};
			void PrintMessage()
			{
				cout << "\nDifferent size at " << f <<": " << first <<":" << second <<".\n";
				exit ( 1 );
			}
			void PrintMessage ( int first, int second )
			{
				cout << "\nDifferent size: " << first <<":" << second <<".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char * t, int first, int second )
			{
				cout << "\nDifferent size in " << t << ": " << first <<":" << second <<".\n";
				exit ( 1 );
			}
			void PrintMessage ( const char * t )
			{
				cout << "\nDifferent size in " << f << ": " << first <<":" << second <<" at " << t << ".\n";
				exit ( 1 );
			}
	};


        
	class EOFile
	{
		public:
			void PrintMessage()
			{
				cout << "\nEnd of file error.\n";
				exit ( 1 );
			}
	};

	class BadFile
	{
		public:
			void PrintMessage()
			{
				cout << "\nIncorrect file format.\n";
				exit ( 1 );
			}
	};

	class NoEOL
	{
   int val;
   string line;
   const char* file;
		public:
    NoEOL(){};
    NoEOL(int val, int line, const char* file)
{
this->val=val;
this->file=file;
this->line=tos(line);
if (line==-1) this->line=string("last");
};
			void PrintMessage(const char* message)
			{
				cout << "\nError at " << message <<": File " << file << " lacks an EOL char at the " << line << " line. Found " << val <<" instead.\n";
				exit ( 1 );
			};
	};


	class ErrorFile
	{
			string s;
      bool eof, fail, bad;
		public:
			ErrorFile() {};
	    ErrorFile(bool eof, bool fail, bool bad) {this->eof=eof; this->fail=fail; this->bad=bad;};
			ErrorFile ( char* name ) {s=string ( name );};
			void PrintMessage()
			{
				cout << "\nFile " << s << " does not exist, is damaged or cannot be created.\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* name )
			{
				cout << "\nFile \"" << name << "\" does not exist, is damaged or cannot be created.\n";
        cout << "Eof is:" << eof << ", fail is:" << fail <<", bad is:" << bad;
				exit ( 1 );
			}
			void PrintMessage ( const char* name, const char* message )
			{
				cout << "\nError in " << message <<", file " << name << " does not exist, is damaged or cannot be created.\n";
        cout << "Eof is:" << eof << ", fail is:" << fail <<", bad is:" << bad;
				exit ( 1 );
			}
	};

	class AlreadyExist
	{
		public:
			void PrintMessage()
			{
				cout << "\nFile already exists.\n";
				exit ( 1 );
			}
	};

	class AlreadyOpen
	{
		public:
			void PrintMessage()
			{
				cout << "\nStream already open.\n";
				exit ( 1 );
			}
	};


	class EmptyFile
	{
		public:
			void PrintMessage ( const char* filename )
			{
				cout << "\nFile " << filename << " does not have data.\n";
				exit ( 1 );
			}
	};


	class NonBoolean
	{
		public:
			void PrintMessage()
			{

				cout << "Error, must be a boolean value (0 or 1)\n";
				exit ( 1 );
			}
	};

	class NonInteger
	{
		public:
			double val;
			string message;
			NonInteger ( double val, const char* message )
			{
				this->val=val;
				this->message=string ( message );
			}
			void PrintMessage()
			{

				cout << "Error, " << val << " must be an integer value at " << message <<"\n";
				exit ( 1 );
			}
	};




	class BadFormat
	{
		public:
			string s;
			BadFormat ( string message )
			{
				s=string ( message );
			};
			BadFormat ( const char* message )
			{
				s=string ( message );
			};

			BadFormat() {};

			void PrintMessage()
			{

				cout << "Error, incorrect format at " << s <<"\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* file )
			{

				cout << "Error, incorrect format in file " << file << "\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* file, const char* message )
			{

				cout << "Error at " << message << ", incorrect format in file " << file << "\n";
				exit ( 1 );
			}
			void PrintMessage ( string message )
			{

				cout << "Error at " << message << ", incorrect format called from " << s << "\n";
				exit ( 1 );
			}
	};

class NonDefined
	{
		public:
			string s;
			NonDefined ( string message )
			{
				s=string ( message );
			};
			NonDefined ( const char* message )
			{
				s=string ( message );
			};

			NonDefined() {};

			void PrintMessage()
			{

				cout << "Error, undefined method at " << s <<"\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* file )
			{

				cout << "Error, undefined method in file " << file << "\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* file, const char* message )
			{

				cout << "Error at " << message << ", undefined method in file " << file << "\n";
				exit ( 1 );
			}
			void PrintMessage ( string message )
			{

				cout << "Error at " << message << ", undefined method called from " << s << "\n";
				exit ( 1 );
			}
	};


	class ZeroValue
	{
		public:
			string message;
			ZeroValue() {};
			ZeroValue ( string s )
			{
				this->message=s;
			}
			void PrintMessage()
			{

				cout << "Error, value is zero at " << message << "\n";
				exit ( 0 );
			}
			void PrintMessage ( const char* s )
			{

				cout << "Error, value is zero at " << message << " called from " << s <<"\n";
				exit ( 0 );
			}
	};
	


	class NonProb
	{
			string message;
      double val;
		public:
			NonProb()
			{
			};
			NonProb ( string s, double val )
			{
				this->message=s;
        this->val=val;
			}


			void PrintMessage()
			{

				cout << "Error, " << val << " is not a probability at "  << message <<  "\n";
				exit ( 1 );
			}
			void PrintMessage ( float val )
			{

				cout << "Error, " << val << " is not a probability at " << message << "\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* s )
			{

				cout << "\nError, not a probability " << message << " called from " << s <<"\n";
				exit ( 1 );
			}
	};
	

	class NonDiscrete
	{
			string message;
		public:
			NonDiscrete ( string s )
			{
				this->message=s;
			}
			void PrintMessage()
			{

				cout << "Error, non discretized attribute\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* s )
			{

				cout << "\nError, non discretized attribute " << message << " called from " << s <<"\n";
				exit ( 1 );
			}
	};

	class MissingValue
	{
		public:
			string message;
			MissingValue ( string s )
			{
				message=s;
			};
			MissingValue() {};
			void PrintMessage()
			{

				cout << "Error, missing value at " << message << "\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* message, int row, string col )
			{

				cout << "Error, missing value in row " << row << " and col " << col << " at " << message << "\n";
				exit ( 1 );
			}
			void PrintMessage ( const char* message )
			{

				cout << "Error, missing value  at " << message << "\n";
				exit ( 1 );
			}
	};
	


} // end namespace
#endif
