/* File: Quotient.h */


#ifndef __Quotient_h__
#define __Quotient_h__



using namespace std;

namespace BIOS {


////////////////////
template <class T> class Quotient //
{
protected:
	T numerator;
	T denominator;
private: 
	void simplify();
public:
	~Quotient();
	Quotient (T numerator, T denominator); // constructor
	Quotient (const Quotient<T> & origen);// constructor de copia
	double log2();
	virtual Quotient operator* (Quotient<T> & rat2);
	bool operator< (Quotient<T> & rat2);
	bool operator<= (Quotient<T> & rat2);
	bool operator> (Quotient<T> & rat2);
	virtual Quotient<T> operator/ (Quotient<T> & rat2);
	Quotient<T> operator+ (Quotient<T> & rat2);
	Quotient<T> operator- (Quotient<T> & rat2);
	bool operator== (Quotient<T> & rat2);

	double convert ();
	virtual string print();
	//virtual ostream& operator<<(ostream& out);

	static unsigned long int getMCD(unsigned long int a, unsigned long int b);

	bool isUndefined ();
	T getNumerator();
	T getDenominator();
	void setNumerator(T numerator);
	

};
 
template <class T> ostream& operator<<(ostream& out, Quotient<T>& e);
}//end namespace
#endif
