/* File: Sampling.cpp */


#ifndef __Sampling_cpp__
#define __Sampling_cpp__



#include "Sampling.h"


namespace BIOS {


/************************/
/* Sampling STATISTIC*/
/************************/


/**
        @memo Sampling

	@doc
        Definition:
        An array Pos of Size 

        Memory space: O(Size). 

        @author Maria M. Abad
	@version 1.0
*/



/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// privates /////////////



///////////////////
//// public ////////
///////////////////


/**********************************/
Sampling::Sampling(int size, bool repetition)
{
this->Pos=NULL;
positionsList=NULL;
this->Size=size;
bool *Chosen=NULL;
try {
if ((this->Pos=new int[size])==NULL)
      throw NoMemory();
if (repetition==true)
{
for (int  i=0; i<size;i++)
 Pos[i]=rand() % (size);     //
}
else // without repetition
{
int pos;
if ((Chosen=new bool[size])==NULL)
    throw NoMemory();
for (int  i=0;i<size;i++)
	Chosen[i]=false;

int cont2, posNotChosen;
for (int i=0; i<size;i++)
  {//
  
   do posNotChosen=rand()%size;
   while (Chosen[posNotChosen]==true);
   Chosen[posNotChosen]=true;
   Pos[i]=posNotChosen;
/*
//another inplementation (faster)
 cont2=0;//
   pos=rand() % (size-i);     //
   posNotChosen=0;

   for (int i2=0; i2<=pos; i2++)
   {
   while (Chosen[posNotChosen]==true)
    posNotChosen++;
   if (i2<pos)
   posNotChosen++;
   }
   Pos[i]=posNotChosen;
   Chosen[posNotChosen]=true;
 */
 }//
} // end without repetition 
 }
catch (NoMemory nm) {
  nm.PrintMessage();
  }
zaparr(Chosen);
setPositionsList();
}
/**********************************/

Sampling::~Sampling()
{
//	if (SamplingValue!=NULL)
//	delete SamplingValue;
zap(positionsList);
zaparr(Pos);
}

/**********************************/
int* Sampling::getPositionsTable()
{
return Pos;
}
/**********************************/
int Sampling::getPos(int pos)
{
return Pos[pos];
}
/**********************************/
intList* Sampling::getPositionsList()
{
return positionsList;
}
/**********************************/
void Sampling::setPositionsList()
{
positionsList=new intList();
for (int i=0; i<Size; i++)
 positionsList->insertElement(Pos[i]);
}

};  // End of Namespace

#endif

/* End of file: Sampling.h */




