/* File: Tables2x2.cpp */


#ifndef __Table2x2_cpp__
#define __Table2x2_cpp__





using namespace std;

namespace BIOS {




/*_____________________________________________________________*/

double Table2x2::GetDPrime(double fAB, double fA, double fB)
{
double DMax=GetMaxD(fAB, fA, fB);

double D=GetD(fAB, fA, fB);

if (D<=zero) return 0;

char line[500];
line[0]='\0';

if (fA==0 || (1-fA)==0 || fB==0 || (1-fB)==0) return 1;
try
{
if ((fabs(D)-fabs(DMax))>zero)// && (fabs(D)-fabs(DMax))>-zero)
{
sprintf(line, "Table2x2::GetDPrime1(fAB=%1.24f, fA=%1.24f, fB=%1.24f, D=%1.24f, MaxD=%1.24f, fabs(D)-fabs(DMax) is greater than zero (%0.24f), value is %0.24f)", fAB, fA, fB, D, DMax, zero,  (fabs(D)-fabs(DMax)));
throw OutOfRange<double>(fabs(D)-fabs(DMax), "Table2x2::GetDPrime1");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage(line);};

 
if (fabs(D-DMax)<zero) return 1.0;

try
{
if (fabs(DMax)<=zero)
{
cout << "fabs(Dmax) is lower than zero:"<<fabs(DMax) <<"\n";
cout <<"DMax is:" << DMax <<"\n";
sprintf(line, "Table2x2::GetDPrime2(fAB=%1.4f, fA=%1.4f, fB=%1.4f, D=%1.24f, MaxD=%1.24f, fabs(D)-fabs(DMax) is greater than zero (%0.24f), value is %0.24f)", fAB, fA, fB, D, DMax, zero,  (fabs(D)-fabs(DMax)));
	throw OutOfRange<double>(fabs(D)-fabs(DMax), "Table2x2::GetDPrime2");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage((string(" Table2x2::GetDPrime(2)")+string(line)).c_str());};

return (D/DMax);
}
/*_____________________________________________________________*/

double Table2x2::getCompositeLD(double fAB, double fA_B, double fA, double fB)
{
return fAB+fA_B-2*fA*fB;
}
/*_____________________________________________________________*/

double Table2x2::getMaxCompositeLD(double fAB, double fA_B, double fA, double fB, double fAA, double fAa, double faa, double fBB, double fBb, double fbb)
{
double d, second=0.5*(1-2*fA)*(1-2*fB);;
if (getCompositeLD(fAB, fA_B, fA, fB)>0)
{
d=mini(fAA,fBB)+mini(faa, fbb);
second=-second;
}
else d=mini(fAA,fbb)+mini(faa, fBB);
return (2*d-1+mini(1-d, fAa+fBb))/2+second;
}
/*_____________________________________________________________*/

double Table2x2::getStandardizedCompositeLD(double fAB, double fA_B, double fA, double fB, double fAA, double fAa, double faa, double fBB, double fBb, double fbb)
{
double LDMax=getMaxCompositeLD(fAB, fA_B, fA, fB, fAA, fBB, faa, fbb, fAa, fBb);

double LD=getCompositeLD(fAB, fA_B, fA, fB);

char line[100];
line[0]='\0';

try
{
if ((fabs(LD)-fabs(LDMax))>zero)// && (fabs(D)-fabs(DMax))>-zero)
{
sprintf(line, "Table2x2::getStandardizedCompositeLD(fAB=%1.4f, fA=%1.4f, fB=%1.4f, D=%1.24f, MaxD=%1.24f, fabs(D)-fabs(DMax) is greater than zero (%0.24f), value is %0.24f)", fAB, fA, fB, LD, LDMax, zero,  (fabs(LD)-fabs(LDMax)));
throw OutOfRange<double>(abs(LD)-fabs(LDMax), "Table2x2::getStandardizedCompositeLD");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage(line);};

 
if (fabs(LD-LDMax)<zero) return 1.0;

try
{
if (fabs(LDMax)<=zero)
{
cout << "fabs(LDmax) is lower than zero:"<<fabs(LDMax) <<"\n";
cout <<"LDMax is:" << LDMax <<"\n";
sprintf(line, "Table2x2::getStandardizedCompositeLD(fAB=%1.4f, fA=%1.4f, fB=%1.4f, D=%1.24f, MaxD=%1.24f, fabs(D)-fabs(DMax) is greater than zero (%0.24f), value is %0.24f)", fAB, fA, fB, LD, LDMax, zero,  (fabs(LD)-fabs(LDMax)));
	throw OutOfRange<double>(abs(LD)-fabs(LDMax), "Table2x2::getStandardizedCompositeLD");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage((string(" Table2x2::getStandardizedCompositeLD(2)")+string(line)).c_str());};

return (LD/LDMax);
}
/*_____________________________________________________________*/

double Table2x2::GetRho(double fAB, double fA, double fB)
{
double DMax=GetMaxD(fAB, fA, fB);

double D=fabs(GetD(fAB, fA, fB));


if (D<=zero) return 0;

char line[100];

try
{
if ((fabs(D)-fabs(DMax))>zero)
{
sprintf(line, "Table2x2::GetRho(fAB=%1.4f, fA=%1.4f, fB=%1.4f, D=%1.4f, MaxD=%1.4f)", fAB, fA, fB, D, DMax);
throw OutOfRange<double>(abs(D)-fabs(DMax), "Table2x2::GetRho");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage(line);};

 
if (fabs(D-DMax)<zero) return 1.0;

try
{
if (fabs(DMax)<=zero)
	throw OutOfRange<double>(fabs(DMax), "Table2x2::GetRho");
}
catch (OutOfRange<double> wm) { wm.PrintMessage(" Table2x2::GetRho");};

return (D/DMax);
}
/*_____________________________________________________________*/

double Table2x2::GetQ(double fAB, double fA, double fB)
{
double fAb=fA-fAB, faB=fB-fAB, fab=1-fAB-fAb-faB;

double h1=fAB*fab;
double h2=fAb*faB;

if (h1==0 && h2==0)
return 1;
else
return fabs((h1-h2)/(h1+h2));

}

/*_____________________________________________________________*/

double Table2x2::GetR2(double fAB, double fA, double fB)
{
double R2Max=(fA)*(1-fA)*fB*(1-fB);

char line[100];

double D=GetD(fAB, fA, fB);

if (D<=zero) return 0;
try
{
if ((std::pow(D,(double)2)-R2Max)>zero) 
{
sprintf(line, "Table2x2::GetR2(fAB=%1.4f, fA=%1.4f, fB=%1.4f, D2=%1.4f, R2Max=%1.4f)", fAB, fA, fB, std::pow(D,(double)2), R2Max);
throw OutOfRange<double>(std::pow(D,(double)2)-R2Max, "Table2x2::GetR2");
}
}
catch (OutOfRange<double> wm) { wm.PrintMessage(line);};

if (fabs(std::pow(D,(double)2)-R2Max)<zero) return 1.0;
else 
try
{
if (R2Max<=zero) throw NonProb();
}
catch (NonProb np) { np.PrintMessage(" Table2x2::GetR2");};

 return std::pow(D,(double)2)/R2Max;

}
/*_____________________________________________________________*/
/*
void genoma::DistributeLDMinOld (sfrequencies hap, sfrequencies hap2)
{
unsigned int Min=0, DMax;
unsigned int ValMax, ValMin;
for (int i=0;i<5;i++)
 hap2[i]=hap[i];

if (GetLD(hap)>0) 
{
ValMax=(hap[1]+hap[4])*(hap[2]+hap[4])-(hap[0]*hap[3]);
ValMin=(hap[1]*hap[2])-(hap[0]+hap[4])*(hap[3]+hap[4]);
}
else
{
ValMax=(hap[0]+hap[4])*(hap[3]+hap[4])-(hap[1]*hap[2]);
ValMin=(hap[0]*hap[3])-(hap[1]+hap[4])*(hap[2]+hap[4]);
}
if (abs(ValMax-ValMin)<ValMax) // if equal sign
{
if (GetLD(hap)>0) 
{
hap2[0]=hap2[0]+hap2[4];
hap2[3]=hap2[3]+hap2[4];
}
else
{
hap2[1]=hap2[1]+hap2[4];
hap2[2]=hap2[2]+hap2[4];
}
}

}
*/
/*_____________________________________________________________*/
/*
void Table2x2::DistributeLDMin (sfrequencies hap, sfrequencies hap2, sfrequencies hap3)
// we compute two different ways to distribute values, hap2, hap3 because it can
// occurs that D(hap2)>D(hap3) but Dprime(hap2)<Dprime(hap3)
// A necessary condition for this to happen is that D(x=0)D(x=m)<0
// Example: n(AB)=35, n(Ab)=10, n(aB)=10, n(ab)=3, m=1
{
for (int i=0;i<5;i++)
 hap2[i]=hap[i];

 hap2[0]=hap2[0]+hap[4];
 hap2[3]=hap2[3]+hap[4];

unsigned int Min=0;


double LastLD=GetLD(hap2), MinLD=GetLD(hap2);
bool crossx=false;
bool zerofound=false;
if (GetLD(hap2)==0) 
 zerofound=true;
unsigned int i=1;

while (!crossx && !zerofound && i<=hap[4])
{
 hap2[0]=hap2[0]-1;
 hap2[3]=hap2[3]-1;
 hap2[1]=hap2[1]+1;
 hap2[2]=hap2[2]+1;

 if (GetLD(hap2)==0.0) 
 {
	 Min=i;
	 zerofound=true;
	 if (hap[0]==517)
{
	cout <<" found zero";
}
 }
 else
//if ((LastLD*GetLD(hap2))<(long int) 0) does not work, if is larger than 36768, the product is < 0??

 if ((LastLD>0 && GetLD(hap2)<0) || (LastLD<0 && GetLD(hap2)>0))
 {
 crossx=true;
 Min=i;

 }
 else 
 if (  (LastLD>0 && GetLD(hap2)<LastLD)   ||  (LastLD<0 && GetLD(hap2)>LastLD) )
 {

  LastLD=GetLD(hap2);
  Min=i;

 }  

 i++;
}

for (int i=0;i<5;i++)
 hap2[i]=hap[i];

 hap2[0]=hap2[0]+hap[4]-Min;
 hap2[3]=hap2[3]+hap[4]-Min;
 hap2[1]=hap2[1]+Min;
 hap2[2]=hap2[2]+Min;


 for (int i=0;i<5;i++)
   hap3[i]=hap2[i];
  
 if (crossx) 
 {
 hap3[1]=hap2[1]-1;
 hap3[2]=hap3[2]-1;
 hap3[0]=hap3[0]+1;
 hap3[3]=hap3[3]+1;
}

}
*/
/*_______________________________________________*/

double Table2x2::GetMaxD (double fAB, double fA, double fB)
{
if (GetD(fAB, fA, fB)>0)
return GetPositiveMaxD(fAB, fA, fB);
else return GetNegativeMaxD(fAB, fA, fB);
}
/*_______________________________________________*/

double Table2x2::GetPositiveMaxD (double fAB, double fA, double fB)
{
//if ((fA>=0.5 && fB>=0.5)) //|| (fA<0.5 && fB<0.5))
if (fA*(1-fB)<(1-fA)*fB) return fA*(1-fB); else return (1-fA)*fB;
//else if (fA*(1-fB)<(1-fA)*fB) return (1-fA)*fB; else return fA*(1-fB);
}/*_______________________________________________*/

double Table2x2::GetNegativeMaxD (double fAB, double fA, double fB)
{
//if ((fA>=0.5 && fB>=0.5))
if (fA*fB<(1-fA)*(1-fB)) return -fA*fB; else return -(1-fA)*(1-fB);
//else if (fA*fB>(1-fA)*(1-fB)) return -fA*fB; else return -(1-fA)*(1-fB);
}
/*_____________________________________________________________*/

double Table2x2::GetD(double fAB, double fA, double fB)
{

return (fAB-fA*fB);
}

/*_________________________________________________________________________*/

double Table2x2::EstimateMLE (int nAB, int nAb, int naB, int nab, int nHH, int it=1000)
{
  double total= nAB+nAb+naB+nab;

	 double fA=(nAB+nAb+nHH)/(total+2*nHH), fB=(nAB+naB+nHH)/(total+2*nHH);

 	 return EstimateMLE (fA*fB, nHH, nAB, total, fA, fB, 1000);
}
/*_________________________________________________________________________*/

double Table2x2::EstimateMLE (double fAB, double nHH, double nABKnown, double total, double fA, double fB, int it=1000)
{

double fAb=fA-fAB, faB=fB-fAB, fab=(double)1-fAB-fAb-faB, denominator=fAB*fab+fAb*faB;

/*
try
{
if (denominator<zero) 
{
	cout <<"fAB:" << fAB <<", nHH:" << nHH << ", nABKnown:" << nABKnown <<", total:" << total <<", fA:" << fA <<", fB:" << fB;
 throw ZeroValue();
}
}
catch (ZeroValue wm) { wm.PrintMessage(" Table2x2::EstimateMLE");}
*/


if (nHH==0 || denominator<zero)
return nABKnown/total;
else
{
double PhaseFrequencies=(fAB*fab)/denominator;
double fABNew=(nABKnown+nHH*PhaseFrequencies)/((double)total+2*nHH);
double t=fabs(fAB-fABNew);
if (t>= 0.00005 || it>0) fAB=EstimateMLE (fABNew, nHH, nABKnown, total, fA, fB, it-1);
}
return fAB;
}
/*____________________________________________________________ */

struct FreqAndVal* Table2x2::GetDDistribution(double fA, double fB, double nAB, double nAb, double naB, double nab, double nHH)
{
if (fA<0.5) fA=1-fA;
if (fB<0.5) fB=1-fB;

double D, freq, acum=0.0;
double fAB, fAb, faB, fab, fa=1-fA, fb=1-fB;
unsigned int c, pos=0;
struct FreqAndVal*DPrimeList; 
DPrimeList=new struct FreqAndVal[201];
//int cont=0;
double max=-maxreal, DMaxNeg=fa*fb, DMaxPos=mini(fA*(1-fB), (1-fA)*fB);


for (int i=-100; i<101; i++)
{
 c=i+100;
 if (i>=0) D=(i/(double)100)*DMaxPos;
 else D=(i/(double)100)*DMaxNeg;
 DPrimeList[c].value=D;
 fAB=D+fA*fB;
 fAb=fA-fAB;
 faB=fB-fAB;
 fab=1-fAB-fAb-faB;
 try
{
 if (fab<-zero || faB<-zero || fAb<-zero || fAB<-zero) 
 {
	 cout <<"\nfA:" << fA <<", fB:" << fB <<"D:" << D <<", DPrime:" << DPrimeList[c].value;
	 cout <<"fAB:" << fAB <<", fAb:" << fAb << ", faB:" << faB <<", fab:" << fab;
	 cout <<"nAB:" << nAB <<", nAb:" << nAb << ", naB:" << naB <<", nab:" << nab <<"NHH:" << nHH;
	 throw NonProb("Tables2x2::GetDDistribution", fab); exit(0);
 }
}
catch (NonProb wm) { wm.PrintMessage();};

 
 if (fab<zero) fab=0;
 if (fAB<zero) fAB=0;
 if (fAb<zero) fAb=0;
 if (faB<zero) faB=0;


if ((fAB==0 && nAB!=0) || (fAb==0 && nAb!=0) || (faB==0 && naB!=0) || (fab==0 && nab!=0))
 DPrimeList[c].frequency=-maxreal;
else
{

DPrimeList[c].frequency=0;
if (fAB!=0) DPrimeList[c].frequency=DPrimeList[c].frequency+nAB*log(fAB);// fAB with itself
if (fAb!=0) DPrimeList[c].frequency=DPrimeList[c].frequency+nAb*log(fAb);// fAB with itself
if (faB!=0) DPrimeList[c].frequency=DPrimeList[c].frequency+naB*log(faB);// fAB with itself
if (fab!=0) DPrimeList[c].frequency=DPrimeList[c].frequency+nab*log(fab);// fAB with itself
if (fAB*fab!=0 || fAb*faB!=0) DPrimeList[c].frequency=DPrimeList[c].frequency+nHH*log(2*fAB*fab+2*fAb*faB);

if (DPrimeList[c].frequency!=0)
if (max<DPrimeList[c].frequency)
max=DPrimeList[c].frequency;
}
}; // for each DPrime value

// reduce module


for (int i=-100; i<101; i++)
{
c=i+100;
if (DPrimeList[c].frequency!=-maxreal)
DPrimeList[c].frequency=exp(DPrimeList[c].frequency-max);
else DPrimeList[c].frequency=0;
}




return DPrimeList;
};
/*____________________________________________________________ */

struct FreqAndVal* Table2x2::GetDPrimeDistribution(double fA, double fB, double nAB, double nAb, double naB, double nab, double nHH)
{
if (fA<0.5) fA=1-fA;
if (fB<0.5) fB=1-fB;

double D, freq, acum=0.0;
double fAB, fAb, faB, fab, fa=1-fA, fb=1-fB;
unsigned int c, pos=0;
struct FreqAndVal*DPrimeList, *DList=GetDDistribution(fA, fB, nAB, nAb, naB, nab, nHH); 
DPrimeList=new struct FreqAndVal[201];
//int cont=0;
double max=-maxreal, DMaxNeg=fa*fb, DMaxPos=mini(fA*(1-fB), (1-fA)*fB), DMax;

for (int i=-100; i<101; i++)
{
 c=i+100;
//DPrimeList[c].value=i/(double)100;
 if (i>=0) DMax=DMaxPos; else DMax=DMaxNeg;
 DPrimeList[c].value=DList[c].value/DMax;
 DPrimeList[c].frequency=DList[c].frequency*(DMax/(DMaxNeg+DMaxPos));
}; // for each DPrime value
delete DList;
return DPrimeList;
};

/*____________________________________________________________ */

struct FreqAndVal* Table2x2::GetAbsDPrimeDistribution(double fA, double fB, double nAB, double nAb, double naB, double nab, double nHH)
{
if (fA<0.5) fA=1-fA;
if (fB<0.5) fB=1-fB;

double fa=1-fA, fb=1-fB;
struct FreqAndVal* AbsDPrimeList, *DList; 
DList=GetDDistribution(fA, fB, nAB, nAb, naB, nab, nHH);
AbsDPrimeList=new struct FreqAndVal[101];
int c;
double DMaxNeg=fa*fb, DMaxPos=mini(fA*(1-fB), (1-fA)*fB);


for (int i=0; i<101; i++)
{
 c=i+100;
 AbsDPrimeList[i].value=i/(double)100;
//  AbsDPrimeList[i].value=DList[c].value/DMaxPos;
 AbsDPrimeList[i].frequency=DList[c].frequency*DMaxPos+DList[200-c].frequency*DMaxNeg;
 }

zaparr(DList);
return AbsDPrimeList;
};


/*____________________________________________________________ */

double Table2x2::GetMaxDPrime(double fA, double fB, double nAB, double nAb, double naB, double nab, double nHH)
{
struct FreqAndVal* DPrimeList=GetDPrimeDistribution(fA, fB, nAB, nAb, naB, nab, nHH);
double maxFreq=0, maxVal=0;
for (unsigned int i=0;i<201;i++)
 if (DPrimeList[i].frequency>=maxFreq)
 {
  maxFreq=DPrimeList[i].frequency;
  maxVal=DPrimeList[i].value;
 }

 delete DPrimeList;

return fabs(maxVal);
};
/*___________________________________________________________________________*/

Pair<double> Table2x2::GetQuantilesDPrime (double alpha, double fA, double fB, double fAB, double nAB, double nAb, double naB, double nab, double nHH, bool printing)
{
struct Pair<double> pair;
//return pair;
double DPrime=GetDPrime(fAB, fA, fB);
double quantile1=50-alpha/2;
double quantile2=50+alpha/2;
  if (DPrime==1)
  {
   quantile1=100-alpha;
   quantile2=100;
  }
  if (DPrime==0)
  {
   quantile1=0;
   quantile2=alpha;
  }




struct FreqAndVal* AbsDPrimeList=GetAbsDPrimeDistribution(fA, fB, nAB, nAb, naB, nab, nHH);
pair.First=percentile(AbsDPrimeList, 101, quantile1);
pair.Second=percentile(AbsDPrimeList, 101, quantile2);
if (printing==true)
for (unsigned int i=0;i<101;i++)
cout << "\n" << AbsDPrimeList[i].frequency;
zaparr(AbsDPrimeList);

return pair;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: Tables2x2.h */
