#ifndef __DistanceMethodClass_h__
#define __DistanceMethodClass_h__


namespace BIOS {

typedef enum {
		absoluteDifference=0, //|a1-a2|
	      	normalizedAbsoluteDifference=1,//|a1-a2|/(max-min)
		squareDifference=2 // (a1-a2)^2
	     }
		NumericalAttributeDistanceMethod;// for categorical the function is the identity function

typedef enum {
		SqRoot=0, //sqrt(sum (attributeDistances))
		Sum=1 // sum (attributeDistances)
	     }
		DistanceMethod;

// Hamming distance is obtained when all attributes are categorical and DistanceMethod is Sum
// Euclidean distances is obtained when all attributes are numerical with squareDifference as the NumericalAttributeDistanceMethod and SqRoot as the DistanceMethod
// Manhattan distance is obtained when all attributes are numerical with absoluteDifference as the NumericalAttributeDistanceMethod and Sum as the DistanceMethod

class DistanceMethodClass {

public:

DistanceMethod distanceMethod;

NumericalAttributeDistanceMethod numericalAttributeDistanceMethod;



 	
DistanceMethodClass(DistanceMethod distanceMethod, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod)
{
this->distanceMethod=distanceMethod;
this->numericalAttributeDistanceMethod=numericalAttributeDistanceMethod;
}

 	
DistanceMethodClass()
{
this->distanceMethod=Sum;
this->numericalAttributeDistanceMethod=squareDifference;
}


};

 






}

#endif
