/* File: ListOfAttributes.cpp */


#ifndef __ListOfAttributes_cpp__
#define __ListOfAttributes_cpp__



#include "ListOfAttributes.h"


//using namespace UTILS;


namespace BIOS
{



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/

ListOfAttributes* ListOfAttributes::clone()
{
return new ListOfAttributes(*this);
}
 /*___________________________________________________________*/

string ListOfAttributes::getName()
{
return string("ListOfAttributes");
}
 /*___________________________________________________________*/

 ListOfAttributes::ListOfAttributes():Container<vector<Attribute*>,Attribute*>()
  {
this->verbosity=false;
  };
  /*___________________________________________________________*/

  ListOfAttributes::ListOfAttributes(ListOfAttributes & vectorOfAttributes, bool verbosity):Container<vector<Attribute*>, Attribute*>(vectorOfAttributes)
  {
this->verbosity=verbosity;//vectorOfAttributes.verbosity;
};

   /*___________________________________________________________*/
 
  unsigned int ListOfAttributes::GetTotalAttributes()
  {
    return size();
  }
  
    /*___________________________________________________________*/

  void ListOfAttributes::setDistance(Attribute* attribute, char* buffer)
  {
    char* cad;
  
   if ((cad = strtok (buffer, " "))==NULL) throw BadFormat(); // name
   int distance=atoi(cad);
    
    switch (distance)
    {
    case 0: attribute->setDistanceType(categorical); break;
    case 1: attribute->setDistanceType(ordinal); break;
    case 2: attribute->setDistanceType(continuous); break;
    default:
      {
        cout <<"Error in .mas file (ListOfAttributes::setDistance), distance in " << buffer <<" is " << distance;
        exit(0);
      }
    }

  }
  /*___________________________________________________________*/

  void ListOfAttributes::setName(Attribute* attribute, char* buffer)
  {
     char* cad;
     if ((cad = strtok (NULL, ":"))==NULL) throw BadFormat(); // name
     attribute->SetName(cad);
    }
  /*___________________________________________________________*/

  void ListOfAttributes::setModalidades(Attribute* attribute, char* buffer)
  {
    char *cad;
    Modalidades* modalidades=new stringList();
     if (!attribute->isContinuous())
    {
      modalidades=new stringList();
      if ((cad = strtok (NULL, ", "))==NULL) 
        throw BadFormat();
      while (cad[0]!='.' && cad[0]!='/' && cad[0]!='\n')
      {
        modalidades->insertElement(string(cad));
        cad = strtok (NULL, ", \n");
      };
      attribute->SetModalidades(modalidades);

      zap(modalidades); 

    }
    else attribute->SetModalidades(NULL);

  }
  /*___________________________________________________________*/

  void ListOfAttributes::ReadAttributes(char* fileMas)
  {
try{
   
    char *cad=NULL, *buffer=NULL;
    ifstream  is;
    Attribute* attribute=NULL;
    int distance;
    int total_attribs=getTotalLines(fileMas);

    OpenInput(fileMas, &is);
    for (int i=0;i<total_attribs;i++)
    {
        buffer=CaptureLine(&is);
        attribute=new Attribute();
         setDistance(attribute, buffer);
         setName(attribute, buffer);
         setModalidades(attribute, buffer);
         insertElement(attribute);
 if (verbosity)
      cout <<"\n " << *attribute;

      zap(attribute);
          zaparr(buffer);

    } // end for//
    is.close();
 if (verbosity)
      cout <<"\n ";

 }
catch (ErrorFile eF)
{
   eF.PrintMessage(fileMas, " ListOfAttributes::ReadAttributes");
}
catch (BadFormat bF)
{
   bF.PrintMessage(fileMas, " ListOfAttributes::ReadAttributes");
}
}
  /*___________________________________________________________ */

  ListOfAttributes::ListOfAttributes(char* texto, bool verbosity, int metadata):Container<vector<Attribute*>, Attribute*>()
  {

this->verbosity=verbosity;
   // hasID=false;
    char fileFormat[256];
    strcpy(fileFormat, texto);
    char ext[4];
    strcpy(ext, "mas\0");

    ChangeExtension (texto, fileFormat, (const char*) ext);
    if (existFile(fileFormat) && metadata<2)
    this->ReadAttributes(fileFormat);
   else 
    {
  if (existFile(fileFormat))
 //   if (metadata==2 || (metadata==1 && !existFile(fileFormat)))
{
readAttributesFromData(texto);
     CrearFicheroMas (fileFormat);
}
else
{
cout <<"Error, file " << fileFormat << " does not exist";
end();
}
 }

//readPositions(texto);
  }


   /*___________________________________________________________ */

  void ListOfAttributes::readAttributesFromData(char* texto)
  {
  
  TextFile* textFile=new TextFile(texto);
  int totalRows=textFile->getTotalLines();
  stringList* pattern;
  Attribute* attribute;
  string value;
  for (int i=0;i<totalRows;i++)
  {
  pattern=textFile->readLine();
  if (i==0)
  for (int j=0;j<pattern->size();j++)
  {
    attribute=new Attribute();
    if (isAFloat(pattern->getElement(j).c_str())) 
    attribute->setDistanceType(continuous);
    else  attribute->setDistanceType(ordinal);
    insertElement(attribute);
    }
  for (int j=0;j<pattern->size();j++)
  {
   attribute=getElement(i);
   value=pattern->getElement(j);
   if (!attribute->isContinuous()) 
   if (attribute->GetModalidades()->findElement(value)==attribute->GetModalidades()->end())
    attribute->GetModalidades()->insertElement(value);
  }
  }
  }
 
  /*___________________________________________________________ */

  ListOfAttributes::~ListOfAttributes()
  {
    };
  /*___________________________________________________________ */

  template<class T> float ListOfAttributes::getDistance(Container<vector<T>, T> * pattern1, Container<vector<T>, T> * pattern2, bool noclass, DistanceMethodClass distanceMethodClass, int classPosition)
  {

    if (size()!=(pattern1->size()+noclass)) {cout <<"error 1 in ListOfAttributes::getDistance", exit(0);};
    if (pattern1->size()!=pattern2->size()) {cout <<"error 2 in ListOfAttributes::getDistance", exit(0);};


    iterator p=getFirst();
    
    typename Container<vector<T>, T>::iterator p1=pattern1->getFirst(), p2=pattern2->getFirst();
    Attribute *attribute;
    float e1, e2, distance=0;
int pos=0;
    while (p1!=pattern1->end())
    {
      if (noclass && classPosition==pos) this->getNext(p);
      
      attribute=*p;

      if (attribute->isSelected())
      {
     
        //if ( this->getTotalSelectedAttributes()>1)
        // cout << "\nsssssss:" << this->getTotalSelectedAttributes();

        if (!attribute->isMissing(pattern1->getElement(p1)))
          if (!attribute->isMissing(pattern2->getElement(p2)))
{
   e1=attribute->GetValue(pattern1->getElement(p1));
        e2=attribute->GetValue(pattern2->getElement(p2));

	distance=distance+attribute->getDistance(e1, e2, distanceMethodClass.numericalAttributeDistanceMethod, pos, classPosition);
            
}
      }
      p=getNext(p);
      p1=pattern1->getNext(p1);
      p2=pattern2->getNext(p2);
pos++;
    }
  if (distanceMethodClass.distanceMethod==SqRoot) return sqrt(distance);
  else  return distance;  //  return (-1);

  };
   /*___________________________________________________________ */

  template <class T> bool ListOfAttributes::isMissing(Container<vector<T>, T>* l) throw (BadSize)
  {
//try{
if (l->size()!=size()) 
{
cout << *this<<"\nversus:\n" << *l;
throw BadSize("ListOfAttributes::isMissing", l->size(), size());

}
typename vector<T>::iterator pL=l->getFirst();
    iterator p=getFirst();
 bool missing=false;
    while (p!=end())
    {
 if (getElement(p)->isMissing((float)*pL)) return true;
  //   if (((Attribute*)*p)->isMissing((float)*pL)) return true;
     // getElement(p)->removeSelection();
      p=getNext(p);
pL=l->getNext(pL);
    }
//}
//catch (BadSize bs) {bs.PrintMessage("ListOfAttributes::isMissing", l->size(), size()); };
return false;
  }
     /*___________________________________________________________ */

  void ListOfAttributes::removeSelection()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      getElement(p)->removeSelection();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::allSelected()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isSelected()==false) return false;
      p=getNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  unsigned int ListOfAttributes::getTotalSelectedAttributes()
  {
    int t=0;
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isSelected()==true) t++;
      p=getNext(p);
    }
    return t;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isDiscretized()
  {
    iterator p=getFirst();
    Attribute* a;
    while (p!=end())
    {
      a=getElement(p);
      if (a->isContinuous() && !a->isDiscretized())
{
//cout <<"\natt " << a <<" is cont";
        return false;
}
      p=getNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isContinuous()
  {
    iterator p=getFirst();
    Attribute* a;
    while (p!=end())
    {
      a=*p;
      if (a->isContinuous())
        return true;
      p=getNext(p);
    }
    return false;
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDiscretePositions(floatList* attPattern)
  {
//cout <<*this;
  intList* positions=new intList();
     try
    {
      floatList::iterator pP=attPattern->getFirst();
      iterator p=getFirst();
      while (pP!=attPattern->end() && p!=end())//pP!=NULL &&
      {
 if (getElement(p)->isContinuous() &&  !getElement(p)->isDiscretized()) throw BadFormat();
//cout << attPattern->getElement(pP);
            positions->insertElement((int)getElement(p)->GetPureValue(*pP));
pP=attPattern->getNext(pP);
p=getNext(p);
      }
     }
      catch (BadFormat bF)
    {
      bF.PrintMessage("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
    }
   return positions;
  }
  
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDiscretePositions(stringList* attPattern)
  {
   
    try
    {
      if (!this->isDiscretized()) throw BadFormat();
      floatList* fPositions=getPositions(attPattern);
      intList* positions=getDiscretePositions(fPositions);
      zap(fPositions);  
      return positions;
     }
      catch (BadFormat bF)
    {
      bF.PrintMessage("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
    }
  }
 
 /*___________________________________________________________ */

template<class T>  stringList* ListOfAttributes::getStringPattern(vector<T>* attPattern)
  {
string nul= "?";
stringList *result=new stringList();
    iterator pL=getFirst();
    typename vector<T>::iterator p=attPattern->getFirst();
while (p!=attPattern->end() && pL!=end())
{
  if (getElement(pL)->isMissing(*p))
  result->insertElement(nul);
 else result->insertElement(tos(attPattern->getElement(p)));
p=attPattern->getNext(p);
pL=getNext(pL);
}

      return result;
     }
    
 
  /*___________________________________________________________ */

  floatList* ListOfAttributes::getValues(stringList* attPattern)
  {
 
    try
    {
       floatList* positions=new floatList();

      Attribute * attribute;
      float value;
      stringList::iterator pP=attPattern->getFirst();
      iterator p=this->getFirst();

      if (attPattern->size()!=size())
        throw BadSize();
      while (p!=end() && pP!=attPattern->end())
      {
        attribute=*p;
	value=attribute->GetPureValue(attPattern->getElement(pP));
        positions->insertElement(value);
        p=getNext(p);
        pP=attPattern->getNext(pP);
      }
         return positions;
    }
    catch (BadSize bs)
    {
      bs.PrintMessage(" ListOfAttributes::getPositions", size(), attPattern->size());
    }
 
  }
  /*___________________________________________________________ */

  void ListOfAttributes::selectAll()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      getElement(p)->select();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */
  // select attributes at attList
  void ListOfAttributes::select(intList* attList)
  {
    removeSelection();
    intList::iterator p=attList->getFirst();
    while (p!=attList->end())
    {
      getElement(attList->getElement(p))->select();
      p=attList->getNext(p);
    }
  }
   /*___________________________________________________________ */
   
   ListOfAttributes* ListOfAttributes::select()
  {
  ListOfAttributes* newList=new ListOfAttributes();

     ListOfAttributes::iterator p=getFirst();

    while (p!=end())
    {
      if (getElement(p)->isSelected()) newList->insertElement(getElement(p));
      p=getNext(p);
    }
    return newList;
  }
 /*___________________________________________________________ */
  // get a vector of selected attributes
  ListOfAttributes* ListOfAttributes::getSelection(intList* attList)
  {

 ListOfAttributes* selectedAtts=new ListOfAttributes(*this);
 selectedAtts->select(attList);
 ListOfAttributes *result=selectedAtts->select();
 zap(selectedAtts);
return result;
}

 /*___________________________________________________________ */
  // get a vector of selected attributes
  intList* ListOfAttributes::getSelection()
  {
 intList* selectedAtts=new intList();
  for (int i=0;i<size();i++)
  if (getElement(i)->isSelected()) selectedAtts->insertElement(i);
return selectedAtts;
}

  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getSelected()
  {
    bool* selected=new bool[GetTotalAttributes()];
    iterator p=getFirst();
    int i=0;
    while (p!=end())
    {
      if (getElement(p)->isSelected())
        selected[i]=true;
      else selected[i]=false;
      p=getNext(p);
      i++;
    }
    return selected;
  }
  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getDiscrete()
  {
    bool* discrete=new bool[GetTotalAttributes()];
    iterator p=getFirst();
    int i=0;
    while (p!=end())
    {
      if (getElement(p)->isContinuous())
        discrete[i]=false;
      else discrete[i]=true;
      p=getNext(p);
      i++;
    }
    return discrete;
  }
 /*___________________________________________________________ */

  void ListOfAttributes::GetDiscreteListOfAttributes(ListOfAttributes* vectorOfDiscreteAttributes)
  {
unsigned int i=0;
    iterator p=getFirst();
    Attribute *attribute, *sourceAttribute;
    stringList* modalidades;
    char val[256];
    while (p!=end())
    {
      sourceAttribute=this->getElement(p);
      attribute=new Attribute(*sourceAttribute);
      if (sourceAttribute->isContinuous())
if (!sourceAttribute->isDiscretized()) throw NonDiscrete("ListOfAttributes::GetDiscreteListOfAttributes()");
else
      {
        modalidades=new stringList();
//cout <<"TOTITNS:" << attribute->GetTotalIntervals();
        for (int i=0;i<attribute->GetTotalIntervals();i++)
{
sprintf(val, "%d", i);
         modalidades->insertElement(string(val));
}
        attribute->setDistanceType(ordinal);// ordered
        attribute->SetModalidades(modalidades);
attribute->removeIntervals();
        zap(modalidades);
      

      }
      vectorOfDiscreteAttributes->insertElement(attribute);
      zap(attribute);
      p=getNext(p);
    }
 }
  /*___________________________________________________________ */

  int ListOfAttributes::getTotalModalidades(int att)
  {
return getElement(att)->GetTotalModalidades();
  }
  /*___________________________________________________________ */

  ListOfAttributes* ListOfAttributes::GetDiscreteListOfAttributes()
  {
    ListOfAttributes* vectorOfDiscreteAttributes;
    vectorOfDiscreteAttributes=new ListOfAttributes();
GetDiscreteListOfAttributes(vectorOfDiscreteAttributes);
return vectorOfDiscreteAttributes;
  }
  /*___________________________________________________________ */

  void ListOfAttributes::removeIntervals()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isContinuous())
        getElement(p)->removeIntervals();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDimensionList(intList* varList)
  {
   intList::iterator p=varList->getFirst();
    intList* dimensionList=new intList();
    Attribute *attribute;
    while (p!=varList->end())
    {
      attribute=getElement(varList->getElement(p));
if (attribute->isContinuous() && attribute->GetTipoDistancia()!=discretized) throw NonDiscrete("ListOfAttributes::getDimensionList");
      dimensionList->insertElement(attribute->GetTotalModalidades());
      if (attribute->GetTotalModalidades()<=1)
      {
        cout <<"Error in ListOfAttributes::getDimensionList, att " << attribute->GetName() << " has only " << attribute->GetTotalModalidades() <<" value: ";
 if (attribute->GetTipoDistancia()==categorical || attribute->GetTipoDistancia()==ordinal)
 cout << *attribute->GetModalidades();
else if (attribute->GetTipoDistancia()==discretized) cout << *attribute->GetIntervals();
        end();
      }
      p=varList->getNext(p);
    }
//cout <<"dimvector is" << *dimensionList <<"\n";
    return dimensionList;
  }


  /*___________________________________________________________________*/

  void ListOfAttributes::CrearFicheroMas (char texto[128])
  {//
    int TotalAttributes, cont=0;
    TotalAttributes=GetTotalAttributes();
    int i=0, i2;
    Attribute *attribute;
    fichero_salida fichero_salida1;
    fichero_salida1.abrir(texto);

    fichero_salida1 << TotalAttributes << " \n"; //

   iterator pA=getFirst();
    while (pA!=end())
    {
      attribute=ListOfAttributes::getElement(pA);
      if (attribute->GetTipoDistancia() == discretized) fichero_salida1 << 1; //changed to ordinal
      else fichero_salida1 << attribute->GetTipoDistancia();
      fichero_salida1 << " " << attribute->GetName() << ": ";

        if (attribute->GetTipoDistancia() != continuous)
        {
          if (attribute->GetTipoDistancia() != discretized)
	  fichero_salida1 << *attribute->GetModalidades();
	  else 
	  for (int i=0; i<attribute->GetTotalModalidades();i++) 
	  {
	  fichero_salida1 << i;
	  if (i<(attribute->GetTotalModalidades()-1))
	   fichero_salida1 << ",";
	   }
         }
        else fichero_salida1 << "continuous\n";
       pA=ListOfAttributes::getNext(pA);
    }
    fichero_salida1.close();

  };//

  /*_______________________________________________________________________________*/

  void ListOfAttributes::CrearFicheroNombres (char texto[128], int classNumber, bool isDiscretized, bool select)
  {//
int totalModalities;
    if (classNumber==-1) classNumber=GetTotalAttributes()-1;
    int i=0, i2;
    iterator pA=ListOfAttributes::getFirst();
    Attribute *inputAttribute, *classAttribute;
    fichero_salida fichero_salida1;
    fichero_salida1.abrir(texto);
    classAttribute=ListOfAttributes::getElement(classNumber);
    stringList::iterator pm=classAttribute->GetModalidades()->getFirst();
vector<float>::iterator pm2;
    i2=0;
    while (pm!=classAttribute->GetModalidades()->end())
    {
      fichero_salida1 << i2;//pm->element;
      pm=classAttribute->GetModalidades()->getNext(pm);
      if (pm!=classAttribute->GetModalidades()->end())
        fichero_salida1  << ", ";
      else
        fichero_salida1 << ".\n";
      i2++;
    }
    pA=getFirst();
    while (pA!=end())
    {
      inputAttribute=ListOfAttributes::getElement(pA);

      if (i!=classNumber && (!select|| inputAttribute->isSelected()))
      {
        fichero_salida1 << inputAttribute->GetName() << ": ";
        if (!isDiscretized &&  ((inputAttribute->GetTipoDistancia() == discretized) || inputAttribute->GetTipoDistancia() == continuous))
          fichero_salida1 << "continuous.\n";
        else
        for(int i2=0;i2< inputAttribute->GetTotalModalidades();i2++)
{
         fichero_salida1 << i2;
if (i2<inputAttribute->GetTotalModalidades()-1) fichero_salida1  << ", ";
else fichero_salida1 << ".\n";
      }
}
      i++;

      pA=ListOfAttributes::getNext(pA);
    }


    fichero_salida1.close();

  }

  /*______________________________________________________*/

float ListOfAttributes::getAlphaDenominator(BayesType bayesType, float alpha, intList *varList, intList *conditionalVarList)
{
float alphaDenominator=alpha;

switch (bayesType)
{
	case UBalpha: alphaDenominator=alpha; break; 
	case BDistanceUniform: 
alphaDenominator=alpha; 
if (conditionalVarList!=NULL && conditionalVarList->size()==1)
alphaDenominator=alpha*getDistance(varList->getFirstElement(), conditionalVarList->getFirstElement());
else alphaDenominator=alpha;
break;
default:break;
}
return alphaDenominator;
}
 /*______________________________________________________*/

ListOfAttributes* ListOfAttributes::copyAttributesWithPositionsIn(intList* columns, bool isThis)
{

ListOfAttributes* res= new ListOfAttributes();

intList::iterator p=columns->getFirst();
while(p!=columns->end())
{
res->insertElement(this->getElement(columns->getElement(p)));
p=columns->getNext(p);
}
return res;
}

  /*___________________________________________________________ */

  floatList* ListOfAttributes::getPositions(stringList* attPattern)
  {
 
    try
    {
       floatList* positions=new floatList();

      Attribute * attribute;
      float value;
      stringList::iterator pP=attPattern->getFirst();
      iterator p=this->getFirst();

      if (attPattern->size()!=size())
        throw BadSize();
      while (p!=end() && pP!=attPattern->end())
      {
        attribute=this->getElement(p);
	value=attribute->GetPureValue(attPattern->getElement(pP));
        positions->insertElement(value);
        p=getNext(p);
        pP=attPattern->getNext(pP);
      }
         return positions;
    }
    catch (BadSize bs)
    {
      bs.PrintMessage(" ListOfAttributes::getPositions", size(), attPattern->size());
    }
 
  }

/*______________________________________________________*/

template<> ostream& operator<<(ostream& out, SetOfAttributes& vectora)
{
   Container<set<Attribute*>, Attribute*>::iterator p=vectora.getFirst();
   out <<"\n";
   while (p!=vectora.end())
   {
//         out << 
     vectora.getElement(p);
     p=vectora.getNext(p); 
     out <<"\n";
   }
   
   return out;
}


};  // Fin del Namespace

#endif

/* Fin Fichero: ListOfAttributes.h */
