#ifndef InformationGain_cpp//
#define InformationGain_cpp//



namespace BIOS 
{

/*______________________________________________________*/

template <class T> InformationGain<T>::InformationGain(BayesType bayesType, float alpha): DependenceMeasure<T>()
{
if (alpha==0) alpha=1;
this->bayesType=bayesType;
}

/*______________________________________________________*/

template <class T> bool InformationGain<T>::better(double m1, double m2)
{
if (m1<m2) return true; else return false;
}

/*______________________________________________________*/

template <class T> double InformationGain<T>::getMeasure(CPT *s1, CPT* s2)
{
cout <<"InformationGain<T>::getMeasure not defined yet";
end();
}


/*______________________________________________________*/

template<> double InformationGain<int>::getMeasure(CPT *s1, CPT* priors)
{
//It is used to compute InformationGain of 2 vars: x and y which is a symmetrical measure E(x)-E(x|y)=E(y)-E(y|x)
// If s1->getConditionals() has not values, a error will be reported
// it always true that E(x|y)<=E(x)
// E(x)=-\sum_i p(x_i)log p(x_i)
// E(x|y)=-\sum_j p(y_j) \sum_i p(x_i|y_j) log p(x_i|y_j) 

  if (s1->getConditionals()==NULL) 
{
cout <<"Error in InformationGain::getMeasure";
end();
}
Entropy<int>* entropy= new Entropy<int>(bayesType, alpha);
CPT* s2=new CPT();
ProbabilityTable* pt=new ProbabilityTable(*s1->getProbabilityTable());
s2->setMarginals(pt);
double informationGain=entropy->getMeasure(s2, priors)-entropy->getMeasure(s1, priors);
zap(s2);
return informationGain;
 }

  /*______________________________________________________*/

template<class T> ostream& operator<<(ostream& out, InformationGain<T>& lista)
{
 
//out << *lista.sample;

return out;
  }

} // end namespace
#endif
