/* File: VarsTable.cpp */


#ifndef __VarsTable_cpp__
#define __VarsTable_cpp__


#include "VarsTable.h"

using namespace std;

namespace BIOS
{


/*_______________________________________________________________*/

 template<class T> VarsTable<T>* VarsTable<T>::getConditional(intList* conditionalVars)
  {
throw NonImplemented("VarsTable<T>::getConditional(intList* conditionalVars)");
}

/*_______________________________________________________________*/

 template<class T> VarsTable<T>* VarsTable<T>::fromString(string s)
  {
throw NonImplemented("VarsTable<T>::fromString(string s)");
}

/*______________________________________________________*/

 template<class T> void VarsTable<T>::set(intSample*  sample, intList *varList, intList* dimensionList, ListOfAttributes* listOfAttributes, floatList* alphaNumerators, float alphaDenominator)//,  intSample::NodePointer first, intSample::NodePointer last)
  {
  try
  {
SampleTable* pT=new SampleTable(sample, varList, dimensionList, listOfAttributes);
 int i;
try
{
   set(varList, pT->totalSample);
int indexFirst;
 for (i=0;i<this->getSize();i++)
{
indexFirst=this->getIndexPositionOfIndexVar(i, 0);
//indexFirst=i%dimensionList->GetFirstElement();
//cout <<"\ntotalSample is " << totalSample <<", val is: " << pT->getValue(i) <<" alphanum: " <<alphaNumerators->GetElement(indexFirst) <<", alphaden: " <<  alphaDenominator;
if (alphaNumerators!=NULL)  
this->table[i]=Prob(pT->getValue(i), totalSample, alphaNumerators->getElement(indexFirst), alphaDenominator);
//else this->table[i]=Prob(pT->getValue(i), totalSample);
else   
this->table[i]=Prob(pT->getValue(i), totalSample, Quotient<double>(alphaDenominator, pT->getSize()), alphaDenominator);
//cout <<"here\n";
}
//if (alphaNumerators!=NULL)
//cout <<"portions2 is" <<*alphaNumerators <<"\n";
    zap(pT);
//end();
    //  cout <<"totalcounts" << this->getTotalCounts();
}
catch (NonProb n){
cout << "num:" << pT->getValue(i) <<", den:" << totalSample <<", alphanum: Prob(" << alphaDenominator <<"," << pT->getSize() <<")" <<", alpha den:" <<  alphaDenominator;
n.PrintMessage("VarsTable<Prob>::set(intMLSample*  sample, intList *varList, intList* dimensionList, floatList* alphaNumerators, float alphaDenominator)");}
catch (MissingValue mv){mv.PrintMessage("VarsTable<Prob>::set"); end();};
}
catch (ZeroValue zv){zv.PrintMessage("VarsTable<Prob>::set(intMLSample*  sample, intList *varList, intList* dimensionList, floatList* alphaNumerators, float alphaDenominator)");end();}

  };


  /*______________________________________________________*/

  template<class T> VarsTable<T>::VarsTable():MultidimensionalTable<T>()
  {
    set();
  };
  /*______________________________________________________*/

  template<class T> void VarsTable<T>::set()
  {
    this->varList=NULL;
    totalSample=0;
    };
 /*_______________________________________________________________*/


  template<class T> int VarsTable<T>::getTotalSample()
  {
 return totalSample;
   }
  /*______________________________________________________*/

  template<class T> VarsTable<T>::VarsTable(VarsTable<T> &source):MultidimensionalTable<T>(source)
  {
    set(&source);
  }
  /*______________________________________________________*/

  template<class T> VarsTable<T>::VarsTable(MultidimensionalTable<T> &source):MultidimensionalTable<T>(source)
  {
    set();
  }
  
 /*_______________________________________________________________*/

   template<class T> VarsTable<double>* VarsTable<T>::convertToPotential()
  {
  cout <<" VarsTable<double>* VarsTable<T> not implemented yet";
end();
  };


  /*______________________________________________________*/

  template<class T> VarsTable<T>::VarsTable(intList *varList, intList* dimensionList):MultidimensionalTable<T>(dimensionList)
  {
    set(varList, 0);
    
  }
  /*______________________________________________________*/

  template<class T> void VarsTable<T>::set(VarsTable *source)
  {
    set();
    if (source->varList==NULL) this->varList=NULL;
    else this->varList=new intList(*source->varList);
    totalSample=source->totalSample;
  }
    /*______________________________________________________*/

  template<class T> void VarsTable<T>::set(intList* varList, intList* dimensionList)
  {
    this->MultidimensionalTable<T>::set(dimensionList);
    set(varList, 0);
  }
 
  /*______________________________________________________*/

  template<class T> void VarsTable<T>::set(intList *varList, int totalSample)
  {

    set();

    this->totalSample=totalSample;
    if (varList==NULL) this->varList=NULL;
    else this->varList=new intList(*varList);
    }


  /*______________________________________________________*/

 template<class T> VarsTable<T>::VarsTable(intSample*  sample, intList *varList, intList* dimensionList, ListOfAttributes* listOfAttributes):MultidimensionalTable<T>(dimensionList)//,  intSample::NodePointer first, intSample::NodePointer last):MultidimensionalTable<T>(dimensionList)
  {
     set(sample, varList, dimensionList, listOfAttributes);//, first, last);
   };
  /*______________________________________________________*/

  template<class T> void VarsTable<T>::initialize(T value)
  {
    for (int i=0;i<this->size;i++)
     setValue(i, value);

  };
 
  /*______________________________________________________*/

  template<class T> void VarsTable<T>::setTotalSample(int totalSample)
  {
  this->totalSample=totalSample;
  };
  /*______________________________________________________*/


template<class T>  VarsTable<T>::~VarsTable(){empty();};
  /*______________________________________________________*/

  template<class T>  void VarsTable<T>::empty(){zap(varList);};
  /*______________________________________________________*/

  template<class T>   void VarsTable<T>::setProductValue(int pos, T first, T second, bool product)
  {
    if (product) this->table[pos]=first*second;
    else this->table[pos]=first/second;
  };



/*_______________________________________________________________*/


  template<class T>  VarsTable<T>* VarsTable<T>::marginalize(intList* sourceVarList)
  {

    if (varList==NULL || sourceVarList==NULL) {cout <<"Error 1 in VarsTable::marginalization"; end();}
    
    if (varList->includes(sourceVarList)==false)
    {
      cout <<"Error in VarsTable::marginalization, marginal list " << *sourceVarList <<" is not included in current var list " << *varList; end();
    }

//cout <<"\niAAnmarg\n";

    if (sourceVarList->size()==0) return new VarsTable<T>(*this);
    if (sourceVarList->size()==varList->size()) return new VarsTable<T>(*this);
    intList* newPosList=varList->copyPositionsWithElementsIn(sourceVarList);
    intList* newVarList=varList->copyElementsIn(sourceVarList);

    //cout <<this->print();
    //cout <<"vars:" << varList->print() <<"chosenpos:" << newPosList->print() <<"\n";
    //end();
    MultidimensionalTable<T>* mT=this->project(newPosList);


    VarsTable<T>* newVarsTable=new VarsTable<T>(*mT);
    newVarsTable->varList=new intList(*newVarList);
newVarsTable->totalSample=this->totalSample;
    //end();
    zap(newVarList);
    zap(newPosList);
    zap(mT);


    return newVarsTable;
  };


 /*_______________________________________________________________*/

  template<class T> VarsTable<T>* VarsTable<T>::operator*(T source)
  {
  VarsTable<T>* newTable= new VarsTable<T>(*this);
  for (int i=0;i<newTable->getSize();i++)
   newTable->table[i]=this->table[i]*source;
   return newTable;
  };
  /*_______________________________________________________________*/

  template<class T> VarsTable<T>* VarsTable<T>::operator*(VarsTable<T>* source)
  {
    return this->product(source, true);
  };

  /*_______________________________________________________________*/

  template<class T> VarsTable<T>* VarsTable<T>::operator/(VarsTable<T>* source)
  {
    return this->product(source, false);

  };

  /*_______________________________________________________________*/

  template<class T> void VarsTable<T>::setValue(int pos, T value)
  {
    MultidimensionalTable<T>::setValue(pos, value);
  };


  /*_______________________________________________________________*/

  template<class T>  VarsTable<T>* VarsTable<T>::product(VarsTable<T>* source, bool product)
  {
    T p1, p2;
      if (varList==NULL && source->varList==NULL) {cout <<"Error in VarsTable:product"; end();}
      
if (source==NULL)  
{
VarsTable<T>* result=new VarsTable<T>(*this);
return result;
}
  

    intList *newVarList=new intList(*varList);
    intList *newDimensionList=new intList(*this->dimensionList);
    typename intList::iterator p=source->varList->getFirst();
     while (p!=source->varList->end())
    {
      if (varList->findElement(source->varList->getElement(p))==source->varList->end())
      {
        newVarList->insertElement(source->varList->getElement(p));
        newDimensionList->insertElement(source->dimensionList->getElement(source->varList->getPosition(p)));
      }
      p=source->varList->getNext(p);
    }
    VarsTable<T>* newVarsTable=new VarsTable<T>(newVarList, newDimensionList);
   
    zap(newDimensionList);

 intList* subList=newVarList->copyElementsIn(source->varList);
  zap(newVarList);
// cout <<"valist is " <<*source->varList <<",and ordered is " << *subList <<"\n";
int orderedPositions[source->totalDimensions];
 for (int i=0;i<source->totalDimensions;i++)
 orderedPositions[i]=source->varList->getPosition(source->varList->findElement(subList->getElement(i)));
zap(subList);
////////////////////////////////


    int*pos;
    int first[this->totalDimensions];
    int second[source->totalDimensions];
    int pos1[this->totalDimensions];
    int pos2[source->totalDimensions];
    int newPos2[source->totalDimensions];

      int c=0, d=0;
    for (int i=0;i<newVarsTable->totalDimensions;i++)
    {
      if (this->varList->findElement(newVarsTable->varList->getElement(i))!=this->varList->end()) { first[c]=i; c++;};
      if (source->varList->findElement(newVarsTable->varList->getElement(i))!=source->varList->end()) { second[d]=i; d++;};
    }
try{
    for (int i=0; i<newVarsTable->size;i++)
    {
      pos=newVarsTable->getPositions(i);
      collapseValues(pos, newVarsTable->totalDimensions, first, pos1, this->totalDimensions);
      collapseValues(pos, newVarsTable->totalDimensions, second, pos2, source->totalDimensions);
      reorderValues(pos2, source->totalDimensions, orderedPositions, newPos2);
  //    p1=source->getValue(newPos2); p2=this->getValue(pos);
//cout <<"first is " << this->getValue(pos) <<" and second is " << source->getValue(pos2);
      newVarsTable->setProductValue(i, this->getValue(pos), source->getValue(newPos2), product);
      zap(pos);
    }
}
catch (MissingValue mv){mv.PrintMessage("VarsTable::Product"); end();};

  //  newVarsTable->setTotalCounts();
//    newVarsTable->normalize();
newVarsTable->totalSample=this->totalSample;
return newVarsTable;
  };
  
/*_______________________________________________________________*/

  template<>  VarsTable<Prob>* VarsTable<Prob>::product(VarsTable<Prob>* source, bool product)
  {
cout << " VarsTable<Prob>::product not implemented yet";
end();
}

  /*____________________________________________________________________________________ */
  template<class T> intList* VarsTable<T>::addMissingVarList(intList* vars, intList* inputPattern, ListOfAttributes* listOfAttributes)
{
intList * extendedVarlist=new intList(*vars);
intList::iterator pL=this->varList->getFirst();
while (pL!=this->varList->end())
{
 if (extendedVarlist->findElement(this->varList->getElement(pL))==false)
 if (listOfAttributes->getElement(this->varList->getElement(pL))->isMissing((float)inputPattern->getElement(this->varList->getElement(pL)))) 
  extendedVarlist->insertElement(this->varList->getElement(pL));
 pL=this->varList->getNext(pL);
}

return extendedVarlist;
}


   /*______________________________________________________*/

    template<class T>  ostream& operator<<(ostream& out, VarsTable<T>& p)
  {
     char posChar[2000];
    int *pos=NULL;
    int pv;
    for (int i=0; i<p.getSize();i++)
    {
      pos=p.getPositions(i);
      out << "\nPot (";
      strcpy(posChar,"\0");

      for (int j=0; j<p.varList->size();j++)
      {


        sprintf(posChar, "%d= %d, ", p.varList->getElement(j), pos[j]);
       out << "var ";
        out << string(posChar);
      }

      out << ") = ";


     // out << tos(p.getValue(pos));
        out << p.getValue(pos);

      zaparr(pos);
    };
  
    return out;
  }
  
}
#endif
