/* File: Multinomial.cpp */


#ifndef __Multinomial_cpp__
#define __Multinomial_cpp__


#include "Multinomial.h"


namespace BIOS {


/**********************************/
Multinomial::Multinomial(int n, int size, double* Probs): Binomial(n)
{
// Probs has size-1 values as the last can be derived from 1-sum(Prob)
// n is the number of samples
Size=size;
this->Probs=Probs;
setAllValues();
}
/**********************************/
Multinomial::~Multinomial()
{
}
/**********************************/
int Multinomial::setValue()
{
int val, c=0;
Binomial* one;
double currentDen=1;
do
{
one=new Binomial(1,Probs[c]/currentDen);
val=one->getNextValue()+c;
zap(one);
currentDen=currentDen-Probs[c];
c++;
}
while ((c+1)<Size && val>(c-1));
return val;
}
/**********************************/
void Multinomial::setAllValues()
{
for (int i=0; i<n;i++)
values[i]=setValue();
}




};  // End of Namespace

#endif

/* End of file: Multinomial.h */




