
#ifndef __chiSquare_c__
#define __chiSquare_c__

namespace BIOS
{

  
/*_______________________________________________________________*/

double pdfChiSquare(double x, int df)
{
// is this correct? 
double h=df/(double)2;
if (x<=0) return 0.0;
return (std::pow(x, h-1)*exp(-x/2))/(std::pow(2,h)*gamma(h));
}
/*_______________________________________________________________*/

double poz(double z) {
        double y, x, w;
        double Z_MAX = 6.0;              /* Maximum meaningful z value */
        
        if (z == 0.0) {
            x = 0.0;
        } else {
            y = 0.5 * abs(z);
            if (y >= (Z_MAX * 0.5)) {
                x = 1.0;
            } else if (y < 1.0) {
                w = y * y;
                x = ((((((((0.000124818987 * w
                         - 0.001075204047) * w + 0.005198775019) * w
                         - 0.019198292004) * w + 0.059054035642) * w
                         - 0.151968751364) * w + 0.319152932694) * w
                         - 0.531923007300) * w + 0.797884560593) * y * 2.0;
            } else {
                y -= 2.0;
                x = (((((((((((((-0.000045255659 * y
                               + 0.000152529290) * y - 0.000019538132) * y
                               - 0.000676904986) * y + 0.001390604284) * y
                               - 0.000794620820) * y - 0.002034254874) * y
                               + 0.006549791214) * y - 0.010557625006) * y
                               + 0.011630447319) * y - 0.009279453341) * y
                               + 0.005353579108) * y - 0.002141268741) * y
                               + 0.000535310849) * y + 0.999936657524;
            }
        }
        if (z > 0.0) return ((x + 1.0) * 0.5);  else return ((1.0 - x) * 0.5);
    }


/*_______________________________________________________________*/
double ex(double x)
{
                /* max value to represent exp(x) */

    if (x < -BIGX) return  0.0; else return exp(x);
    }  
/*_______________________________________________________________*/

double pdfTestChiSquare(double x, int df)
// it computes p value prob (Chi^2>x) and df degrees of freedom
{
        double a, y, s;
        double e, c, z;
        int even;                     /* True if df is an even number */

        const double LOG_SQRT_PI = 0.5723649429247000870717135; /* log(sqrt(pi)) */
        const double I_SQRT_PI = 0.5641895835477562869480795;   /* 1 / sqrt(pi) */
        
        if (x <= 0.0 || df < 1) {
            return 1.0;
        }
        
        a = 0.5 * x;
        even = !(df & 1);
        if (df > 1) {
            y = ex(-a);
        }
        s = (even ? y : (2.0 * poz(-sqrt(x))));
        if (df > 2) {
            x = 0.5 * (df - 1.0);
            z = (even ? 1.0 : 0.5);
            if (a > BIGX) {
                e = (even ? 0.0 : LOG_SQRT_PI);
                c = log(a);
                while (z <= x) {
                    e = log(z) + e;
                    s += ex(c * z - a - e);
                    z += 1.0;
                }
                return s;
            } else {
                e = (even ? 1.0 : (I_SQRT_PI / sqrt(a)));
                c = 0.0;
                while (z <= x) {
                    e = e * (a / z);
                    c = c + e;
                    z += 1.0;
                }
                return c * y + s;
            }
        } else {
            return s;
        }
    }

/*_______________________________________________________________*/

double cdfChiSquare(double x, int df)
{
double h=df/(double)2;
return BIOS::gammai(h,x/2)/(h);
}

//****************************************************************************80

double chiTest (double* observed, double*expected, int df)
// it computes p value given the df+1 absolute frequencies and the df+1 expected values
{
double chi=0;
for (int i=0;i<=df;i++)
{
if (expected[i]==0) throw NanValue("chiTest");
 chi=chi+std::pow(observed[i]-expected[i],2)/expected[i];
}
return pdfTestChiSquare(chi, df);
}
}
#endif
