/*
  The Broad Institute
  SOFTWARE COPYRIGHT NOTICE AGREEMENT
  This software and its documentation are copyright (2005) by the
  Broad Institute/Massachusetts Institute of Technology. All rights are
  reserved.

  This software is supplied without any warranty or guaranteed support
  whatsoever. Neither the Broad Institute nor MIT can be responsible for its
  use, misuse, or functionality.
*/
/* ln of gamma function.  From Numerical Recipes. */

#include <math.h>

double gammln(double xx) {

  double x, tmp, ser;
  static double cof[6] = {76.18009173, -86.50532033, 24.01409822, 
       -1.231739516, 0.120858003e-2, -0.536382e-5};
  int j;

  x = xx - 1.0;
  tmp = x + 5.5;
  tmp -= (x + 0.5) * log(tmp);
  ser = 1.0;
  for (j=0; j <= 5; j++) {
    x += 1.0;
    ser += cof[j]/x;
  }
  return -tmp + log(2.50662827465 * ser);
}












