


#include "../../commonc++/Fachade.h"
#include "../FachadeGenoma.h"

#include "../../commonc++/Fachade.cpp"
#include "../FachadeGenoma.cpp"


/*______________________________________________________________________________*/



using namespace BIOS;

/*_______________________________________________________________________*/

int main ( int argc, char*argv[] )
{
srand(1000);
int totalMeasures=36, totalPermutationMeasures=17, totalPermutations=100, width=10, windowOffset=1;
intList*ignoreMeasures=NULL;
bool useTimeCostingTDTs=false, useOnlyKnownDistributions=true, onlyHetero=true;
SNPPos firstPosition=0, lastPosition=-1;

try
{
	if ( argc<2 )
	{
		cerr << "Error: you have to especify the following information:" << endl;
		cerr  << argv[0] << " <gou file> " << "<solve phase (0: no -default-, 1: yes)> <width (default: 10)> <window offset (default: 2)<first position (1, default)><last position (last position in file .pou, default)>\n";
			exit ( -1 );
	};
	char filename[256], filename2[256]="\0", filename3[256]="\0", ext[256];
	strcpy (filename, argv[1]);
AlleleOrderType alleleOrderType=LeftRight;
 PhaseAlg phaseAlg=weighted;
EMDistributions emDistributions=UTDistributions;
EMRestriction emRestriction=triosBasedRestriction;


bool solvePhase;
if (argc>=3) solvePhase=atoi(argv[2]);


if (solvePhase!=0 && solvePhase!=1) throw BadFormat("in main, alleleOrderType\n");

if (solvePhase) 
alleleOrderType=LeftRightUsingTrios;
else phaseAlg=onlyKnown;





bool maxHap=true;
 if (argc>=4) width=atoi(argv[3]);
 if (argc>=5) windowOffset=atoi(argv[4]);

 if (argc>=6) firstPosition=atoi(argv[5])-1;
 if (argc>=7) lastPosition=atoi(argv[6])-1;

if (useOnlyKnownDistributions) totalPermutations=1;

cout <<"\nconf: " << argc-1 <<" arguments were introduced. file:" << filename <<", phase: " << solvePhase <<", width: " << width <<", window offset: " << windowOffset <<", first pos " << firstPosition+1 <<", last pos: " << lastPosition+1<< "\n";
bool knownPhase=false;
if (alleleOrderType==LeftRight || phaseAlg==onlyKnown) knownPhase=true;

strcpy(filename2, getFilePath(filename));
strcat(filename2, getFilename(filename));



//if (useOnlyKnownDistributions) strcat(filename2, "_onlyKnownNull");

if (!onlyHetero) strcat(filename2, "_AlsoHomo");

// if (width!=10) 
sprintf(filename2, "%s_w%d", filename2, width);

if (firstPosition!=0) sprintf(filename2, "%s_f%d", filename2, firstPosition+1);

if (lastPosition!=-1) sprintf(filename2, "%s_l%d", filename2, lastPosition+1);


strcat(filename2, ".cal");

	strcpy (filename3, filename);
	ChangeExtension(filename, filename3, "bl");
	OpenOutput ( filename2,&OutputFile );

int totalInds=getTotalLines (filename);


ignoreMeasures=new intList();
for (int i=0; i<36; i++)
if (i!=17 && i!=18 && i!=25 && i!=27) // only  tTDT, uTDT, grouping and exact TDT
ignoreMeasures->insertElement(i);



int totalSNPs=GetTotalSNPs(filename);


stringSample* blocks=NULL;


MultimarkerMeasuresByBlocks *method=new MultimarkerMeasuresByBlocks();
method->getMeasures(filename, blocks, windowOffset, width, knownPhase, phaseAlg, emDistributions, emRestriction, totalMeasures, totalPermutationMeasures, totalPermutations, alleleOrderType, totalSNPs, maxHap, ignoreMeasures, useOnlyKnownDistributions, onlyHetero, firstPosition, lastPosition);
OutputFile.close();
cout <<"\nResults have been written in " << filename2;
}
catch (NonImplemented ni){ni.PrintMessage();}
catch (BadFormat bf){bf.PrintMessage();}
catch (NonProb n){n.PrintMessage();}
catch (ORI ori){ori.PrintMessage();}
catch (ORD ord){ord.PrintMessage();}
catch (Inconsistent in){in.PrintMessage();}
catch (NullValue nv){nv.PrintMessage();}
catch (ORLLI e) {e.PrintMessage();}
catch (NonDefined nd) {nd.PrintMessage();}
catch (ZeroValue z) {z.PrintMessage();}
catch (NoMemory nm) {nm.PrintMessage();};
return 0;
};




