/* File: block.h */


#ifndef __block_cpp__
#define __block_cpp__



namespace BIOS {


/************************/
/* block SNP*/
/************************/


/**
        @memo block

	@doc
        Definition:
        An array SampleValues of Size values

        Memory space: O(size). 

        @author Maria M. Abad
	@version 1.0
*/



 
template<> Block* Container<vector<Block*>, Block*>::readElement (ifstream * source, const char* tokens, int* pos, int size)
 {
struct Block *block; 
char* genotypebuf=NULL;
genotypebuf=CaptureLine(source);
string s=string(genotypebuf);
stringList* getVals=getStringVector(genotypebuf, tokens, s.length());
block->IniPos=atoi(getVals->getFirstElement().c_str());
block->LastPos=atoi(getVals->getLastElement().c_str());
zap(getVals);
zaparr(genotypebuf);
return block;
};

 
 /*********************************************************************/
/*
void block::OrderBlockByPos()
{
	if (!IsEmpty())
	{
	SNPPos TotalBlocks=size();
	Block TableBlocks[TotalBlocks];	
	iterator p=getFirst();
	SNPPos i=0;
	while (p!=NULL)
	{
    TableBlocks[i]=getElement(p);
	p=getNext(p);
	i++;
	}
	qsort ((void*)TableBlocks, TotalBlocks, sizeof (struct Block), compareint);


p=getFirst();
i=0;

while (p!=NULL)
{
 ReplaceNode(p, TableBlocks[i]);
 p=getNext(p);
 i++;
}
	}

}
*/
///////////////////
//// public ////////
///////////////////
/*________________________________________________________________________________*/

BlockList::BlockList(char* filename):Container<vector<Block*>, Block*>(filename)
{
//List=NULL;
//GetInfo(filename);
};
/*________________________________________________________________________________*/

BlockList::BlockList():Container<vector<Block*>, Block*>()
{
//List=NULL;
//GetInfo(filename);
};

/*________________________________________________________________________________*/

BlockList::~BlockList()
{
};


/**********************************/
void BlockList::WriteBlocks(char* filename)
{

  try
{
	  OutputFile.open (filename, ifstream::out);
	  if (!OutputFile)
	   throw ErrorFile();
}
catch (ErrorFile NoFile) {
        NoFile.PrintMessage(" block::WriteBlocks");
      }

iterator Pointer=getFirst();
//Block* BlockC;
bool first, some;
double size=0, AverageSize, TotalBlocks=0;
while (Pointer!=this->end())
{
Block *BlockC=getElement(Pointer);
first=true;
size=0;
some=false;
for (unsigned long int i=BlockC->IniPos;i<=BlockC->LastPos;i++)
 //if (ListUsedSNPs==NULL || ListUsedSNPs[i])
 {
        some=true;
	if (first==false)
	OutputFile << ' ';
    else first=false;
	OutputFile << i+1;
	size++;
}
if (some) OutputFile  <<  '\n';
 Pointer=getNext(Pointer);
 AverageSize=AverageSize+size;
 TotalBlocks++;
};

OutputFile.close();

cout << "\nInformation about blocks has been saved in file " << filename <<"\n";
cout << "\nAverage block size: " << AverageSize/TotalBlocks <<"\n";
}




};  // End of Namespace

#endif

/* End of file: BlockList.h */




