/* File: Diplotype.cpp */


#ifndef __Diplotype_cpp__
#define __Diplotype_cpp__


#include "Diplotype.h"

//using namespace UTILS;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

  template <> Diplotype Container<vector<Diplotype>, Diplotype>::readElement (ifstream * source, const char* tokens, int* pos, int size)
{
cout << "Diplotype Container<vector, Diplotype>::readElement not implemented  yet";
end();
};

/******************************************************************/
/*
template <> void Container<vector, Diplotype, std::allocator>::removeNode(Container<vector, Diplotype, std::allocator>::iterator it) 
{
//cout << "insiderem\n";
//zap(this->getElement(it));
//return it2; //this->erase(it);
};

///////////////////
//// public ////////
///////////////////

Diplotype::Diplotype(){};

/*
Diplotype::Diplotype(const DiplotypeS D)
{
Dip.Left=D.Left;
Dip.Right=D.Right;
}
*/
/*____________________________________________________________ */

Diplotype::Diplotype ()
{
}
/*____________________________________________________________ */

Diplotype::Diplotype (const Diplotype & source)
{
Dip=source.Dip;
}
/*____________________________________________________________ */

Diplotype::Diplotype (allele left, allele right)
{
Dip.Left=left;
Dip.Right=right;
}
/*____________________________________________________________ */

Diplotype::Diplotype (DiplotypeS Dip)
{
this->Dip=Dip;
}
/*____________________________________________________________ */

Diplotype::~Diplotype ()
{
//Dip.Left=NA;
//Dip.Right=NA;
}
/*____________________________________________________________ */

void Diplotype::OrderMajorFirst(allele MajorAllele)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

      if (IsHeterozygous(MajorAllele) && Dip.Left!=MajorAllele)
        ChangeAlleles();
 
}
/*____________________________________________________________ */

void Diplotype::OrderRandomly(allele MajorAllele)
{
	// for those heterozygous positions, rewrite alleles randomly
 unsigned short int random;

      if (IsHeterozygous(MajorAllele)) 
	  {
		random=rand() % (2);
//if (random==0) cout <<"0"; else cout <<"1";
		if (random==0 && Dip.Left!=MajorAllele)
        ChangeAlleles();
 	   if (random==1 && Dip.Left==MajorAllele)
        ChangeAlleles();
	  }
}
/*____________________________________________________________ */


bool Diplotype::IsHeterozygous (allele oneAllele)
{
if (!IsANonMissingSNP()) 
throw BadFormat(" at Diplotype::IsHeterozygous ");
return 
		((Dip.Left==oneAllele && Dip.Right!=oneAllele) ||
		 (Dip.Left!=oneAllele && Dip.Right==oneAllele));
}
/*____________________________________________________________ */
/*

bool Diplotype::IsHeterozygous (allele oneAllele, allele otherAllele)
{

return IsANonMissingSNP() 
		&& 
		((Dip.Left==oneAllele && Dip.Right==otherAllele) ||
		 (Dip.Left==otherAllele && Dip.Right==oneAllele));
}
/*____________________________________________________________ */


/*
bool Diplotype::IsHeterozygous (MultiallelicHetero m, allele* alleles, int totalAlleles)
{
int i=mini((int)Dip.Left, (int)Dip.Right);
int j=maxi((int)Dip.Left, (int)Dip.Right);
int k, l, a, b;
//int k=mini((int)alleles, (int)alleles);
//int l=maxi((int)alleles, (int)alleles);
if (!IsANonMissingSNP()) 
throw BadFormat(" at Diplotype::IsHeterozygous ");
//return false; 
switch ((int)m) 
{
case 0: a=0; b=1; break;
case 1: a=0; b=2; break;
case 3: a=1; b=2; break;
case 4: a=1; b=3; break;
case 5: a=2; b=3; break;
}
if (b>=totalAlleles) return false;


k=mini((int)alleles[a], (int)alleles[b]);
l=maxi((int)alleles[a], (int)alleles[b]);
if (i==k && j==l) return true;
return false;
};
/*____________________________________________________________ */



bool Diplotype::IsHeterozygous ()
{
if (!IsANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::IsHeterozygous ");
}
return 		(Dip.Left!=Dip.Right);
}

/*___________________________________________________*/

bool Diplotype::IsHomozygous1 (allele MajorAllele)
{
if (!IsANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::IsHomozygous1 ");
}
return Dip.Left==MajorAllele && Dip.Right==MajorAllele;
}

/*___________________________________________________*/


bool Diplotype::IsHomozygous2 (allele MajorAllele)
{
if (!IsANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::IsHomozygous2 ");
}
return Dip.Left!=MajorAllele && Dip.Right!=MajorAllele;
};

/*___________________________________________________*/

bool Diplotype::IsHomozygous ()
{
if (!IsANonMissingSNP()) 
{
cout <<*this;
throw BadFormat(" at Diplotype::IsHomozygous ");
}
return Dip.Left==Dip.Right;
};

/*___________________________________________________*/

bool Diplotype::IsEqual(Diplotype g)
{
return  Dip.Left==g.getLeftAllele() && Dip.Right==g.getRightAllele();

}

/*___________________________________________________*/

bool Diplotype::operator==(const Diplotype & g)
{
return  IsEqual(g);

}

/*____________________________________________________________ */
           
bool Diplotype::IsANonMissingSNP ()
{
return !IsMissing(true) && !IsMissing(false);
}

/*____________________________________________________________ */
           
bool Diplotype::IsMissing (bool left)
{
if (left) return isMissing((allele)Dip.Left);
else return isMissing((allele)Dip.Right);
}
/*____________________________________________________________ */
           
bool Diplotype::leftIsMissing ()
{
return IsMissing(true);
}
/*____________________________________________________________ */
           
bool Diplotype::rightIsMissing ()
{
return IsMissing(false);
}
/*____________________________________________________________ */
           
bool Diplotype::IsAMissingSNP ()
{
return !IsANonMissingSNP();
}

/*___________________________________________________________ */

void Diplotype::ChangeAlleles ()
{
change (Dip.Left,Dip.Right);
}
/*___________________________________________________________ */

void Diplotype::markAlleles ()
{
if (!IsMarked())
{
//cout <<"DIPleft:" << Dip.Left <<"new:" << (allele)-(int)Dip.Left;
//cout <<"DIpRight:" << Dip.Right  <<"new:" << (allele)-(int)Dip.Right <<"\n";
  Dip.Left=(allele)-(int)Dip.Left;
  Dip.Right=(allele)-(int)Dip.Right;
}
}
/*___________________________________________________________ */

bool Diplotype::IsMarked ()
{
  return (int)Dip.Left<0 || (int)Dip.Right<0;
}
/*__________________________________________________________*/

allele Diplotype::getLeftAllele ()
{
	return Dip.Left;
}
/*__________________________________________________________*/

allele Diplotype::getRightAllele ()
{
	return Dip.Right;
}
/*__________________________________________________________*/

void Diplotype::setLeftAllele (allele Left)
{
	Dip.Left=Left;
}
/*__________________________________________________________*/

void Diplotype::setRightAllele (allele Right)
{
	Dip.Right=Right;
}
/*__________________________________________________________*/

void Diplotype::setAlleles (allele Left, allele Right)
{
	setLeftAllele(Left);
 setRightAllele(Right);
}



/*____________________________________________________________ */
/*
string Diplotype::print(HaplotypeType h)
{
char line[10];
if (h==left) sprintf(line, "%d\0", (int)Dip.Left);
else sprintf(line, "%d\0", (int)Dip.Right);
return string(line);
}

/*____________________________________________________________ */



ostream& operator<<(ostream& out, Diplotype& diplotype)
       {
//    char line[10];
//line[0]='\0';
//if (markUnphased)
//sprintf(line, " %d %d", (int)Dip.Left, (int)Dip.Right);
//else
//sprintf(line, " %d %d", abs((int)Dip.Left), abs((int)Dip.Right));
//return string(line);
out << diplotype.Dip.Left; 
out << " ";
out<< diplotype.Dip.Right <<"\n";
return out;
}

};  // End of Namespace

#endif

/* End of file: Genotype.h */




