
#ifndef __Excep__
#define __Excep__



using namespace std;




class MultiAllelic {
public:
unsigned long int pos;
MultiAllelic(){};
MultiAllelic(unsigned long int pos)
{
this->pos=pos;
}
  void PrintMessage(unsigned long int pos) {
                cout << "\nThere is a Multiallelic SNP at position " << pos<<".\n";
                 exit(0);
 }
        void PrintMessage(unsigned long int pos, unsigned int* Basis) {
                cout << "\nThere is a Multiallelic SNP at position " << pos<<".\n";
                for (int i=0; i<4; i++)
                 if (Basis[i]>0) cout <<"\n"<< Basis[i] << " counts of allele " << i;
		  exit(0);
	}
   void PrintMessage(string message) {
                cout << "\nThere is a Multiallelic SNP at pos " << pos << ", error at " << message  << ".\n";
		exit(0);
	}
		        void PrintMessage() {
                cout << "\nThere is a Multiallelic SNP at pos " << pos << ".\n";
		exit(0);
	}

};

class MonoAllelic {
public:
        void PrintMessage(unsigned long int pos) {
                cout << "\nThere is a Monoallelic SNP at position " << pos<<".\n";
		exit(1);
	}
		        void PrintMessage() {
                cout << "\nThere is a Monoallelic SNP.\n";
		exit(1);
	}

};



class Inconsistent {
public:
string message;
Inconsistent(const char* message)
{
this->message=string(message);
}

        void PrintMessage(unsigned long int pos) {
                cout << "\nThere is an inconsistent SNP at position " << pos<<".\n";
		exit(1);
	}
		        void PrintMessage() {
                cout << "\nThere is an inconsistent SNP at " << message << "\n";
		exit(1);
	}

};

class UnorderedPos {
public:
        void PrintMessage() {
                cout << " Positions are not ordered.\n";
		exit(1);
	}
};




class IncorrectParameters {
public:
        void PrintMessage() {
                cout << "\nEspecified number of individuals y/or number of SNPs do not match with those in the file.\n";
		exit(1);
	}
};


class IncorrectAlgorithm {
string cad;
public:
IncorrectAlgorithm (){};
IncorrectAlgorithm (char* cad) {this->cad=string(cad);}
        void PrintMessage() {

         cout << "Error, algorithm " << cad << " is not allowed";
	exit(1);
	}
};


class IncorrectWay {
public:
        void PrintMessage() {

         cout << "Error, way must be e (for Export) or i (for import)";
	exit(1);
	}
};



class NonHetero {
public:
        void PrintMessage(unsigned int position, int ind=-1) {

         cout << "Error, the position " << position << " is not heterozygotic";
		 if (ind>=0) cout << " for individual " << ind;
	exit(1);
	}
};


class NonExist {
public:
        void PrintMessage(unsigned int position) {

         cout << "Error, the position " << position << " does not exist\n";
	exit(1);
	}
};


class OverflowedSNP {
public:
        void PrintMessage(unsigned long int SNP) {

         cout << "Error, the SNP number " << SNP << " overpass the total number of SNPs\n";
	exit(1);
	}
		void PrintMessage(unsigned long int SNP, const char* message) {

         cout << "Error, the SNP number " << SNP << " overpass the total number of SNPs at " << message <<"\n";
	exit(1);
	}
};


class NonSNP {
public:
const char* val;
NonSNP(){};
NonSNP(const char* val)
{
this->val=val;
}
/*
        void PrintMessage(char* message) {
                cout << " is not a nucleotide valuedd at " << message << ".\n";
		exit(1);
		}
*/

        void PrintMessage(const char* message) {
                cout << val << " is not a nucleotide value at " << message << ".\n";
		exit(1);
		}
/*
		   void PrintMessage(unsigned long int value) {
                cout << value << " is not a nucleotide value.\n";
		exit(1);
	}
//	   void PrintMessage(short int value) {
//                cout << value << " is not a nucleotide value.\n";
//		exit(1);
//	   }
*/
};


class NonFound {
public:
        void PrintMessage() {

         cout << "Error, individual has not been found\n";
	exit(1);
	}
};


class UnsolvedPhase {
public:
        void PrintMessage() {

         cout << "Error, phase non solved\n";
	exit(1);
	}
};



#endif
