/* File: Genoma.cpp */


#ifndef __Genoma_cpp__
#define __Genoma_cpp__


#include "Genoma.h"


namespace BIOS {

ostream& operator<<(ostream& out, Genoma& genoma)
       {
out << *genoma.getGenotype();
return out;
}


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////


Genoma::Genoma()
{
//line=NULL;
PG=NULL;
//DiplotypeList=NULL;
}

/*____________________________________________________________ */

Genoma::Genoma (Genoma * source)
{
//line=NULL;
genotype=source->genotype;
PG=new PairGenotype(source->PG);
ic=source->ic;
//DiplotypeList=NULL;
}
/*____________________________________________________________ */

Genotype* Genoma::getGenotype()
{
return genotype;
}
/*____________________________________________________________ */

Genoma::Genoma (Trio * T, IndCategory i)
{
ic=i;
if (ic!=offspring && ic!=mother && ic!=father)
{ cout <<"Error in Genoma::Genoma\n" << (int)ic;
	exit(0);
}

switch (ic)
{
case offspring:
	genotype=T->genotypeSample->getElement(T->getChildGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getFatherGenotype()), T->genotypeSample->getElement(T->getMotherGenotype())); 
	break;
case father:
	genotype=T->genotypeSample->getElement(T->getFatherGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getChildGenotype()), T->genotypeSample->getElement(T->getMotherGenotype()));
	break;
case mother:
	genotype=T->genotypeSample->getElement(T->getMotherGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getChildGenotype()), T->genotypeSample->getElement(T->getFatherGenotype())); 
}
}
/*____________________________________________________________ */

Genoma::~Genoma ()
{
//zap(line);
zap(PG);
}


/*___________________________________________________*/

SNPPos Genoma::GetHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, bool IsPartiallySolved, Transmission transmission)      
{
// it returns the number of haplotypes in the current genoma (0, 1 or 2) with allele1 at SNP1 and allele2 at SNP2
IndPos Total=getKnownHaps(SNP1, SNP2, allele1, allele2, allAlleles, transmission);

if (Total==0)
{ Total=GetInferredHap(SNP1, SNP2, allele1, allele2, transmission);
if (Total==0 && ic!=offspring) 
Total=GetPartiallySolved(SNP1, SNP2, allele1, allele2, allAlleles, IsPartiallySolved);
}

return Total;
};


/*___________________________________________________*/

SNPPos Genoma::GetUnsolvedHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, bool IsPartiallySolved, Transmission transmission)      
{

IndPos Total=GetInferredHap(SNP1, SNP2, allele1, allele2, transmission);

if (Total==0 && ic!=offspring && transmission==ut)	

Total=GetPartiallySolved(SNP1, SNP2, allele1, allele2, allAlleles, IsPartiallySolved);

return Total;
};


/*___________________________________________________*/

bool Genoma::CanBeInferred (SNPPos pos, AlleleOrderType alleleOrderMode)      
{
// Karnaugh map: 1111/1010/1100/1000  Rows and columns labels: OO, OH, HO, HH
// if is already known, return false
int i;

if (alleleOrderMode==LeftRight) return true;

if  (genotype->getDiplotype(pos)->IsAMissingSNP()) return false;
if (PG->getFirstGenotype()->getDiplotype(pos)->IsAMissingSNP()) return false; 
if (PG->getSecondGenotype()->getDiplotype(pos)->IsAMissingSNP()) return false; 

if  (genotype->getDiplotype(pos)->IsHeterozygous()
	&& PG->getFirstGenotype()->getDiplotype(pos)->IsHeterozygous()
	&& PG->getSecondGenotype()->getDiplotype(pos)->IsHeterozygous()) return false;

return true;

}
/*___________________________________________________*/

bool Genoma::CanBeInferred (const SNPPos* pos, SNPPos totalPos, AlleleOrderType alleleOrderMode)      
{
// Karnaugh map: 1111/1010/1100/1000  Rows and columns labels: OO, OH, HO, HH
// if is already known, return false
int i;

if (genotype->IsPhaseKnown(pos, totalPos, alleleOrderMode)) return false;

while (i<totalPos)
{
if  (genotype->getDiplotype(pos[i])->IsAMissingSNP()) return false;
if (PG->getFirstGenotype()->getDiplotype(pos[i])->IsAMissingSNP()) return false; 
if (PG->getSecondGenotype()->getDiplotype(pos[i])->IsAMissingSNP()) return false; 


if  (genotype->getDiplotype(pos[i])->IsHeterozygous()
	&& PG->getFirstGenotype()->getDiplotype(pos[i])->IsHeterozygous()
	&& PG->getSecondGenotype()->getDiplotype(pos[i])->IsHeterozygous()) return false;
i++;
}
return true;

}
/*___________________________________________________*/

bool Genoma::CanBeInferred (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode) 
{
int pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
return this->CanBeInferred(pos, 2, alleleOrderMode);
}



/*___________________________________________________*/

void Genoma::SetLeftRight (SNPPos SNP, Diplotype & Dip)      
// it changes order of alleles in diplotype Dip by considering the other family member
{
if (PG->getFirstGenotype()->getDiplotype(SNP)->IsHomozygous())
{
if (genotype->getLeftAllele(SNP)!=PG->getFirstGenotype()->getLeftAllele(SNP))
 Dip.ChangeAlleles();
}
else
if (PG->getSecondGenotype()->getDiplotype(SNP)->IsHomozygous() && genotype->getRightAllele(SNP)!=PG->getSecondGenotype()->getLeftAllele(SNP))
 Dip.ChangeAlleles();
}
/*___________________________________________________*/

bool Genoma::MustBeChanged (SNPPos SNP)      
{
if (PG->getFirstGenotype()->getDiplotype(SNP)->IsHomozygous())
{
if (genotype->getLeftAllele(SNP)!=PG->getFirstGenotype()->getLeftAllele(SNP))
 return true;
}
else
if (PG->getSecondGenotype()->getDiplotype(SNP)->IsHomozygous() && genotype->getRightAllele(SNP)!=PG->getSecondGenotype()->getLeftAllele(SNP))
 return true;

return false;
}
/*___________________________________________________*/

SNPPos Genoma::getKnownHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, Transmission transmission)      
{
// it returns the number of haplotypes in the sample with allele1 at SNP1 and allele2 at SNP2
Diplotype *D1=NULL, *D2=NULL;
int result=0;
if (isKnown(SNP1,SNP2)) 
{
 D1=new Diplotype(*genotype->getDiplotype(SNP1));
 D2=new Diplotype(*genotype->getDiplotype(SNP2));
 SetLeftRight(SNP1, *D1);
 SetLeftRight(SNP2, *D2);
bool left=true;
if ((ic==father || ic==mother)  || (ic==offspring && transmission==ut))
for (int i=0;i<2;i++)
if (transmission==ut || (i==0 && transmission==t) || (i==1 && transmission==u))
{
if (i==1) left=false;
if (genotype->isAlleleAllele(allele1, allele2, *D1, *D2, left)) 
 result++;
}
}
zap(D1);
zap(D2);
return result;
}
/*___________________________________________________*/

bool Genoma::isKnown (SNPPos SNP1, SNPPos SNP2)      
{
return !genotype->IsHeterozygousHeterozygous(SNP1, SNP2);
}
/*___________________________________________________*/

SNPPos Genoma::GetInferredHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, AlleleOrderType alleleOrderMode)      
{
Diplotype *D1=NULL, *D2=NULL;
int result=0;
if (CanBeInferred(SNP1,SNP2, alleleOrderMode)) 
{
	D1=new Diplotype(*genotype->getDiplotype(SNP1));
	D2=new Diplotype(*genotype->getDiplotype(SNP2));
	SetLeftRight(SNP1, *D1);
	SetLeftRight(SNP2, *D2);
bool left=true;
if (transmission==u) left=false; // right;
if ((ic==father || ic==mother) && transmission!=ut)
{
if (genotype->isAlleleAllele(allele1, allele2, *D1, *D2, left))
 result= 1;
}
else if (ic==offspring && transmission!=ut) result=0;
else // transmission==ut
{
if (genotype->hasAlleleAllele(allele1, allele2, *D1, *D2))
 result= 1;
}
}
zap(D1);
zap(D2);
return result;
}
/*___________________________________________________*/

SNPPos Genoma::GetPartiallySolved (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele **allAlleles, bool IsPartiallySolved)      
{
allele childAllele1=PG->getFirstGenotype()->getDiplotype(SNP1)->getLeftAllele();
allele childAllele2=PG->getFirstGenotype()->getDiplotype(SNP2)->getLeftAllele();
if (CanBePartiallySolved (SNP1, SNP2, IsPartiallySolved))
if (ic==father)
{
if ((allele1==childAllele1 && allele2==childAllele2) || (allele1!=childAllele1 && allele2!=childAllele2))
return 1;
}
else
{
if (ic==mother)
if ((allele1==childAllele1 && allele2!=childAllele2) || (allele1!=childAllele1 && allele2==childAllele2))
return 1;
}
return 0;
}

/*___________________________________________________*/

bool Genoma::CanBePartiallySolved (const SNPPos* pos, SNPPos totalPos, bool IsPartiallySolved) 
{
if (totalPos==2)
return CanBePartiallySolved(pos[0], pos[1], IsPartiallySolved);
else return false;
}
/*___________________________________________________*/

bool Genoma::CanBePartiallySolved (SNPPos SNP1, SNPPos SNP2, bool IsPartiallySolved)      
{
// it can be partially solved if both parents are double heterozygous and the child is heterohomo
return (ic==father || ic==mother) 
&& IsPartiallySolved 
&& genotype->IsHeterozygousHeterozygous(SNP1, SNP2) 
&& PG->getSecondGenotype()->IsHeterozygousHeterozygous(SNP1, SNP2) // couple
&& (*genotype->getDiplotype(SNP1)==*PG->getSecondGenotype()->getDiplotype(SNP1))
&& (*genotype->getDiplotype(SNP2)==*PG->getSecondGenotype()->getDiplotype(SNP2))
&& PG->getFirstGenotype()->IsHomozygousHeterozygous(SNP1, SNP2) // child
&& ((*genotype->getDiplotype(SNP1)==*PG->getFirstGenotype()->getDiplotype(SNP1))
|| (*genotype->getDiplotype(SNP2)==*PG->getFirstGenotype()->getDiplotype(SNP2)));
}
/*____________________________________________________________ */

PairGenotype* Genoma::getPairGenotype()
{
return PG;
}

/*____________________________________________________________ */

void Genoma::changeTransmittedAlleles(SNPPos SNP, bool father)
{
	// for those heterozygous positions, allele transmitted is the current non transmitted
allele Left, Right;
Genotype* genotypeRelative;
if (father) genotypeRelative=PG->getFirstGenotype(); else genotypeRelative=PG->getSecondGenotype(); 

Left=genotypeRelative->getDiplotype(SNP)->Dip.Left;
Right=genotypeRelative->getDiplotype(SNP)->Dip.Right;

if (father) genotype->SetAlleles(Right, genotype->getDiplotype(SNP)->getRightAllele(), SNP);
else genotype->SetAlleles(genotype->getDiplotype(SNP)->getLeftAllele(), Right, SNP);
genotypeRelative->SetAlleles(Right, Left, SNP);
}

/*____________________________________________________________ */

void Genoma::ChangeAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 genotype->ChangeAlleles(SNP);

}
/*____________________________________________________________ */

void Genoma::markAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 genotype->markAlleles(SNP);

}
/*__________________________________________________________*/

Diplotype* Genoma::getDiplotype(SNPPos SNP)
{
return genotype->getDiplotype(SNP);
}
/*__________________________________________________________*/

};  // End of Namespace

#endif

/* End of file: Genoma.h */




