/* File: Genotype.cpp */


#ifndef __Genotype_cpp__
#define __Genotype_cpp__




//using namespace UTILS;


namespace BIOS {

ostream& operator<<(ostream& out, Genotype& genotype)
       {
     if (genotype.DiplotypeArray==NULL) out << "null diplotype vector";

int last=genotype.TotalSNPs;
if (genotype.DiplotypeArray!=NULL)
for (SNPPos i=0;i<last;i++)
{
 out << genotype.DiplotypeArray[i]->Dip.Left <<" " <<  genotype.DiplotypeArray[i]->Dip.Right;
 if (i<(last-1)) out  <<" "; else out <<"\n";
}
return out;
}
/*________________________________________________________________________________________*/

Genotype* Genotype::fromString (string source)
{
	Genotype* targetGenotype=NULL; 
	Container<vector<Diplotype*>, Diplotype*> *DiplotypeList=NULL;
	DiplotypeList=GenotypeSample::readDiplotype(source.c_str(), source.length()+1);
	SNPPos cont=0, position, TotalSNPs=DiplotypeList->size();
	targetGenotype= new Genotype(TotalSNPs);
		Container<vector<Diplotype*>, Diplotype*>::iterator p=DiplotypeList->getFirst();
	while (p!=DiplotypeList->end())
	{
		targetGenotype->SetDiplotype(DiplotypeList->getElement(p), cont);
		p=DiplotypeList->getNext(p);
		cont++;
	};
//DiplotypeList->erase(DiplotypeList->getFirst(), DiplotypeList->getLast());
zap(DiplotypeList);
//DiplotypeList->erase(DiplotypeList->getFirst(), DiplotypeList->getLast());
//cout <<targetGenotype->print();
//end();
return targetGenotype;
 };

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

Diplotype** Genotype::copy (Diplotype ** DiplotypeArraySource)
{
Diplotype** DiplotypeArrayTarget;
try
{
 if ((DiplotypeArrayTarget=new Diplotype* [TotalSNPs])==NULL)
	throw NoMemory();
for (SNPPos i=0;i<TotalSNPs;i++)
 DiplotypeArrayTarget[i]=new Diplotype(*DiplotypeArraySource[i]);
}
 catch (NoMemory nm) {nm.PrintMessage();}
return DiplotypeArrayTarget;
}


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

Genotype::Genotype()
{
DiplotypeArray=NULL;
TotalSNPs=0;
}
/*____________________________________________________________ */

Genotype::Genotype(SNPPos TotalS)
{
TotalSNPs=TotalS;
try
{
 if ((DiplotypeArray=new Diplotype* [TotalSNPs])==NULL)
	throw NoMemory();
}
 catch (NoMemory nm) {nm.PrintMessage();}

}

/*____________________________________________________________ */

Genotype::Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *Sampling)
{
DiplotypeArray=NULL;
if (Sampling==NULL)
{
TotalSNPs=Source.TotalSNPs;
DiplotypeArray=copy (Source.DiplotypeArray);
}
else
{
TotalSNPs=Sampling->size();
try
{
 if ((DiplotypeArray=new Diplotype* [TotalSNPs])==NULL)
	throw NoMemory();
}
 catch (NoMemory nm) {nm.PrintMessage();}

Container<set<SNPPos>, SNPPos>::iterator p=Sampling->getFirst();
 int i=0;
 while (p!=Sampling->end())
 {
if (Sampling->getElement(p) >= Source.TotalSNPs)
throw OutOfRange<int>(Source.TotalSNPs,"Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *Sampling)");
 DiplotypeArray[i]=Source.DiplotypeArray[Sampling->getElement(p)];

 p=Sampling->getNext(p);
 i++;

 }
 }
}
/*____________________________________________________________ */

Genotype& Genotype::operator=(const Genotype & Source)
{
  if (this!=&Source)  
  {
  TotalSNPs=Source.TotalSNPs;
  zaparr(DiplotypeArray);
  DiplotypeArray=copy (Source.DiplotypeArray);
  } 
  return *this;
}
/*____________________________________________________________ */

Genotype::~Genotype()
{
if (DiplotypeArray!=NULL)
for (int i=0; i<TotalSNPs; i++)
 zap(DiplotypeArray[i]);
zaparr (DiplotypeArray);// we do not delete this vector because we can have sampling
}
/*____________________________________________________________ */

SNPPos Genotype::hasMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2)      
{
return (D1.getLeftAllele()==MajorAllele1 && D2.getLeftAllele()==MajorAllele2) 
		|| (D1.getRightAllele()==MajorAllele1 && D2.getRightAllele()==MajorAllele2); 
}
/*____________________________________________________________ */

SNPPos Genotype::isMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2, bool left)      
{
return (left && D1.getLeftAllele()==MajorAllele1 && D2.getLeftAllele()==MajorAllele2) 
  || (!left && D1.getRightAllele()==MajorAllele1 && D2.getRightAllele()==MajorAllele2); 
}
/*____________________________________________________________ */

SNPPos Genotype::isAlleleAllele (allele allele1, allele allele2, Diplotype D1, Diplotype D2, bool left)      
{
return (left && D1.getLeftAllele()==allele1 && D2.getLeftAllele()==allele2) 
  || (!left && D1.getRightAllele()==allele1 && D2.getRightAllele()==allele2); 
}

/*____________________________________________________________ */

SNPPos Genotype::hasAlleleAllele (allele allele1, allele allele2, Diplotype D1, Diplotype D2)      
{
return (D1.getLeftAllele()==allele1 && D2.getLeftAllele()==allele2) 
  || (D1.getRightAllele()==allele1 && D2.getRightAllele()==allele2); 
}

/*____________________________________________________________ */

SNPPos Genotype::GetTotalSNPs()
{
return	TotalSNPs;
}
/*____________________________________________________________ */

SNPPos Genotype::GetTotalHeterozygousPos()
{
SNPPos total=0;
Diplotype *D;
for (SNPPos i=0;i<TotalSNPs;i++)
{
 D=getDiplotype(i);
 if (D->IsHeterozygous())
  total++;
}
return total;
}

/*____________________________________________________________ */

void Genotype::OrderMajorFirst(allele * * allAlleles)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions
try
{
if (DiplotypeArray==NULL)
 throw NullValue();
for (SNPPos i=0; i<TotalSNPs;i++)
// cout << DiplotypeArray[i].print(); //
DiplotypeArray[i]->OrderMajorFirst(allAlleles[i][0]);
; //cout << "\n";
}
catch (NullValue nv)
{
		 nv.PrintMessage(" in Genotype::getDiplotype");
}
}
/*____________________________________________________________ */

bool Genotype::isMissing (SNPPos SNP)
{
return getDiplotype(SNP)->IsAMissingSNP();
}
/*____________________________________________________________ */

bool Genotype::isHeterozygous(SNPPos SNP)
{
return getDiplotype(SNP)->IsHeterozygous();
}
/*____________________________________________________________ */

bool Genotype::isHomozygous(SNPPos SNP)
{
return getDiplotype(SNP)->IsHomozygous();
}
/*____________________________________________________________ */

void Genotype::OrderRandomly(allele ** allAlleles)
{
	// for those heterozygous positions, rewrite alleles randomly

for (SNPPos i=0; i<TotalSNPs;i++)
 DiplotypeArray[i]->OrderRandomly(allAlleles[i][0]);

}
/*____________________________________________________________ */

void Genotype::ChangeAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 DiplotypeArray[SNP]->ChangeAlleles();

}
/*____________________________________________________________ */

void Genotype::markAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 DiplotypeArray[SNP]->markAlleles();

}
/*____________________________________________________________ */

bool Genotype::IsMarked(SNPPos SNP)
{

 return DiplotypeArray[SNP]->IsMarked();

}
/*__________________________________________________________*/

void Genotype::CheckRangeSNP(SNPPos SNP, const char* message)
{
SNPPos TotalSNPs=GetTotalSNPs();
try
{
	if (SNP>=TotalSNPs)
		throw OverflowedSNP();
}
		 catch (OverflowedSNP ov) {
		 ov.PrintMessage(SNP, message);}
}
/*__________________________________________________________*/

Diplotype* Genotype::getDiplotype(SNPPos SNP)
{
CheckRangeSNP(SNP, "getDiplotype");

//exit(0);
//cout <<"LL:"<< TotalSNPs;
//GetTotalSNPs();
//exit(0);
try
{
if (DiplotypeArray==NULL)
 throw NullValue();
return DiplotypeArray[SNP];
}
 catch (NullValue nv) {
		 nv.PrintMessage(" in Genotype::getDiplotype");}

}
/*__________________________________________________________*/
void Genotype::SetAlleles(allele Left, allele Right, SNPPos SNP)
{
CheckRangeSNP(SNP, "SetAlleles");
DiplotypeArray[SNP]->setLeftAllele(Left);
DiplotypeArray[SNP]->setRightAllele(Right);
}
/*__________________________________________________________*/
void Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)
{
try
{
CheckRangeSNP(SNP, "SetDiplotype");
if (DiplotypeArray==NULL)
throw NullValue();
//zap (DiplotypeArray[SNP]);
DiplotypeArray[SNP]=new Diplotype(*Dip);
}
catch (NullValue nv)
{
		 nv.PrintMessage(" in Genotype::SetDiplotype");
}
}
/*_____________________________________________________________*/

bool Genotype::HaveTheSameHomoPos(Genotype OtherGenotype, SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles)
{
// 
SNPPos TotalSNPs=GetTotalSNPs();
if (TotalPos!=sizeof(Pos) || TotalPos>TotalSNPs)
{
	cerr << "in HaveTheSameHomoPos";
	exit(0);
};

SNPPos i=0;
Diplotype* OtherDip;
while (i<TotalPos)
{
 OtherDip=OtherGenotype.getDiplotype(Pos[i]);
 if (*DiplotypeArray[Pos[i]]!= *OtherDip)      
 return false;
 i++;
}
return true;
}
/*_____________________________________________________________*/

long long int Genotype::getGenotypeCounts (const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing)  throw (OutOfRange<long long int>)
// It returns the genotype position in the current genotype. If any genotype is missing and !includeMissing, it will return -1 
// If onlyHetero && IsHomozygous(), it will return -1
{
int* res=getGenotypeCountsArray(Pos, TotalPos, allAlleles, totalAlleles, tableGenotypes, alleleOrderMode, onlyHetero, includeMissing);
long long int result;
//cout <<"taqblegen:" << *tableGenotypes <<"\n";
if (res!=NULL) result=tableGenotypes->getPos(res); else result=-1;
//if (result<0) throw OutOfRange<long long int>(result, "Genotype::getGenotypeCounts, genotypes are too long"); 
//cout <<"dddd\n";
zaparr(res);
return result;
};  

/*_____________________________________________________________*/

int*  Genotype::getGenotypeCountsArray(const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing)  throw (OutOfRange<long long int>) 
// It returns the genotype positions for the current genotype. If genotype at any position is missing and !includeMissing, it will return -1 
{
SNPPos pos1=0, pos2=0, cont=0, i=0;
Diplotype *D;
int allPos1, allPos2, *positions=new int[TotalPos];

bool isHomo=true;
if (onlyHetero)
{
for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (D->IsHeterozygous())
isHomo=false;
}
if (isHomo)
{
zaparr(positions);
return NULL;
}
}

for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (!includeMissing && D->IsAMissingSNP()) 
{
zaparr(positions);
return NULL;
}
else//positions[i]=getTotalGenotypes(totalAlleles[Pos[i]]);
{
for (int j=0; j<totalAlleles[Pos[i]]; j++)
{
if ((int)allAlleles[Pos[i]][j]==((int)D->getLeftAllele())) allPos1=j;
else if ((int)allAlleles[Pos[i]][j]==abs((int)D->getLeftAllele())) allPos1=-j;
if ((int)allAlleles[Pos[i]][j]==((int)D->getRightAllele())) allPos2=j;
else if ((int)allAlleles[Pos[i]][j]==abs((int)D->getRightAllele())) allPos2=-j;
}
if (alleleOrderMode==LeftRight) {allPos1=abs(allPos1); allPos2=abs(allPos2); };
positions[i]=tableGenotypes->getAmbiguousPosition(allPos1, allPos2, i);
//cout << " pos at: " << i << ": " << positions[i] <<", ";
}
//cout <<"\nals are:" << allPos1 << " and " << allPos2;
//cout << "\n pos at :" << i <<": " << positions[i];
}
return positions; 
}

/*_____________________________________________________________*/

void Genotype::CountGenotypes(MultidimensionalTable<double>* Genotypes, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles,  AmbiguousArray* tableGenotypes) 
// Haps is a multidimensionalTable with the TotalPos dimensions and 10 values each dimension (considering multiallelic SNPs)
{
SNPPos pos1=0, pos2=0, cont=0;
bool missing=false;
bool FoundHetero=false;
//SNPPos TotalSNPs=GetTotalSNPs();
SNPPos i=0;
Diplotype *D;
int allPos1, allPos2;
int *positions=new int[TotalPos];
for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (D->IsAMissingSNP()) missing=true;
else//positions[i]=getTotalGenotypes(totalAlleles[Pos[i]]);
{
for (int j=0; j<totalAlleles[Pos[i]]; j++)
{
if (allAlleles[Pos[i]][j]==D->getLeftAllele()) allPos1=j;
if (allAlleles[Pos[i]][j]==D->getRightAllele()) allPos2=j;
};
positions[i]=tableGenotypes->getAmbiguousPosition(allPos1, allPos2, Pos[i]);
}
}
if (!missing) Genotypes->addValue(positions, 1);
zaparr(positions);
};  

/*____________________________________________________________ */

string Genotype::print(SNPPos first, SNPPos last, bool markUnphased)
{
SNPPos L=last;
if (L==-1) L=TotalSNPs-1;
string result=string("");
     if (DiplotypeArray==NULL) {cout << "null diplotype vector";exit(0);}

for (SNPPos i=first;i<=L;i++)
{
 result=result+printSNP(i, markUnphased);
}
return result;

}
/*____________________________________________________________ */

string Genotype::printSNP(SNPPos snp, bool markUnphased)
{
char *l;
	 if ((l=new char [5])==NULL)
	throw NoMemory();
sprintf(l, "%d %d ", DiplotypeArray[snp]->getLeftAllele(), DiplotypeArray[snp]->getRightAllele());
 string s=string(l);
 zaparr(l);
return s;
}
/*____________________________________________________________ */

string Genotype::print(HaplotypeType h)
{
char *l;
	 if ((l=new char [TotalSNPs*5])==NULL)
	throw NoMemory();
	
strcpy(l, "\0");
for (SNPPos i=0;i<TotalSNPs;i++)
 strcat(l, print(i, h).c_str());
 string s=string(l);
 zaparr(l);
return s;
}

/*___________________________________________________*/

bool Genotype::IsHomozygous1Homozygous1 (SNPPos position, SNPPos position2, allele allele1, allele allele2)      
{
CheckRangeSNP(position, "IsH1H1");
CheckRangeSNP(position2, "IsH1H1b");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHomozygous1(allele1) && D2->IsHomozygous1(allele2);
};
/*___________________________________________________*/

bool Genotype::IsHomozygousHomozygous (SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsHH");
CheckRangeSNP(position2, "IsHHb");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHomozygous() && D2->IsHomozygous();
};
/*___________________________________________________*/

bool Genotype::IsHomozygous1Heterozygous (SNPPos position, SNPPos position2, allele oneAllele)      
{
CheckRangeSNP(position, "IsH1H");
CheckRangeSNP(position2, "IsH1Hb");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHomozygous1(oneAllele) && D2->IsHeterozygous();
}
/*___________________________________________________*/

bool Genotype::IsHeterozygousHomozygous1 (SNPPos position, SNPPos position2, allele oneAllele)      
{
CheckRangeSNP(position, "IsHH1");
CheckRangeSNP(position2, "IsHH1");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHeterozygous() && D2->IsHomozygous1(oneAllele);
};

/*___________________________________________________*/

bool Genotype::IsHomozygousHeterozygous (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsHH");
CheckRangeSNP(position2, "IsHHb");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D2->IsHeterozygous() && D->IsHomozygous();
};
/*___________________________________________________*/

bool Genotype::IsHeterozygousHomozygous (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsHH");
CheckRangeSNP(position2, "IsHHb");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHeterozygous() && D2->IsHomozygous();
};

/*___________________________________________________*/

bool Genotype::IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsHetHet");
CheckRangeSNP(position2, "IsHetHet2");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHeterozygous() && D2->IsHeterozygous();
};
/*___________________________________________________*/
/*
bool Genotype::IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2, MultiallelicHetero i, MultiallelicHetero j, allele* alleles1, allele* alleles2, int totalAlleles1, int totalAlleles2)      
{
CheckRangeSNP(position, "IsHetHet");
CheckRangeSNP(position2, "IsHetHet2");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->IsHeterozygous(i, alleles1, totalAlleles1) && D2->IsHeterozygous(j, alleles2, totalAlleles2);
};


/*___________________________________________________*/

bool Genotype::IsMissingMissing (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsMisMis");
CheckRangeSNP(position2, "IsMisMis2");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->IsAMissingSNP() && D2->IsAMissingSNP();
};

/*___________________________________________________*/

bool Genotype::IsNotMissingNotMissing (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsNMisNMis");
CheckRangeSNP(position2, "IsNMisMis2");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->IsANonMissingSNP() && D2->IsANonMissingSNP();
};

/*___________________________________________________*/

bool Genotype::IsHomozygous1Missing (const SNPPos position, SNPPos position2, allele oneAllele)      
{
CheckRangeSNP(position, "IsH1Mis");
CheckRangeSNP(position2, "IsH1Mis2");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHomozygous1(oneAllele) && D2->IsAMissingSNP();
};
/*___________________________________________________*/

bool Genotype::IsMissingHomozygous1 (const SNPPos position, SNPPos position2, allele oneAllele)      
{
CheckRangeSNP(position, "IsMisH1");
CheckRangeSNP(position2, "IsMisH12");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->IsAMissingSNP() && D2->IsHomozygous1(oneAllele);
};
/*___________________________________________________*/

bool Genotype::IsHeterozygousMissing (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsHetMis");
CheckRangeSNP(position2, "IsHetMis2");

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->IsHeterozygous() && D2->IsAMissingSNP();
};
/*___________________________________________________*/

bool Genotype::IsMissingHeterozygous (const SNPPos position, SNPPos position2)      
{
CheckRangeSNP(position, "IsMisHet");
CheckRangeSNP(position2, "IsMisHet2");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->IsAMissingSNP() && D2->IsHeterozygous();
};
/*___________________________________________________*/

allele Genotype::getLeftAllele (const SNPPos position)      
{
CheckRangeSNP(position, "getLeftAllele");

return DiplotypeArray[position]->getLeftAllele();
};
/*___________________________________________________*/

allele Genotype::getRightAllele (const SNPPos position)      
{
CheckRangeSNP(position, "GetRighAllele");

return DiplotypeArray[position]->getRightAllele();
};
/*___________________________________________________*/

bool Genotype::IsPhaseKnown (const SNPPos SNP1, const SNPPos SNP2, AlleleOrderType alleleOrderMode)      
{
SNPPos pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
return IsPhaseKnown(pos, 2, alleleOrderMode);
}
/*___________________________________________________*/

bool Genotype::hasMissingSNPs (const SNPPos *pos, SNPPos totalPos)      
{
SNPPos TotalSNPs=GetTotalSNPs();
SNPPos i=0;
Diplotype *D;
while (i<totalPos)
{
CheckRangeSNP(pos[i], string("IsMissing"+tos(pos[i])).c_str());
D=getDiplotype(pos[i]);
if (D->IsAMissingSNP()) return true;
i++;
}
return false;
}
/*___________________________________________________*/

bool Genotype::IsPhaseKnown (const SNPPos *pos, SNPPos totalPos, AlleleOrderType alleleOrderType)      
{
if (alleleOrderType==LeftRight) return true;
bool KnownHap=true;
bool FoundHetero=false;
SNPPos TotalSNPs=GetTotalSNPs();
SNPPos i=0;
Diplotype *D;
while (KnownHap==true && i<totalPos)
{
CheckRangeSNP(pos[i], string("IsPhaseKnown"+tos(pos[i])).c_str());
D=getDiplotype(pos[i]);
if (D->IsAMissingSNP()) return false;
if (D->IsHeterozygous() && FoundHetero==true) return false;
if (D->IsHeterozygous() && FoundHetero==false) FoundHetero=true;
i++;
}
return true;
}

/*___________________________________________________*/
/*
double Genotype::GetHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType alleleOrderMode)      
{
CheckRangeSNP(SNP1, "GetHap");
CheckRangeSNP(SNP2, "GetHap2");
BidimensionalTable<int>* table=new BidimensionalTable<int>(totalAlleles[SNP1], totalAlleles[SNP2]);
int al1, al2;
for (int i=0; i<4; i++)
{
if (allAlleles[SNP1][i]==allele1) al1=i;
if (allAlleles[SNP2][i]==allele2) al2=i;
}
int totalPos=2;
int pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
double result=0;
int* position;
longLongList* res=getHapCounts(pos, totalPos, allAlleles, totalAlleles, transmission, alleleOrderMode);
for (int i=0; i<res->size(); i++)
if (res->getElement(i)!=-1) 
{
position=table->getPositions(res->getElement(i));
if (res->size()<=2)
if (position[0]==al1 && position[1]==al2) result++; 
else if (position[0]==al1 && position[1]==al2) result=result+2*((double)1/(double)res->size()); 

zaparr(position);
}
zap(table);
zap(res);
return result;
};

/*___________________________________________________*/
/*
double Genotype::GetAB (SNPPos SNP1, SNPPos SNP2, allele* *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "GetAB");
	CheckRangeSNP(SNP2, "GetAB2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}
/*___________________________________________________*/
/*
double Genotype::GetAb (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "GetAb");

	CheckRangeSNP(SNP2, "GetAb2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}/*___________________________________________________*/
/*
double Genotype::GetaB (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
CheckRangeSNP(SNP1, "GetaB");

CheckRangeSNP(SNP2, "GetaB2");

return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}/*___________________________________________________*/
/*
double Genotype::Getab (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "Getab");

	CheckRangeSNP(SNP2, "Getab2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}

/*____________________________________________________________ */

Diplotype** Genotype::GetGenotype ()
{
	return DiplotypeArray;
}
/*___________________________________________________*/

bool Genotype::CanBeSolved (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode)      
{
	return IsPhaseKnown(SNP1, SNP2, alleleOrderMode);
}

/*___________________________________________________*/

SNPPos Genotype::getFirstHeterozygous ()      
{
	SNPPos TotalSNPs=GetTotalSNPs(), SNP=0;
	while (SNP<TotalSNPs)
	{
		if (getDiplotype(SNP)->IsHeterozygous ())
			return SNP;
		 SNP++;
	}
	return SNP;
}

/*___________________________________________________*/

};  // End of Namespace

#endif

/* End of file: Genotype.h */




