/* File: Genotype.h */


#ifndef __Genotype_h__
#define __Genotype_h__

//using namespace UTILS;


namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

 
class Genotype {


private:
    /** @name Implementation of class Genotype
        @memo Private part.
    */

	

 //  char* line;
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

void CheckRangeSNP(SNPPos SNP, const char* message=NULL);

Diplotype** copy (Diplotype ** DiplotypeArraySource);

		/* PUBLIC FUNCTIONS (INTERFACE) */

public:

Diplotype** DiplotypeArray;

	SNPPos TotalSNPs;

      /** @name Operations on Genotype 
        @memo Operations on a Genotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
Genotype();
	
Genotype(SNPPos TotalSNPs);

//Genotype (const Genotype& Source);

	
Genotype(const Diplotype::DiplotypeS* SourceList, SNPPos TotalSNPs);

Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *Sampling=NULL);

      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
~Genotype ();

      /**
         @memo Assignation
         @param g Genotype to copy.
         @return Reference to the receptor Genotype.
	 @doc
           Copy the Genotype in the receptor Genotype.
           Time complexity O(1).

      */
Genotype& operator=(const Genotype& g);




      /**
         @memo Is equal
         @param g: Genotype to compare with.
	 @return
           Return true if all the Genotype is the same, false otherwise.
         @doc Time complexity O(1).

      */
bool operator==(const Genotype & g){cout <<"Not implemented yet"; exit(0);};;
;
      /**
         @memo Is different
         @param g, position: Genotype to compare with.
	 @return
           Return true if the SNP is different, false otherwise.
         @doc Time complexity O(1).

      */
bool operator!=(const Genotype & g);

SNPPos GetTotalSNPs();
   
void OrderSNPs (allele ** allAlleles);

void OrderMajorFirst (allele ** allAlleles);

allele getLeftAllele (SNPPos position);

allele getRightAllele (SNPPos position);

bool IsEqual(Genotype g, SNPPos position);

Diplotype** GetGenotype ();

//void LinkGenotype (iterator First, iterator Second);

bool isHeterozygous(SNPPos position);

bool isHomozygous(SNPPos position);

bool isMissing(SNPPos position);
	  
bool IsHomozygousHomozygous (SNPPos position, SNPPos position2);      

bool IsHomozygous1Homozygous1 (SNPPos position, SNPPos position2, allele oneAllele, allele secondAllele);      

//bool IsHomozygous2Homozygous2 (SNPPos position, SNPPos position2, allele* MajorAllele);      

//bool IsHomozygous1Homozygous2 (SNPPos position, SNPPos position2, allele* MajorAllele);      

//bool IsHomozygous2Homozygous1 (SNPPos position, SNPPos position2, allele* MajorAllele);      

bool IsHomozygous1Heterozygous (SNPPos position, SNPPos position2, allele oneAllele);      

bool IsHeterozygousHomozygous1 (SNPPos position, SNPPos position2, allele onerAllele);      

//bool IsHomozygous2Heterozygous (SNPPos position, SNPPos position2, allele* MajorAllele);      

//bool IsHeterozygousHomozygous2 (SNPPos position, SNPPos position2, allele* MajorAllele);      

bool IsHomozygousHeterozygous (const SNPPos position, SNPPos position2);      

bool IsHeterozygousHomozygous (const SNPPos position, SNPPos position2);      

//bool IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2, MultiallelicHetero i, MultiallelicHetero j, allele* allele1, allele* allele2, int totalAlleles1, int totalAlleles2);      
bool IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2);     

bool IsMissingMissing (const SNPPos position, SNPPos position2);      

bool IsNotMissingNotMissing (const SNPPos position, SNPPos position2);      

bool IsHomozygous1Missing (const SNPPos position, SNPPos position2, allele oneAllele);      

bool IsMissingHomozygous1 (const SNPPos position, SNPPos position2, allele oneAllele);      

//bool IsHomozygous2Missing (const SNPPos position, SNPPos position2, allele* MajorAllele);      

//bool IsMissingHomozygous2 (const SNPPos position, SNPPos position2, allele* MajorAllele);      

bool IsHeterozygousMissing (const SNPPos position, SNPPos position2);      

bool IsMissingHeterozygous (const SNPPos position, SNPPos position2);      

bool IsPhaseKnown (const SNPPos SNP1, const SNPPos SNP2, AlleleOrderType alleleOrderType);    

bool IsPhaseKnown (const SNPPos *pos, SNPPos totalPos, AlleleOrderType alleleOrderType);      

bool HaveTheSameHomoPos(Genotype OtherGenotype, SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles);

SNPPos hasMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2);      

SNPPos isMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2, bool left=true);      

SNPPos hasAlleleAllele (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2);      

SNPPos isAlleleAllele (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2, bool left=true); 

SNPPos GetTotalHeterozygousPos();

//void CountHaps (IndPos* Haps, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, Transmission transmission=ut, AlleleOrderType alleleOrderMode=MajorFirst); 

//int countHap (IndPos* Hap, const SNPPos Pos[], SNPPos TotalPos, allele ** alleles, Transmission transmission=ut, AlleleOrderType alleleOrderMode=MajorFirst); 

//longLongList* getHapCounts (const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType alleleOrderMode); 

//Pair<int*> getHapCountsArray (const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType alleleOrderMode, AmbiguousArray* tableGenotypes); 

void CountGenotypes (MultidimensionalTable<double>* Genotypes, const SNPPos Pos[], SNPPos TotalPos, allele ** alleles, int* totalAlleles,  AmbiguousArray* tableGenotypes); 

//void CountKnownHaps (IndPos* Haps, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, Transmission transmission=ut); 

//void CountPhasedHaps (IndPos* Haps, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, Transmission transmission=ut); 

SNPPos getFirstHeterozygous ();      

void ChangeAlleles(SNPPos SNP);

void markAlleles(SNPPos SNP);

bool IsMarked(SNPPos SNP);

void OrderRandomly(allele ** allAlleles);

 
 	  /**
         @memo Increase the counter of the total number of known haplotypes between two positions.
         @param comb: pointer to a 5-integer array: 1: 11, 2:12, 3: 21, 4: 22
         @param IndGenotype: individual whose haplotype is going to be checked
         @param FirstSNP, LastSNP: the two loci
     */
     
void CountPairwiseHaps (frequencies comb, SNPPos FirstSNP, SNPPos LastSNP, allele *MajorAllele);

//unsigned short int CountPhasedHap (allele* Hap, const SNPPos Pos[], SNPPos TotalPos, allele * MajorAllele);

void SetDiplotype (Diplotype *Dip, SNPPos SNP);

void SetAlleles(allele Left, allele Right, SNPPos SNP);

string printSNP(SNPPos SNP, bool markUnphased=false);

string printSNP(SNPPos SNP, HaplotypeType h);

string print(SNPPos first=0,SNPPos last=-1, bool markUnphased=false);

string print(HaplotypeType h);

Diplotype* getDiplotype(SNPPos SNP);

SNPPos GetKnownHap (const SNPPos SNP1, const SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, AlleleOrderType alleleOrderMode);      

SNPPos GetPhasedHap (const SNPPos SNP1, const SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles);      

/*double GetHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele **allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode);      

double GetAB (SNPPos SNP1, SNPPos SNP2, allele **allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode);      

double GetAb (SNPPos SNP1, SNPPos SNP2, allele **allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode);      

double GetaB (SNPPos SNP1, SNPPos SNP2, allele **allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode);      

double Getab (SNPPos SNP1, SNPPos SNP2, allele **allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode);  
*/
bool CanBeSolved (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode);      


int*  getGenotypeCountsArray(const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing)  throw (OutOfRange<long long int>);

long long int getGenotypeCounts (const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool useMissing)  throw (OutOfRange<long long int>);
    
//void LinkGenotype (Genotype* First, Genotype* Second);

//iterator getFirstRelative ();

//iterator GetSecondRelative ();

bool hasMissingSNPs (const SNPPos *pos, SNPPos totalPos);      


		bool  operator>(const Genotype & ge){cout <<"Not implemented yet"; exit(0);};;

		bool  operator<(const Genotype & ge){cout <<"Not implemented yet"; exit(0);};;

static Genotype* fromString(string s);

};  // End of class Genotype

ostream& operator<<(ostream& out, Genotype& genotype);
 

};  // End of Namespace

#endif

/* End of file: Genotype.h */




