/* File: GenotypeSample.cpp */


#ifndef __GenotypeSample_cpp__
#define __GenotypeSample_cpp__



//using namespace UTILS;

namespace BIOS {




/*___________________________________________________________ */


Container<vector<Diplotype*>, Diplotype*>*  GenotypeSample::readDiplotype (const char * source, int len)
{
Container<vector<Diplotype*>, Diplotype*>* ld=new Container<vector<Diplotype*>, Diplotype*>();
	Diplotype::Diplotype *Dip;
	long long int cont=0;
char line[200], c1, c2, sep, * genotypebuf=new char[len], *cad, cadena[2], cadena2[2];
strncpy(genotypebuf, source, len);
	while (genotypebuf[cont]!='\0'){if (genotypebuf[cont]==',') genotypebuf[cont]=' ';cont++;	};
cont=0;
cad = strtok (genotypebuf," \t");
for (int phen=0;phen<7;phen++)cad = strtok (NULL," \t");
try
{
    while (cad!=NULL && ((strlen(cad)==2 && cad[0]=='-' && IsACorrectAllele(cad[1])) || IsACorrectAllele(cad[0])))
    {
Dip=new Diplotype();
	if (strlen(cad)==1 || (strlen(cad)==2 && cad[0]=='-'))
	{
	strcpy(cadena, "\0");
	sscanf (cad, "%s", cadena);
	Dip->setLeftAllele(ConvertAllele(cadena));
	cad = strtok (NULL," \t\r\n");
	if (cad==NULL) 	throw NullValue();
	sscanf (cad, "%s", cadena);
	Dip->setRightAllele(ConvertAllele(cadena));
    }
	else  if (strlen(cad)==3)
	{
	sscanf (cad, "%c%c%c", &c1, &sep, &c2);
    if (!IsACorrectAllele(c2)) 
	{   
		sprintf(line, "vector<Diplotype>::ReadElement, value: \"%c\"", c2);
		throw NonSNP(&c2);
	}
sprintf(line, "vector<Diplotype>::ReadElement, ConvertAllele value: \"%c\"", c1);
	Dip->setLeftAllele(ConvertAllele(&c1));
sprintf(line, "vector<Diplotype>::ReadElement, ConvertAllele value: \"%c\"", c2);
	Dip->setRightAllele(ConvertAllele(&c2));
    }
else{sprintf(line, "vector<Diplotype>::ReadElementB value: \"%c\"", c1);throw NonSNP(&c1);}

ld->insertElement(Dip);
	cad = strtok (NULL," \t");
	cont=cont+1;
	}// end while
if (ld==NULL) throw NullValue("readDiplotype\n");
if (ld->size()==0) throw BadFormat("readDiplotype\n");
}
 catch (NullValue nv) { nv.PrintMessage(line);}   
 catch (NonSNP ns) { cout << "failed snp row was " << genotypebuf<<", cad is " << cad << ", snp is " << cont << "\n"; ns.PrintMessage(line);}   
zaparr(genotypebuf, len);
return ld;
}


/*________________________________________________________________________________________*/

//template <> Genotype* Container<vector, Genotype*>::readElement (ifstream * source, const char* tokens)
Genotype* GenotypeSample::readElement (ifstream * source, const char* tokens, int* pos, int size)
{
	char *line =CaptureLine(source);
string s=string(line);
Genotype* genotype=Genotype::fromString(s), *genotypeTemp=NULL;
zaparr(line);
if (pos!=NULL)
{
genotypeTemp=genotype, genotype= new Genotype(size);
 for (int i=0; i<size; i++) genotype->SetDiplotype(genotypeTemp->getDiplotype(pos[i]), i);
zap(genotypeTemp);
}
return genotype;
	
 };





/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


//////////// privates /////////////





/*____________________________________________________________ */

 GenotypeSample::~GenotypeSample ()
		{
if (allAlleles!=NULL)
  for (int i=0; i<GetTotalSNPs(); i++)
   zaparr(allAlleles[i]);
  zaparr(allAlleles);
zaparr(totalAlleles);
//this->erase(begin(), end());
//cout <<"gen\n";
//	cout <<*this;
		};
/*____________________________________________________________ */

GenotypeSample::GenotypeSample():Container<vector<Genotype*>, Genotype*>()
{
outputSeparator=' ';
//MajorAllele=NULL;
//MinorAllele=NULL;
allAlleles=NULL;
totalAlleles=NULL;
}
 
/*____________________________________________________________ */

GenotypeSample::GenotypeSample (GenotypeSample& source, Container<set<SNPPos>, SNPPos> * SNPSampling):Container<vector<Genotype*>, Genotype*>()
{
if (source.AlleleOrderMode==MajorFirst || source.AlleleOrderMode==random)
{
cout <<" Not available at GenotypeSample::GenotypeSample (GenotypeSample& source)";
exit(0);
}
outputSeparator=source.outputSeparator;
AlleleOrderMode=source.AlleleOrderMode;
totalAlleles=NULL;
allAlleles=NULL;
iterator p=source.getFirst();
Genotype* g,*g2;
while (p!=source.end())
{
g=source.getElement(p);
g2=new Genotype(*g, SNPSampling);
insertElement(new Genotype(*g, SNPSampling));
p=source.getNext(p);
}
//setAllAlleles(NULL);
SNPPos totalSNPs=GetTotalSNPs(), k;
if (source.allAlleles!=NULL && source.totalAlleles!=NULL)
{
totalAlleles=new int[totalSNPs];
allAlleles=new allele*[totalSNPs];
Container<set<SNPPos>, SNPPos>::iterator it;
if (SNPSampling!=NULL) it=SNPSampling->begin();
  for (int j=0;j<totalSNPs;j++)
{
//cout <<" \ntotal at " << j << ": " << source.totalAlleles[j];
if (SNPSampling==NULL) k=j; else k=*it;
allAlleles[j]=new allele[source.totalAlleles[k]];
 for (int i=0; i<source.totalAlleles[k]; i++)
   allAlleles[j][i]=source.allAlleles[k][i];
totalAlleles[j]=source.totalAlleles[k];
if (SNPSampling!=NULL) it++;
}
}
}

/*____________________________________________________________ */

GenotypeSample::GenotypeSample (char * filename, int*pos, int size,  AlleleOrderType AlleleOrderMod):Container<vector<Genotype*>, Genotype*>()
{
outputSeparator=' ';
getInfo(filename, NULL, pos, size);
allAlleles=NULL;
totalAlleles=NULL;
AlleleOrderMode=AlleleOrderMod;
setAllAlleles(NULL);
switch (AlleleOrderMode)
{
case NotChanged: 
case LeftRight: break;
case MajorFirst: OrderMajorFirst(); break;
case random: OrderRandomly(); break;
};
}


/*____________________________________________________________ */

GenotypeSample& GenotypeSample::operator=(const GenotypeSample & Source)
{
   if (&Source!=NULL)
    {
    
      if (this!=&Source)
      {

        if (this->getFirst()!=this->end())
           this->empty();
  
        this->copyPaste((GenotypeSample*)&Source);


  //SetMajorAllele (NULL);
  //SetMinorAllele (NULL);
setAllAlleles(NULL);
  }
}

  return *this;
}

/*____________________________________________________________ */

GenotypeSample* GenotypeSample::setTransmissionRandomly(SNPPos firstSNP, SNPPos nextLastSNP)
{
SNPPos last=nextLastSNP;
GenotypeSample* newGenotypeSample=this->clone();

GenotypeSample::iterator p=newGenotypeSample->getFirst();
Genotype* genotype;
int totalSNPs=GetTotalSNPs();
if (last==0) last=totalSNPs;
while (p!=newGenotypeSample->end())
{
 genotype=getElement(p);

for (int i=firstSNP; i<last; i++)
 if (rand()%2==0)
 genotype->ChangeAlleles(i);
p=newGenotypeSample->getNext(p);
}

return newGenotypeSample;
}
/*____________________________________________________________ */

SNPPos GenotypeSample::GetTotalSNPs ()
{
return getElement(getFirst())->GetTotalSNPs();
}
/*____________________________________________________________ */

SNPPos GenotypeSample::GetTotalAllele (SNPPos SNP, allele allele1, const bool Marked[])
{
iterator IndGenotype=getFirst();
Genotype *genotype;
SNPPos Total=0, cont=0;
while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 genotype=getElement(IndGenotype);
//cout <<"\n" << *genotype->getDiplotype(SNP);
 if (genotype->getDiplotype(SNP)->IsANonMissingSNP())
{
	if (genotype->getDiplotype(SNP)->IsHomozygous1 (allele1)) Total=Total+2; 
	if (genotype->getDiplotype(SNP)->IsHeterozygous(allele1)) Total++; 
 }
}
 IndGenotype=getNext(IndGenotype);
 cont++;
}
return Total;
}
/*____________________________________________________________ */

allele GenotypeSample::getMajorAllele (SNPPos SNP, const bool Marked[])
{


if (allAlleles==NULL) setAllAlleles(Marked);


//cout <<MajorAllele[SNP] <<"-";
return allAlleles[SNP][0];
}
/*____________________________________________________________ */

allele GenotypeSample::getMinorAllele (SNPPos SNP, const bool Marked[])
{


if (allAlleles==NULL) setAllAlleles(Marked);

//cout <<MinorAllele[SNP] <<"\n";
return allAlleles[SNP][1];
}

/*____________________________________________________________ */
/*
intList* GenotypeSample::getIndList(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[]) 
{
// it returns a list with the position number of individuals in the sample which have haplotype allele1 for SNP1 and allele2 for SNP2
iterator IndGenotype=getFirst();
Genotype * genotype;
double Total=0;
int cont=0;
bool phased=false;
intList* result=new intList();
//cout <<"\n";
while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 genotype=getElement(IndGenotype);
 Total=genotype->GetHap(SNP1, SNP2, allele1, allele2, allAlleles, totalAlleles, transmission, AlleleOrderMode);     
 if (Total>0) result->insertElement(cont);
//cout << "contmarked:" << cont;
 }
 IndGenotype=getNext(IndGenotype);
cont++;
}
//cout <<"\n";
return result;
}


/*____________________________________________________________ */
/*
int* GenotypeSample::countAlleles(const SNPPos *pos, int totalPos, const bool Marked[]) 
{
int* alleleCounts=Initialize(totalPos, 0);
unsigned int* Basis=Initialize(5, (unsigned int)0);

for (int i=0; i<totalPos;i++) 
 alleleCounts[i]=CountAlleles(pos[i], Basis, Marked);
zaparr(Basis);
return alleleCounts;
}
/*____________________________________________________________ */

MultidimensionalTable<double>* GenotypeSample::countGenotypes(const SNPPos *pos, int totalPos, allele** allAlleles, const bool Marked[]) 
{
intList* dimensionList=new intList();
for (int i=0; i<totalPos;i++) dimensionList->insertElement(totalAlleles[pos[i]]);

MultidimensionalTable<double>* result=new MultidimensionalTable<double>(dimensionList);
zap(dimensionList);

dimensionList=new intList();
for (int i=0; i<totalPos;i++) dimensionList->insertElement(getTotalGenotypes(totalAlleles[pos[i]]));

AmbiguousArray* tableGenotypes=new AmbiguousArray(dimensionList);
zap(dimensionList);

iterator IndGenotype=getFirst();
Genotype * genotype;
SNPPos Total=0, cont=0;
bool phased=false;
int* positions;
while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 genotype=getElement(IndGenotype);
 genotype->CountGenotypes(result, pos, totalPos, allAlleles, totalAlleles, tableGenotypes);     
 }
 IndGenotype=getNext(IndGenotype);
}
zap(tableGenotypes);
return result;
}
/*____________________________________________________________ */
/*
double GenotypeSample::GetHap(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[]) 
{
iterator IndGenotype=getFirst();
Genotype * genotype;
double Total=0;
int cont=0;
bool phased=false;

while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 genotype=getElement(IndGenotype);
 Total=Total+genotype->GetHap(SNP1, SNP2, allele1, allele2, allAlleles, totalAlleles, transmission, AlleleOrderMode);     
 }
 cont++;
 IndGenotype=getNext(IndGenotype);
}
return Total;
}
/*____________________________________________________________ */
/*
SNPPos GenotypeSample::GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, AlleleOrderType alleleOrderType, const bool Marked[]=NULL)
{
SNPPos Total=0, cont=0;
iterator IndGenotype=getFirst();
Genotype *G;
while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=getElement(IndGenotype);
 if (G->IsHeterozygousHeterozygous (FirstSNP, LastSNP, i, j, allAlleles[FirstSNP], allAlleles[LastSNP], totalAlleles[FirstSNP], totalAlleles[LastSNP])) 
{
  if (G->CanBeSolved (FirstSNP, LastSNP, alleleOrderType)==false)     
   Total=Total+1; 
}
 };
 IndGenotype=getNext(IndGenotype);
 cont++;
}
return Total;
}
/*____________________________________________________________ */


    int* GenotypeSample::getAlleleFrequencies(allele alleleType, const bool Marked[])
{
SNPPos totalSNPs=GetTotalSNPs();
int * result=Initialize(totalSNPs, 0);
for (SNPPos i=0;i<totalSNPs;i++)
//if (alleleType==NA) // NA
//result[i]=GetTotalType (i, missing, Marked)*2;
result[i]=GetTotalAllele(i, alleleType, Marked);
return result;
}

/*____________________________________________________________ */
/*
double GenotypeSample::GetnAB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
{
return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][0], transmission, Marked);
};  
/*____________________________________________________________ */
/*
double GenotypeSample::GetnAb(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
{
return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][1], transmission, Marked);
};  
/*____________________________________________________________ */
/*
double GenotypeSample::GetnaB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
{
return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][0], transmission, Marked);
};  
/*____________________________________________________________ */
/*
double GenotypeSample::Getnab(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]=NULL)
{
return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][1], transmission, Marked);
};  
/*____________________________________________________________ */

void GenotypeSample::OrderMajorFirst ()
{
try
{

if (allAlleles==NULL)
throw NullValue();

  iterator IndGenotype=getFirst();
  Genotype *g;
  while (IndGenotype!=end())
  {
	  g=getElement(IndGenotype);
//cout << g->print() <<"\n";
	  g->OrderMajorFirst(allAlleles);
	  IndGenotype=getNext(IndGenotype);
  }
}
catch (NullValue nv)
{ nv.PrintMessage(" in GenotypeSample::OrderMajorFirst, MajorAllele is NULL");
}
}
/*____________________________________________________________ */

void GenotypeSample::OrderRandomly ()
{
  srand(24226616);
  iterator IndGenotype=getFirst();
  Genotype *g;
  while (IndGenotype!=end())
  {
	  g=getElement(IndGenotype);
	  g->OrderRandomly(allAlleles);
	  //ReplaceNode(IndGenotype, g);
	  IndGenotype=getNext(IndGenotype);
  }
 //   cout <<"Sorting randomly has finished\n";

}

/*____________________________________________________________ */

void GenotypeSample::PrintHaplotypes (char* filename)
 {

  GenotypeSample::iterator IndGenotype=getFirst();
  Genotype *genotype;
  OpenOutput(filename, &OutputFile); 

  SNPPos TotalSNPs=GetTotalSNPs();

while (IndGenotype!=end())
  {
   genotype=getElement(IndGenotype);
   OutputFile << genotype->print(left);     
   OutputFile << "\n";
   OutputFile << genotype->print(right);     
   OutputFile << "\n";
   IndGenotype=getNext(IndGenotype);
  }
  OutputFile.close();

cout << "\nInformation about haplotypes has been saved in file " << filename <<"\n";
 }

/*____________________________________________________________ */

void GenotypeSample::PrintGenotypes (char* filename)
 {

  OpenOutput(filename, &OutputFile); 
  OutputFile << *this;     
  OutputFile.close();

cout << "\nInformation about genotypes has been saved in file " << filename <<"\n";
 }
/*__________________________________________________________*/

SNPPos GenotypeSample::getTotalType (SNPPos SNP, int typ, const bool Marked[]=NULL)
{
GenotypeSample::iterator IndGenotype=GenotypeSample::getFirst();
Genotype* genotype;
Diplotype* Dip;
IndPos Total=0, cont=0;
while (IndGenotype!=end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 genotype=getElement(IndGenotype);
 Dip=genotype->getDiplotype(SNP);
 if (typ==getPosGenotype((int)Dip->getLeftAllele(), (int)Dip->getRightAllele(), totalAlleles[SNP])) Total++;// plus 1 to count missing values
 }
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
}
return Total;
}

/*__________________________________________________________*/

SNPPos GenotypeSample::getTotalMarked (const bool Marked[])
{
if (Marked==NULL) return size();
GenotypeSample::iterator IndGenotype=GenotypeSample::getFirst();
IndPos cont=0;
while (IndGenotype!=end())
{
 if (Marked[cont]==true)
 cont++;
 IndGenotype=GenotypeSample::getNext(IndGenotype);
}
return cont;
}
/*___________________________________________________________*/
/*
SNPPos GenotypeSample::GetTotalHomozygous1 (SNPPos SNP, const bool Marked[]=NULL)
{
	return (GetTotalType (SNP, homozygous1, Marked));
}
/*___________________________________________________________*/
/*
SNPPos GenotypeSample::GetTotalHomozygous2 (SNPPos SNP, const bool Marked[]=NULL)
{
	return (GetTotalType (SNP, homozygous2, Marked));
}
/*___________________________________________________________*/
/*
SNPPos GenotypeSample::GetTotalHeterozygous (SNPPos SNP, const bool Marked[]=NULL)
{
	return (GetTotalType (SNP, heterozygous, Marked));
}
/*___________________________________________________________*/

SNPPos GenotypeSample::getTotalMissing (SNPPos SNP, const bool Marked[]=NULL)
{
	return getTotalType (SNP, getPosGenotype((int)NA, (int)NA, totalAlleles[SNP]), Marked);
}
/*___________________________________________________________*/

SNPPos GenotypeSample::getTotalNonMissing (SNPPos SNP, const bool Marked[]=NULL)
{
return getTotalMarked()-getTotalMissing(SNP);

//	return GetTotalHomozygous1 (SNP, Marked)+GetTotalHomozygous2(SNP, Marked)+GetTotalHeterozygous(SNP, Marked);
}

/*____________________________________________________________ */

IndPos GenotypeSample::getTotalMissingGenotypes (const bool Marked[])
{
IndPos Total=0, i, cont=0;
iterator IndGenotype=GenotypeSample::getFirst();
Genotype * G;
bool missing;
while (IndGenotype!=GenotypeSample::end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=GenotypeSample::getElement(IndGenotype);
 missing=false;
 i=0;
 while (missing==false && i<GetTotalSNPs())
{
 if (G->isMissing (i)) missing=true; 
i++;
}
 if (missing) Total++;
}
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
 }
return Total;
}
/*____________________________________________________________ */

SNPPos GenotypeSample::getHeterozygousHomozygous1 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[])
{
SNPPos Total=0, cont=0;
iterator IndGenotype=GenotypeSample::getFirst();
Genotype * G;
while (IndGenotype!=GenotypeSample::end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=GenotypeSample::getElement(IndGenotype);
 if (G->IsHeterozygousHomozygous1 (FirstSNP, LastSNP, allAlleles[LastSNP][0])) Total=Total+1; 
 }
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
 }
return Total;
}
/*____________________________________________________________ */

SNPPos GenotypeSample::getHomozygous1Heterozygous (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[])
{
SNPPos Total=0, cont=0;
iterator IndGenotype=GenotypeSample::getFirst();
Genotype * G;
while (IndGenotype!=GenotypeSample::end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=GenotypeSample::getElement(IndGenotype);
 if (G->IsHomozygous1Heterozygous (FirstSNP, LastSNP, allAlleles[FirstSNP][0])) Total=Total+1; 
 }
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
 }
return Total;
}
/*____________________________________________________________ */

SNPPos GenotypeSample::getHomozygous1Homozygous1 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[])
{
SNPPos Total=0, cont=0;
iterator IndGenotype=GenotypeSample::getFirst();
Genotype * G;
while (IndGenotype!=GenotypeSample::end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=GenotypeSample::getElement(IndGenotype);
 if (G->IsHomozygous1Homozygous1 (FirstSNP, LastSNP, allAlleles[FirstSNP][0], allAlleles[LastSNP][0])) Total=Total+1; 
 }
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
 }
return Total;
}
/*____________________________________________________________ */
/*
SNPPos GenotypeSample::getDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, const bool Marked[])
{
SNPPos Total=0, cont=0;
iterator IndGenotype=GenotypeSample::getFirst();
Genotype * G;
while (IndGenotype!=GenotypeSample::end())
{
 if (Marked==NULL || Marked[cont]==true)
 {
 G=GenotypeSample::getElement(IndGenotype);
 if (G->IsHeterozygousHeterozygous(FirstSNP, LastSNP, i, j, allAlleles[FirstSNP], allAlleles[LastSNP], totalAlleles[FirstSNP], totalAlleles[LastSNP])) Total=Total+1; 
 }
 IndGenotype=GenotypeSample::getNext(IndGenotype);
 cont++;
 }
return Total;
}


/*____________________________________________________________ */

int* GenotypeSample::CountAlleles (SNPPos SNP, const bool Marked[]=NULL)
{
// It returns the total frequencies of the different alleles used in marked genotypes. 
// It includes missing as a different allele

IndPos cont=0;
int* Basis=Initialize(5, 0);

Genotype * genotype=NULL;
for (iterator indGenotype=getFirst(); indGenotype<end(); indGenotype++)
{

if (Marked==NULL || Marked[cont]==true)
{

 genotype=getElement(indGenotype);
// absolute values has to be used to catch those marked as unphased
Basis[abs((int)genotype->getLeftAllele(SNP))-1]++; 
Basis[abs((int)genotype->getRightAllele(SNP))-1]++; 

 }
 cont++;
}
return Basis;

}

/*____________________________________________________________ */

allele** GenotypeSample::setAllAlleles(const bool Marked[])
{
SNPPos TotalSNPs=GetTotalSNPs();
if (allAlleles!=NULL)
{


for (int i=0; i<TotalSNPs; i++)
 zaparr(allAlleles[i]);
zaparr(allAlleles);
}
zaparr(totalAlleles);
//cout <<"Computing major alleles...\n";
int*Basis=NULL, ChosenPos, ChosenVal;
// Basis first positions is for missing allele, 1 - 4 positions are for A, G, C, T respectively
try
{
totalAlleles=new int[TotalSNPs];// for the total number of different alleles at each SNP, excluding missing 
allAlleles=new allele*[TotalSNPs]; // for the alleles ordered in decreasing frequencies except the missing allele, which goes at the end
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
Basis=CountAlleles(SNP, Marked);

totalAlleles[SNP]=0;
for (int c2=0;c2<5;c2++) // 0 is for missing values, 1: 4 for known nucleotides
 if (Basis[c2]>0) 
totalAlleles[SNP]++;    

if ((allAlleles[SNP]=new allele[totalAlleles[SNP]])==NULL)
      throw NoMemory();


for (int i=0; i<(totalAlleles[SNP]-(Basis[4]>0));i++)
{
allAlleles[SNP][i]=(allele)(GetMaxPos(&(Basis[0]),4)+1);// missing allele is not used
Basis[allAlleles[SNP][i]-1]=0;
}
if (Basis[4]>0) // if missing values
allAlleles[SNP][totalAlleles[SNP]-1]=(allele)5;
zaparr(Basis);
if (1==0)
{
for (int i=0; i<totalAlleles[SNP];i++)
{
cout <<" \nallele at pos " << i << " is: " << allAlleles[SNP][i];
}
cout <<"\ntotalalleles at snp " << SNP << ":  " << totalAlleles[SNP];
}
}
}
catch (NoMemory NM ) {NM.PrintMessage();}

} 
/*___________________________________________________________*/

void GenotypeSample::RemoveInconsistentIndividuals(SNPPos HomoPos, iterator IndGenotypeRef)
{
SNPPos Total=0, cont=0;
iterator IndGenotype=getFirst();
Genotype *G, *GRef;
Diplotype *D, *DRef;
allele majorAllele=allAlleles[HomoPos][0];
while (IndGenotype!=end())
{
 GRef=getElement(IndGenotype);
 G=getElement(IndGenotypeRef);
 D=G->getDiplotype(HomoPos);
 DRef=GRef->getDiplotype(HomoPos);
 if ((D->IsHomozygous1(majorAllele) && DRef->IsHomozygous2(majorAllele)) 
	 || (D->IsHomozygous2(majorAllele) && DRef->IsHomozygous1(majorAllele))) 
 removeNode(IndGenotype);
 IndGenotype=getNext(IndGenotype);
}
};
/*_______________________________________________________________*/

stringSample* GenotypeSample::genericExportation (FormatType alg, Transmission t, bool orderedByValue)
{
stringSample* l=new stringSample();
SNPPos TotalSNPs=GetTotalSNPs();

stringList* row;
string s;
//cout <<"Exporting to ML, file " << filename << "\n";
iterator IndGenotype=getFirst();
Genotype* g;
Diplotype *D;
while (IndGenotype!=end())
{
 row=new stringList();
 g=getElement(IndGenotype);	
 for (SNPPos i=0; i<TotalSNPs;i++)
  {
 D=g->getDiplotype(i);
 switch (alg)
{
case SNPHAP: // SNPHAP
s=ExportIndividualGenotypeForSNPHAP(*D);
break;
case HTYPER: // HTYPER
case PLEM: // PLEM
row->outputSeparator=0;
s=ExportIndividualGenotypeForHTYPERAndPLEM (*D, i);
break;
case ML: 
s=ExportIndividualGenotypeForML(*D, i, orderedByValue);
break;
case MLHAP: 
s=ExportIndividualGenotypeForMLHAP(*D, i, t);
break;
case HAP: // HAP
s=ExportIndividualGenotypeForHAP(*D);
break;
case IHAP: 
s=ExportIndividualGenotypeForIHAP(*D, i, t);
break;
}
  row->insertElement(s);
}
l->insertElement(row);
 IndGenotype=getNext(IndGenotype);
}
return l;
}

/*_______________________________________________________________*/

stringSample* GenotypeSample::ExportForPHASE (Positions* Pos)
{

stringSample* l=new stringSample();
SNPPos TotalSNPs=GetTotalSNPs();

//cout <<"Exporting to PHASE\n";

// row 1
stringList* row=new stringList();
string s;
s=tos(size());
row->insertElement(s);
l->insertElement(row);

// row 2
row=new stringList(' ');
s=tos(TotalSNPs);
row->insertElement(s);
l->insertElement(row);

// row 3
row=new stringList(' ');
s=string("P");
row->insertElement(s);
for (SNPPos i=0; i<TotalSNPs;i++)

{
  s=tos(Pos->getPosition(i));
  row->insertElement(s);
}
l->insertElement(row);

// row 4
row=new stringList(' ');
s=string("");
for (SNPPos i=0; i<TotalSNPs;i++)
 s=s+"S"; 

row->insertElement(s);
l->insertElement(row);

// next rows

iterator IndGenotype=getFirst();

Genotype* g;
Diplotype *D;
string s2;

IndPos Ind=0;

while (IndGenotype!=end())
{
 row=new stringList(' ');
 g=getElement(IndGenotype);
 s=string("#");
 s2=tos(Ind);	
 s=s+s2;
 row=new stringList(' ');
 row->insertElement(s);
 l->insertElement(row); 

 row=new stringList(' ');
 for (SNPPos i=0; i<TotalSNPs;i++)
 {
 D=g->getDiplotype(i);
 if (D->IsAMissingSNP())
  s=string("?");
  else s=tos(D->getLeftAllele());
  row->insertElement(s);
  }
 l->insertElement(row);

 row=new stringList(' '); 
 for (SNPPos i=0; i<TotalSNPs;i++)
 {
 D=g->getDiplotype(i);
 if (D->IsAMissingSNP()) s=string("?"); else  s=tos(D->getRightAllele());
 row->insertElement(s);
 }
  l->insertElement(row);
  IndGenotype=getNext(IndGenotype);
  Ind++;
}

return l;

}
/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForHTYPERAndPLEM (Diplotype &D, SNPPos i)
{
  if (D.IsAMissingSNP()) return string("3");
  if (D.IsHeterozygous (allAlleles[i][0])) return string("0");
  if (D.IsHomozygous1 (allAlleles[i][0]))  return string("1");
  if (D.IsHomozygous1 (allAlleles[i][1]))  return string("2");
}

/*____________________________________________________________ */

stringSample* GenotypeSample::ExportForHTYPERAndPLEM (FormatType alg)
{
return genericExportation(alg);
}
/*____________________________________________________________ */

stringSample* GenotypeSample::ExportForML (bool orderedByValue)
{
return genericExportation(ML, ut, orderedByValue);
}
/*____________________________________________________________ */

stringSample* GenotypeSample::ExportForMLHAP (Transmission t)
{
return genericExportation(MLHAP, t);
}
/*____________________________________________________________ */

GenotypeSample* GenotypeSample::clone ()
{
return new GenotypeSample((GenotypeSample&)*this);
}
/*____________________________________________________________ */

GenotypeSample* GenotypeSample::emptyCopy ()
{
return new GenotypeSample();
}
/*____________________________________________________________ */

stringSample* GenotypeSample::ExportForIHAP ()
{
stringSample* result, *result2, *result3=new stringSample();
result=genericExportation(IHAP, t);
result2=genericExportation(IHAP, u);
int i=0;
stringList* hap;
for (stringSample::iterator it = result->begin(); it!=result->end(); it++)
{
//hap=new stringList(*result->getElement(it));
result3->insertElement(result->getElement(it));
//hap=new stringList(*result2->getElement(i));
result3->insertElement(result2->getElement(i));
i++;
}
//zap(result);
//zap(result2);
return result3;
}
/*____________________________________________________________ */

stringSample* GenotypeSample::ExportForSNPHAPAndHAP (FormatType alg)
{
stringSample* l=genericExportation(alg); 
string s;
int i=1;

for (stringSample::iterator it = l->getFirst();
     it != l->getLast(); it++) 
{
 s=tos(i); 
 l->getElement(it)->insertElementAtPos(s, 0);
 i++;
}
return l;
}

/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForML (Diplotype &D, SNPPos i, bool orderedByValue)
{
//ordered by value means to consider de major allele to the one with the lowest number
char value;
string s;
char* alli;
 if (D.IsHeterozygous (allAlleles[i][0])) value='0';
  if (D.IsAMissingSNP()) value= '?';
  if (D.IsHomozygous1 (allAlleles[i][0]))
  if (orderedByValue) value=(allAlleles[i][0]<allAlleles[i][1])? '1' : '2';
  else 
  {
   value=tos(allAlleles[i][0])[0];
}
  if (D.IsHomozygous2 (allAlleles[i][0]))
  if (orderedByValue) value=(allAlleles[i][0]<allAlleles[i][1])? '2' : '1';
  else 
  { 
  value=tos(allAlleles[i][0])[0];
  }
  s=tos(value);
  return s;
}

/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForIHAP (Diplotype &D, SNPPos i, Transmission trans)
{
 string s;
 if (trans==t) s=tos(((int)(D.getLeftAllele())-1));
 if (trans==u) s=tos(((int)(D.getRightAllele())-1));
if (trans==ut)
{
throw BadFormat("GenotypeSample::ExportIndividualGenotypeForIHAP");
exit(0);
}
 return s;
};

/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForMLHAP (Diplotype &D, SNPPos i, Transmission trans)
{
 string s=string("");
 if (trans==ut || trans==t) s=s+tos((int)D.getLeftAllele());
 if (trans==ut || trans==u) s=s+tos((int)D.getRightAllele());
 return s;
};

/*____________________________________________________________ */

stringSample* GenotypeSample::ExportMetaForML ()
{
stringSample* l=new stringSample();
stringList* row;
string s;
SNPPos TotalSNPs=GetTotalSNPs();
for (SNPPos i=0;i<TotalSNPs;i++) 
{
row=new stringList(' ');
s=string("0 SNP");
row->insertElement(s);
s=tos(i);
s=s+string(": 0, 1, 2 //");
row->insertElement(s);
l->insertElement(row);
}
return l;
}
/*____________________________________________________________ */

stringSample* GenotypeSample::ExportMetaForMLHAP ()
{

SNPPos TotalSNPs=GetTotalSNPs();
stringSample* l=new stringSample();
stringList* row;
string s;
for (SNPPos i=0;i<TotalSNPs;i++) 
{
row=new stringList(' ');
s=string("0 SNP");
row->insertElement(s);
s=tos(i);
s=s+string(": 12, 21, 11, 22 //");
row->insertElement(s);
l->insertElement(row);
}
return l;
}


/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForSNPHAP (Diplotype &D) //ExportForSNPHAP (char *filename)
{
 string s, s2;
 if (D.IsAMissingSNP()) s=string("? ?");
 else 
 {
s=string(UnconvertAllele(D.getLeftAllele()));
s2=string(UnconvertAllele(D.getRightAllele()));
}
s=s+" "+s2; 
return s; 
}
/*____________________________________________________________ */

string GenotypeSample::ExportIndividualGenotypeForHAP (Diplotype &D) //ExportForSNPHAP (char *filename)
{
 string s, s2;
 if (D.IsAMissingSNP()) s=string("S S");
 else 
 {
s= string(UnconvertAllele(D.getLeftAllele()));
s2= string(UnconvertAllele(D.getRightAllele()));
}
s=s+" "+s2; 
return s; 
}

/*____________________________________________________________ */

void GenotypeSample::SNPSampling (Container<set<SNPPos>, SNPPos> *Sampling)
{

    Genotype *genotype, *genotype2;
	iterator p=getFirst(), pOld, pNext;
	while (p!=end())
	{
         genotype=getElement(p);
	 genotype2=new Genotype(*genotype, Sampling);
	 pOld=p;
	 p=getNext(p);
	 removeNode(pOld);
         pNext=p;
	 insertElementAtPointer(genotype2, p);
	 p=pNext;

	}

}

/*________________________________________________________________________________________________*/
/*
void GenotypeSample::ImportFormat (char *filename)
{
if (size()>0)
{
cout <<"Importing must be done when there is not any individuals in this object";
exit(0);
}
AlleleOrderMode=NotChanged;
ExistPhenotype=false;
SNPPos TotalSNPs, TotalSNPsOld, i=0;
SNPPos size=GetLineLength(filename)+1;


InputFile.open (filename, ifstream::in);
if (!InputFile || InputFile.peek()==EOF)
	throw ErrorFile();


    char *genotypebuf=NULL, *cad;
    if ((genotypebuf=new char[size])==NULL)
     throw NoMemory();
 
Genotype* targetGenotype=NULL; 
while (InputFile.peek()!=EOF)
{
InputFile.getline (genotypebuf, size, '\n');
TotalSNPs=strlen(genotypebuf);

if (i>0 && TotalSNPs!=TotalSNPsOld)
{
cout <<"\nError in input file. The individual " << i <<" has " << TotalSNPs+1 <<" SNPs, while the others before had " << TotalSNPsOld+1 << " SNPs.";
exit(0);
}
Diplotype* diplotype;
targetGenotype= new Genotype(TotalSNPs);
for (int d=0;d<TotalSNPs;d++)
{
 switch (genotypebuf[d])
 {
 case '0': diplotype= new Diplotype((allele)1,(allele)2); break;
 case '1': diplotype= new Diplotype((allele)1,(allele)1); break;
 case '2': diplotype= new Diplotype((allele)2,(allele)2); break;
 case '3': diplotype= new Diplotype((allele)0,(allele)0); break;
 case '4': diplotype= new Diplotype((allele)1,(allele)0); break;
 case '5': diplotype= new Diplotype((allele)2,(allele)0); break;
default: cout <<"\nError, value " << genotypebuf[d] << " is not allowed."; exit(0); break;
 }

targetGenotype->SetDiplotype(diplotype, d);
zap(diplotype);
};
insertElement(targetGenotype);

i++;
TotalSNPsOld=TotalSNPs;
}
InputFile.close();
zaparr(genotypebuf);



}


/*________________________________________________________________________________________________*/


ostream& operator<<(ostream& out, GenotypeSample& genotypeSample)
       {
       GenotypeSample::iterator IndGenotype=genotypeSample.getFirst();
  Genotype *genotype;
 
  //SNPPos TotalSNPs=genotypeSample.GetTotalSNPs();

while (IndGenotype!=genotypeSample.end())
  {
   genotype=genotypeSample.getElement(IndGenotype);
   out << *genotype;     
   IndGenotype=genotypeSample.getNext(IndGenotype);
  }
  return out;
  }


}
// End of Namespace

#endif

/* End of file: GenotypeSample.h */




