/* File: GenotypeSample.h */


#ifndef __GenotypeSample_h__
#define __GenotypeSample_h__




//using namespace UTILS;

namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class GenotypeSample: public Container<vector<Genotype*>, Genotype*>  {


	protected:
    /** @name Implementation of class GenotypeSample
        @memo Private part.
    */


      /**
      @memo Declaration of type gender
      @doc It can have one of {1,2} values. 1 for male, 2 for female.
      */

	  
   /** @name Number of individuals (sample size)
        @doc Is the total number of individuals in the sample.
    */
   


	public:

	 AlleleOrderType AlleleOrderMode;




// allele * MajorAllele, *MinorAllele;

 allele** allAlleles;
 int* totalAlleles;


/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */
      /**
         @memo Destroy the vector of SNP genotypes for an individual
	 @doc
           release memory for this vector.

      */

	//Genotype*  readElement (ifstream * source, char* tokens=NULL);

	
//		void  ReadGenotype (vector<Diplotype::DiplotypeS>* DiplotypeList, char* line, SNPPos size);


				   /**
         @memo Compute the more frequent allele for each SNP.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
		 @ return: pointer to a table of TotalSNPs alleles with the more frequent value
*/


/**
         @memo Compute the less frequent allele for each SNP.
         @param ic: 0: if phase has to be resolved only for parents, 1: only for children, 2 for everybody
		 @ return: pointer to a table of TotalSNPs alleles with the less frequent value
*/

		void SetAlleleType (bool IsMajor);


	protected:


		



//	Diplotype ReadDiplotype (vector<Diplotype>* ld, ifstream * source, bool ExistPhenotypes);

	 Genotype* readElement (ifstream * source, const char* tokens, int* pos=NULL, int size=0);

		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

      /** @name Operations on GenotypeSample 
        @memo Operations on a GenotypeSample 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
		  

		  GenotypeSample(char * filename, int*pos=NULL, int size=0, AlleleOrderType AlleleOrderMode=MajorFirst);

    		static Container<vector<Diplotype*>, Diplotype*>* readDiplotype (const char* source, int len);

		        /**
         @memo Copy constructor
         @param destino: GenotypeSample where will be copy
         @param origen: GenotypeSample to copy
         @doc
           Make a copy of GenotypeSample
           Time complexity in time O(1).
        */
	
		//  GenotypeSample (GenotypeSample& Source, SNPPos TotalSNPs, unsigned int *Sampling);


		  GenotypeSample (GenotypeSample& source, Container<set<SNPPos>, SNPPos> *Sampling=NULL);

		  GenotypeSample();

		  ~GenotypeSample ();

		 

        //       GenotypeSample (Container<vector, Genotype*>& source, bool e, AlleleOrderType a);

void insertGenotype (stringList* row,  bool  ExistPhen=true);

void readSample(char* filename,  bool  ExistPhen=true);

		  void SNPSampling (Container<set<SNPPos>,SNPPos> *Sampling);

      /**
         @memo Is equal
         @param g: GenotypeSample to compare with.
	 @return
           Return true if all the GenotypeSample is the same, false otherwise.
         @doc Time complexity O(1).

      */

	  GenotypeSample& operator=(const GenotypeSample & Source);

      bool operator==(const GenotypeSample & g);
      /**
         @memo Is different
         @param g, position: GenotypeSample to compare with.
	 @return
           Return true if the SNP is different, false otherwise.
         @doc Time complexity O(1).

      */
      bool operator!=(const GenotypeSample & g);

		
	  SNPPos GetTotalSNPs();
   
	  SNPPos GetTotalAllele (SNPPos SNP, allele allele1, const bool Marked[]);
/*
	  double GetHap(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[]=NULL); 

	  double GetnAB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]);

	  double GetnAb(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]);
	  
	  double GetnaB(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]);
	  
	  double Getnab(SNPPos SNP1, SNPPos SNP2, Transmission transmission, const bool Marked[]);
*/

   allele getMajorAllele(SNPPos SNP, const bool Marked[]);
       
	  allele getMinorAllele(SNPPos SNP, const bool Marked[]);

	  SNPPos getTotalType (SNPPos SNP, int type, const bool Marked[]);

	  SNPPos GetTotalHomozygous1 (SNPPos SNP, const bool Marked[]);

	  SNPPos GetTotalHomozygous2 (SNPPos SNP, const bool Marked[]);

	  SNPPos GetTotalHeterozygous (SNPPos SNP, const bool Marked[]);

	  SNPPos getTotalMissing (SNPPos SNP, const bool Marked[]);

  SNPPos getTotalMarked( const bool Marked[]=NULL);

   IndPos getTotalMissingGenotypes (const bool Marked[]);

	  SNPPos getTotalNonMissing (SNPPos SNP, const bool Marked[]);
	  
	//  SNPPos getDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, const bool Marked[]=NULL);

//	  SNPPos getPairwiseGenotype (PairedGenotype, SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);

  //    SNPPos GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, AlleleOrderType alleleOrderType, const bool Marked[]);

        SNPPos* getAlleleFrequencies(allele alleleType, const bool Marked[]=NULL);

	//intList* getIndList(SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, const bool Marked[]=NULL); 

SNPPos getHeterozygousHomozygous1 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
SNPPos getHomozygous1Heterozygous (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
SNPPos getHomozygous2Homozygous2 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
SNPPos getHomozygous2Homozygous1 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
SNPPos getHomozygous1Homozygous2 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
SNPPos getHomozygous1Homozygous1 (SNPPos FirstSNP, SNPPos LastSNP, const bool Marked[]=NULL);
map<long int, int>* countHaps(const SNPPos *pos, int totalPos, allele** allAlleles, const bool Marked[]=NULL, Transmission transmission=ut, AlleleOrderType alleleOrderMode=MajorFirst);
MultidimensionalTable<double>* countGenotypes(const SNPPos *pos, int totalPos, allele** allAlleles, const bool Marked[]=NULL);
	  /**
         @memo Obtain the number of SNPs.
         @return the number of SNPs
         @doc Return the number of SNPs. This value
         is in the variable TotalSNPs.
         Time complexity O(1)

      */
		void OrderSNPs (Container<vector<SNPPos>, SNPPos> *Sampling);

		void OrderMajorFirst ();

		void OrderRandomly ();

		int* CountAlleles (SNPPos SNP, const bool Marked[]);

		void PrintHaplotypes (char* filename);

		void PrintGenotypes (char* filename);


	//	void SetMajorAllele(const bool Marked[]);

		allele* SetAllele(bool , const bool Marked[]);

		void SetMinorAllele(const bool Marked[]);

allele** setAllAlleles(const bool Marked[]=NULL);

		void RemoveInconsistentIndividuals(SNPPos HomoPos, iterator IndGenotypeRef);

		stringSample* ExportForHTYPERAndPLEM (FormatType alg);
		
                stringSample* ExportForML (bool);
      
		stringSample* ExportForMLHAP (Transmission t);

		stringSample* ExportForIHAP ();

		stringSample* ExportMetaForML ();

		stringSample* ExportMetaForMLHAP ();
                
		stringSample* ExportForSNPHAPAndHAP (FormatType alg);
	
		stringSample* ExportForPHASE (Positions* Pos);

		string ExportIndividualGenotypeForHTYPERAndPLEM (Diplotype &D, SNPPos i);

		string ExportIndividualGenotypeForML (Diplotype &D, SNPPos i, bool orderedValue);

		string ExportIndividualGenotypeForMLHAP (Diplotype &D, SNPPos i, Transmission t);

		string ExportIndividualGenotypeForIHAP (Diplotype &D, SNPPos i, Transmission t);

		string ExportIndividualGenotypeForSNPHAP (Diplotype &D);

		string ExportIndividualGenotypeForHAP (Diplotype &D);

		stringSample* genericExportation (FormatType alg, Transmission t=ut, bool orderedByValue=false);

//		SNPPos GetLongPhasedHap(SNPPos* Hap, const SNPPos Pos[], SNPPos TotalPos, allele * MajorAllele, const bool Marked[]=NULL, Transmission transmission=ut); 

		void ImportFormat (char *filename);

  int* countAlleles(const SNPPos *pos, int totalPos, const bool Marked[]); 

		GenotypeSample* clone();

		GenotypeSample* emptyCopy();

GenotypeSample* setTransmissionRandomly(SNPPos firstSNP=0, SNPPos nextLastSNP=0);

//void empty();
     //     GenotypeSample* copyElementsWithPositionsIn(intList* positions, bool inThis=true);


};  // End of class GenotypeSample

typedef GenotypeSample::iterator GenotypePointer;

ostream& operator<<(ostream& out, GenotypeSample& genotypeSample);

}
// End of Namespace

#endif

/* End of file: GenotypeSample.h */




