
/*______________________________________________________________________________*/


using namespace BIOS;


const char* getAlgorithmName(int measure)
{
switch (measure)
{
case 0: return "lc"; break;
case 1: return "sr"; break;
case 2: return "var"; break;
case 3: return "LD"; break;
//case 3: return "total hap LD"; break;
//case 4: return "hap square probs"; break;
/*case 5: return "hap entropy test"; break;
case 6: return "multimarker Dprime (weights: hap probs, no df)"; break;
case 7: return "multimarker Dprime (weights: hap probs, df)"; break;
case 8: return "multimarker Dprime (weights: SNP probs, no df)"; break;
case 9: return "multimarker Dprime (weights: SNP probs, df)"; break;
case 10: return "multimarker Dprime (weights: hap log probs, no df)"; break;
case 11: return "multimarker Dprime (weights: hap log probs, df)"; break;
*/
case 4: return "aVar"; break;
case 5: return "aLD"; break;
case 6: return "iVar"; break;
case 7: return "iLD"; break;
case 8: return "TDT"; break;
case 9: return "entTDT"; break;
case 10: return "propTDT"; break;
case 11: return "propEntTDT"; break;
case 12: return "absVarTDT"; break;
case 13: return "squareVarTDT"; break;
//case 14: return "absSNPVarTDT"; break;
case 15: return "squareSNPVarTDT"; break;
//case 16: return "squareCorrectedSNPVarTDT"; break;
case 17: return "stTDT"; break;
case 18: return "suTDT"; break;
case 19: return "Yate"; break;
case 20: return "Yate1"; break;
case 21: return "YateProp"; break;
case 22: return "YateProp1"; break;
case 23: return "Laplace1"; break;
case 24: return "Laplace2"; break;
case 25: return "Grouping"; break;
case 26: return "singleTDT"; break;
case 27: return "exactTDT"; break;
case 28: return "exactPropTDT"; break;
case 29: return "logTDT"; break;
case 30: return "TDT10M"; break;
case 31: return "WTDT"; break;
case 32: return "WWTDT"; break;
case 33: return "exactEntTDT"; break;
case 14: return "stEntropyTDT"; break;
case 34: return "exactstEntropyTDT"; break;
case 16: return "suEntropyTDT"; break;
case 35: return "exactsuEntropyTDT"; break;
}
}
/*_______________________________________________________________________*/

const char* getAlgorithmShortname(int measure)
{
switch (measure)
{
case 0: return "StandardizedLengthContrastTest"; break;
case 1: return "WilcoxonSignedRankTest"; break;
case 2: return "TDTVariance"; break;
case 3: return "TDTLD"; break;
//case 3: return "TotalHapLD"; break;
//case 4: return "HapSquareProbs"; break;
//case 4: return "HapEntropyTest"; break;
/*case 6: return "MultimarkerDprimeHapProbsNoDf"; break;
case 7: return "MultimarkerDprimeHapProbsDf"; break;
case 8: return "MultimarkerDprimeSNPProbsNoDf"; break;
case 9: return "MultimarkerDprimeSNPProbsDf"; break;
case 10: return "MultimarkerDprimeHapLogProbsNoDf"; break;
case 11: return "MultimarkerDprimeHapLogProbsDf"; break;
*/
case 4: return "TDTAbsVariance"; break;
case 5: return "TDTAbsLD"; break; 
case 6: return "TDTInvVariance"; break;
case 7: return "TDTInvLD"; break; 
case 8: return "TDT"; break;
case 9: return "EntropyTDT"; break;
case 10: return "propTDT"; break;
case 11: return "propEntropyTDT"; break;
case 12: return "absVarTDT"; break;
case 13: return "squareVarTDT"; break;
//case 14: return "absSNPVarTDT"; break;
case 15: return "squareSNPVarTDT"; break;
//case 16: return "squareCorrectedSNPVarTDT"; break;
case 17: return "stTDT"; break;
case 18: return "suTDT"; break;
case 19: return "Yate"; break;
case 20: return "Yate1"; break;
case 21: return "YateProp"; break;
case 22: return "YateProp1"; break;
case 23: return "Laplace1"; break;
case 24: return "Laplace2"; break;
case 25: return "Grouping"; break;
case 26: return "singleTDT"; break;
case 27: return "exactTDT"; break;
case 28: return "exactPropTDT"; break;
case 29: return "logTDT"; break;
case 30: return "TDT10M"; break;
case 31: return "WTDT"; break;
case 32: return "WWTDT"; break;
case 33: return "exactEntTDT"; break;
case 14: return "stEntropyTDT"; break;
case 34: return "exactstEntropyTDT"; break;
case 16: return "suEntropyTDT"; break;
case 35: return "exactsuEntropyTDT"; break;
}
}

/*__________________________________________________________________________*/

double getAlpha(double original, int measure)
{
switch (measure)
{
case 0: // "standardized length contrast test"; break;
case 1: // "Wilcoxon signed rank test"; break;
case 2: // "mean of hap square probs"; break;
case 3: // "total hap LD"; break;
case 4: // "hap square probs"; break;
case 5: // "hap entropy test"; break;
case 6: // "multimarker Dprime (weights: hap probs, no df)"; break;
case 7: // "multimarker Dprime (weights: hap probs, df)"; break;
case 8: // "multimarker Dprime (weights: SNP probs, no df)"; break;
case 9: // "multimarker Dprime (weights: SNP probs, df)"; break;
case 10: // "multimarker Dprime (weights: hap log probs, no df)"; break;
case 11: // "multimarker Dprime (weights: hap log probs, df)"; break;
return original;
break;
case 12: // "TDT"; break;
case 13: // "entropy TDT"; break;
case 14: // prop entropy TDT
case 15: // prop TDT
case 16: // prop X2 TDT
case 17:
case 18:
case 19:
case 20:
case 21:
case 22:
case 23:
case 24:
case 25:
case 26:
case 27:
case 28:
case 29:
case 30:
case 31:
case 32:
case 33:
case 34:
case 35:
return original;//+(100-original)/2;
break;
}
}
/*__________________________________________________________________________*/


double* getMeasureValues(TrioCountersHapUAndT* TM, int totalMeasures, bool maxHap=true, intList* ignoreMeasures=NULL)
{
double* measures=new double[totalMeasures];
//return measures;
//cout <<"haps:\n" << *TM->haplotypeCounts;
double var=-1;//=TM->getSquareSB(0); 
double LD=-1;//=TM->getSquareSB(3);

for (int i=0; i<totalMeasures; i++)
{

if (ignoreMeasures!=NULL && ignoreMeasures->findElement(i)!=ignoreMeasures->end()) 
measures[i]=-1;
else
switch (i)
{
case 0:measures[i]=TM->getStandardizedSimilarityMeasure();break;
case 1:measures[i]=TM->getSignedRankTest();break;
case 2:var=TM->getSquareSB(0); measures[i]=var;break;
case 3:LD=TM->getSquareSB(3); measures[i]=LD;break;
case 4:if(var==-1) var=TM->getSquareSB(0);measures[i]=fabs(var);break;
case 5:LD=TM->getSquareSB(3); measures[i]=fabs(LD);break;
case 6:if(var==-1) var=TM->getSquareSB(0); measures[i]=-var;break;
case 7:if (LD==-1) LD=TM->getSquareSB(3); measures[i]=-LD;break;
case 8: case 27: case 30: measures[i]=TM->getTDT();break;
case 9: case 33: measures[i]=TM->getEntropyTDT(); break;
case 10:case 28:measures[i]=TM->getNTDT(); break;
case 11:measures[i]=TM->getNEntropyTDT(); break;
case 12:measures[i]=TM->getAbsVarTDT();break;
case 13:measures[i]=TM->getSquareVarTDT();break;
//case 14:measures[i]=TM->getSNPAbsVarTDT();break;
case 15:measures[i]=TM->getSNPSquareVarTDT();break;
//case 16:measures[i]=TM->getSNPSquareCorrectedVarTDT();break;
case 17:measures[i]=TM->getSimpleTDT(parent, -1, t);break;
case 18:measures[i]=TM->getSimpleTDT(parent, -1, u);break;
case 19: measures[i]=TM->getYateTDT(1,1); break;
case 20: measures[i]=TM->getYateTDT(2,1); break;
case 21: measures[i]=TM->getYateTDT(1,0); break;
case 22: measures[i]=TM->getYateTDT(2,0); break;
case 23: measures[i]=TM->getLaplaceTDT(1); break;
case 24: measures[i]=TM->getLaplaceTDT(2); break;
case 25: measures[i]=TM->getGrouping(); break;
case 26: measures[i]=TM->getSimpleTDT(parent, -1); break;
case 29: measures[i]=TM->getLogTDT(parent); break;
case 31: measures[i]=TM->getWTDT(parent); break;
case 32: measures[i]=TM->getWWTDT(parent); break;
case 14: case 34: measures[i]=TM->getSimpleEntropyTDT(parent, -1, t);break;
case 16: case 35: measures[i]=TM->getSimpleEntropyTDT(parent, -1, u);break;
default: break;
}
//if (i>=2 && i<=5)
//if (i==3)
//cout <<"\nmeasure number " << i <<", val is :"  << measures[i] <<"\n";
}
//cout <<"\ninsidehapsq is " << measures[2];

return measures;
}





