/* File: MultiallelicPairwiseMeasure.cpp */


#ifndef __MultiallelicPairwiseMeasure_cpp__
#define __MultiallelicPairwiseMeasure_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*_________________________________________________________________*/

MultiallelicPairwiseMeasure::MultiallelicPairwiseMeasure(BidimensionalTable<double> * multiallelicFreqs)
{
this->multiallelicFreqs=multiallelicFreqs;
totalAllelesSNP1=multiallelicFreqs->getXDim();
totalAllelesSNP2=multiallelicFreqs->getYDim();

SNP1Freqs=Initialize(totalAllelesSNP1, (double)0);
SNP2Freqs=Initialize(totalAllelesSNP2, (double)0);

for (int i=0; i<totalAllelesSNP1; i++)
for (int j=0; j<totalAllelesSNP2; j++)
{
 SNP1Freqs[i]=SNP1Freqs[i]+multiallelicFreqs->getValue(i, j);
 SNP2Freqs[j]=SNP2Freqs[j]+multiallelicFreqs->getValue(i, j);
}



}

/*_________________________________________________________________*/

double MultiallelicPairwiseMeasure::getFreq (int pos1, int pos2)
{
return multiallelicFreqs->getValue(pos1, pos2);
}

/*_________________________________________________________________*/

double MultiallelicPairwiseMeasure::getSNPFreq (bool first, int pos)
{
if (first) return SNP1Freqs[pos];
else return SNP2Freqs[pos];
}
/*_________________________________________________________________*/

double MultiallelicPairwiseMeasure::getSNP1Freq (int pos)
{
return getSNPFreq(true, pos);
}
/*_________________________________________________________________*/

double MultiallelicPairwiseMeasure::getSNP2Freq (int pos)
{
return getSNPFreq(false, pos);
}
/*_________________________________________________________________*/

double MultiallelicPairwiseMeasure::getDPrime(int measure, bool df)
{
// measure can be:
//0: unweighted
//1: weighted by allele freqs
//2: weighted by hapfreqs 
//3: weighted by entropy
// if df, degrees of freedom are taken into account
try
{
double DPrime=0, partD, weight=1;

Table2x2 T2x2;
int cont=0;
for (int i=0; i<totalAllelesSNP1-df; i++)
 for (int j=0; j<totalAllelesSNP2-df; j++)
//if (SNP1Freqs[i]>0 && SNP1Freqs[i]<1 && SNP2Freqs[j]>0 && SNP2Freqs[j]<1)
{
if (multiallelicFreqs->getValue(i, j)>(1+zero) || multiallelicFreqs->getValue(i, j)<0)
{
cout <<"\nmultifreqs is: " << *multiallelicFreqs;
throw NonProb("MultiallelicPairwiseMeasure<T>::getDPrime", multiallelicFreqs->getValue(i, j));
}
partD=T2x2.GetDPrime(multiallelicFreqs->getValue(i, j), SNP1Freqs[i], SNP2Freqs[j]);
switch (measure)
{
case 1: weight=SNP1Freqs[i]*SNP2Freqs[j]; break;
case 2: weight=multiallelicFreqs->getValue(i, j); break;
case 3: if (multiallelicFreqs->getValue(i, j)==0) weight=0; else weight=log(multiallelicFreqs->getValue(i, j)); break;
default: break; 
}
  DPrime=DPrime+weight*partD;
cont++;
}
return DPrime;
}
catch (NonProb np){np.PrintMessage();};
}




};  // End of Namespace

#endif

/* End of file: MultiallelicPairwiseMeasure.h */




