/* File: MultiallelicPairwiseMeasure.h */


#ifndef __MultiallelicPairwiseMeasure_h__
#define __MultiallelicPairwiseMeasure_h__





//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultiallelicPairwiseMeasure DEFINITION */
/************************/


/**
        @memo MultiallelicPairwiseMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class MultiallelicPairwiseMeasure {


protected:

    /** @name Implementation of class MultiallelicPairwiseMeasure
        @memo Private part.
    */

	
   BidimensionalTable<double> *multiallelicFreqs;

 double *SNP1Freqs, *SNP2Freqs;

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

 //   double GetnxyKnown(bool IsMajor1, bool IsMajor2);




		/* PUBLIC FUNCTIONS (INTERFACE) */

    public:

 int totalAllelesSNP1, totalAllelesSNP2; //, totalKnown, totalHaplotypes;


  MultiallelicPairwiseMeasure(BidimensionalTable<double> * multiallelicFreqs);


	~MultiallelicPairwiseMeasure()
	{
zaparr(SNP1Freqs);
zaparr(SNP2Freqs);
};



 double getCompositeLD();

 double getStandardizedCompositeLD();
 
double getFreq(int pos1, int pos2);

	double getD();

double getSNPFreq (bool first, int pos);

double getSNP1Freq (int pos);

double getSNP2Freq (int pos);

double getDPrime(int measure=2, bool df=0);

//static BidimensionalTable<double> *  setf (int totalAllelesSNP1, int totalAllelesSNP2, double* SNP1Freqs, double* SNP2Freqs, HeteroPair<longLongList*, doubleList*>* genotypeCounts, double totalGenotypes);

//CPT* getCPT(bool disease0-sex1);

};  // End of class MultiallelicPairwiseMeasure

ostream& operator<<(ostream& out, MultiallelicPairwiseMeasure& pm)
       {
   
 //out << pm.GetnA() <<", " << pm.GetnB()  <<", " << pm.GetTotalKnown() <<", " << pm.GetTotalUnKnown()  <<", " << pm.GetnAB() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: MultiallelicPairwiseMeasure.h */




