/* File: MultimarkerMeasure.h */

#ifndef __MultimarkerMeasureHapUAndT_h__
#define __MultimarkerMeasureHapUAndT_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotypes for father and mothers must be independently estimated

       With this purpose, the data structures required is:
 
       HeteroListPair<ParentalHaplotypes, double> *parentalHapFreqs  

        @author Maria M. Abad
	@version 1.0
*/




 
class	MultimarkerMeasureHapUAndT {



//MultimarkerMeasureHap<TrioSample> *multimarkerMeasureTransmitted, *multimarkerMeasureUntransmitted;

public:

bool tdt;

TrioCounters* trioCounters;

//	   double** SNPAbsFreqs;

//   double** SNPFreqs;


HeteroListPair<ParentalHaplotypes, double>* haplotypeFreqs;


double totalHaplotypes, totalDifferentHaplotypes;

MultidimensionalEmptyTable<int>* haplotypeTable;


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:



	MultimarkerMeasureHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0);
	
 MultimarkerMeasureHapUAndT(MultimarkerMeasureHapUAndT& source);
 
MultimarkerMeasureHapUAndT(TrioCounters* source);

 MultimarkerMeasureHapUAndT();

 void set(MultimarkerMeasureHapUAndT& source);

 ~MultimarkerMeasureHapUAndT()
{
empty();
	};

void normalizeFreqs(double total);

 virtual void empty ();

virtual void setHaplotypeFreqs()=0;

void setTotalDifferentHaplotypes();

BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);


 MultimarkerMeasureHapUAndT* clone();

 double getLengthMeasure (int*pos1T, int* pos2T, int* pos1U, int* pos2U); 

 void setHaplotypeTable();

 double getStandardizedSimilarityMeasure (IndCategory ic=parent);

 double getSignedRankTest(bool wilcoxon=true, IndCategory ic=parent);

 double getSimilarityMeasure (IndCategory ic=parent);


//double getTest (int testType, IndCategory ic=parent){throw BadFormat("getTest");};

virtual MultimarkerMeasureHapUAndT* getPermutation(){throw NonImplemented("getPermutation");};

double getSquareSB (bool df);

double getSquareSB (int df, Transmission trans);

double getEntropySB (bool df);

double getEntropySB (int df, Transmission trans);

double getLinearSB (Transmission trans);

double getEntropySE(int df);

double getEntropyBasedLD (int df, Transmission trans);

double getMultimarkerDPrime (int type, bool df);

double getMultimarkerDPrime (int measure, int df, Transmission trans);

static double getDPrime(BidimensionalTable<double> * multiallelicFreqs, int measure, int df);

double getTDT (IndCategory ic=parent);

double getSignedTDT (IndCategory ic=parent);

double getEntropyTDT (IndCategory ic=parent);

double getGenericTDT (int test, IndCategory ic=parent);

double getEntropySignedTDT (IndCategory ic=parent);

double getSquareHapProbs (int df, Transmission trans);



//HeteroListPair<long long int, double>* getComposedList(longLongList *fatherHaps, longLongList* motherHaps);

//double getSignedTDT ();

//MultimarkerMeasureHapUAndT * getPermutation ();

};  // End of class MultimarkerMeasure

ostream& operator<<(ostream& out, struct ParentalHaplotypes& pm)
       {
   out << "[" << pm.fatherU <<"-" << pm.fatherU << "] [" << pm.motherT <<"-" << pm.motherU <<"]\n";

return out;
};


ostream& operator<<(ostream& out, MultimarkerMeasureHapUAndT& pm)
       {
if (pm.trioCounters!=NULL)
   out << *pm.trioCounters <<"\n";

if (pm.haplotypeFreqs!=NULL)
   out << *pm.haplotypeFreqs << "\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




