/* File: MultimarkerMeasure.h */


#ifndef __MultimarkerMeasureHapUAndTKnownHaps_cpp__
#define __MultimarkerMeasureHapUAndTKnownHaps_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

MultimarkerMeasureHapUAndTKnownHaps* MultimarkerMeasureHapUAndTKnownHaps::clone()
{
return new MultimarkerMeasureHapUAndTKnownHaps(*this);
} 


/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps::MultimarkerMeasureHapUAndTKnownHaps(MultimarkerMeasureHapUAndTKnownHaps& source):MultimarkerMeasureHapUAndT((MultimarkerMeasureHapUAndT&) source)
{
/*
fatherCountsT=NULL;
motherCountsT=NULL;
fatherCountsU=NULL;
motherCountsU=NULL;
if (source.fatherCountsT!=NULL) fatherCountsT=new longLongList(*source.fatherCountsT);
if (source.motherCountsT!=NULL) motherCountsT=new longLongList(*source.motherCountsT);
if (source.fatherCountsU!=NULL) fatherCountsU=new longLongList(*source.fatherCountsU);
if (source.motherCountsU!=NULL) motherCountsU=new longLongList(*source.motherCountsU);
*/
}

/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps::MultimarkerMeasureHapUAndTKnownHaps(MultimarkerMeasureHapUAndT& source):MultimarkerMeasureHapUAndT(source)
{
set();
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps::MultimarkerMeasureHapUAndTKnownHaps(TrioCounters* source):MultimarkerMeasureHapUAndT(source)
{
//cout << "counts father:" << *multimarkerMeasure->genotypeCountsFather;
set();
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps::MultimarkerMeasureHapUAndTKnownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender, int affectation, BayesType  Bay, float alphaBayes, float distance):MultimarkerMeasureHapUAndT(Pos,  totalPos, samp,  gender, affectation, Bay, alphaBayes, distance)
{
set();
}
/*_________________________________________________________________*/

void MultimarkerMeasureHapUAndTKnownHaps::set()
{
longLongList* fatherCountsT=getHaplotypeCountsFromGenotypes(father, t);
longLongList* fatherCountsU=getHaplotypeCountsFromGenotypes(father, u);
longLongList* motherCountsT=getHaplotypeCountsFromGenotypes(mother, t);
longLongList* motherCountsU=getHaplotypeCountsFromGenotypes(mother, u);

if (fatherCountsT->size()!=motherCountsT->size() || fatherCountsU->size()!=motherCountsU->size() || fatherCountsT->size()!=fatherCountsU->size())
{
cout <<"Error 2 in MultimarkerMeasureHapUAndTKnownHaps()\n";
cout << "\nfather counts t is: " << fatherCountsT->size() << ", mother counts t is " << motherCountsT->size();
cout << "\nfather counts u is: " << fatherCountsU->size() << ", mother counts u is " << motherCountsU->size();
exit(0);
}
setHaplotypeFreqs();
empty();
}

/*_________________________________________________________________*/


long long int MultimarkerMeasureHapUAndTKnownHaps::getHap(int*gene, bool side)
{
long long int result=-1;
if (trioCounters->tableGenotypes->getTotalSolvedConfs(gene)==1)
 result=trioCounters->tableGenotypes->getSolvedConf(gene, 0, side, this->haplotypeTable);

//else throw BadFormat("MultimarkerMeasureHapUAndTKnownHaps::getHap(int*gene, long long int genePartnerPos, bool side)");
return result;
}

/*_________________________________________________________________*/


longLongList* MultimarkerMeasureHapUAndTKnownHaps::getHaplotypeCountsFromGenotypes(IndCategory ic, Transmission trans)
{
longLongList* hapCounts=new longLongList(), *l;
int* gene, *hap, h, genePartnerPos;
longLongList::iterator p;
long long int cont, cont2;

for (int i=0; i<2;i++)
if ((ic==(IndCategory) i) || (ic>=3))
//if ((ic==father && i==0) || (ic==mother && i==1) || (ic==offspring && i==2) || (ic==3) || (ic==4 && i<2))
{
switch (i)
{
case 0: l=trioCounters->genotypeCountsFather; break;
case 1: l=trioCounters->genotypeCountsMother; break;
}

if (l!=NULL)
for (longLongList::iterator it=l->begin(); it<l->end(); it++)
if (l->getElement(it)!=-1)
if (!trioCounters->tableGenotypes->hasSameValues(l->getElement(it))) // only heterozygous
{
gene=trioCounters->tableGenotypes->getPositions(l->getElement(it));
for (int side=0; side<2;side++)
if ((trans==t && side==1) || (trans==u && side==0) || trans==ut)
hapCounts->insertElement(getHap(gene, side));
zaparr(gene);
};
}
return hapCounts;
}

/*_________________________________________________________________*/
/*
HeteroListPair<long long int, double>* MultimarkerMeasureHapUAndTKnownHaps::getComposedList(longLongList *fatherHaps, longLongList* motherHaps)
{
long long int pos, pos2;
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>();
longLongList* haps=fatherHaps;
longLongList::iterator it;
for (int parent=0; parent<2; parent++)
{
if (parent==1) haps=motherHaps;
for (int i=0; i<haps->size(); i++)
{
pos=haps->getElement(i);
result->addValue(pos, 1);
}
}
return result;
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps::MultimarkerMeasureHapUAndTKnownHaps():MultimarkerMeasureHapUAndT()
{
/*
fatherCountsT=NULL;
motherCountsT=NULL;
fatherCountsU=NULL;
motherCountsU=NULL;
*/
}

/*_______________________________________________________________*/
/*
void MultimarkerMeasureHapUAndTKnownHaps::setHaplotypeFreqs()
{
this->haplotypeFreqsTMother=new HeteroListPair<long long int, double>(motherCountsT);
this->haplotypeFreqsUMother=new HeteroListPair<long long int, double>(motherCountsU);
this->haplotypeFreqsTFather=new HeteroListPair<long long int, double>(fatherCountsT);
this->haplotypeFreqsTFather=new HeteroListPair<long long int, double>(fatherCountsU);
}

/*_______________________________________________________________*/
/*
Pair<longLongList*>* MultimarkerMeasureHapUAndTKnownHaps::removeSameHaplotypes(longLongList* transList, longLongList *untransList)
{
Pair<longLongList*>* result=new Pair<longLongList*>();
result->First=transList->clone();
result->Second=untransList->clone();
for (int i=result->First->size()-1; i>=0; i--)
{
 if (result->First->getElement(i)==result->Second->getElement(i))
  
{
result->First->removeNode(i);
result->Second->removeNode(i);
}
}
return result;
}


/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTKnownHaps * MultimarkerMeasureHapUAndTKnownHaps::getPermutation ()
{
TrioCounters* tempResult=this->trioCounters->getPermutation();
MultimarkerMeasureHapUAndTKnownHaps* result=new MultimarkerMeasureHapUAndTKnownHaps(tempResult);
return result;
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndTKnownHaps::getStandardizedSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
return getTest(1, ic);
}



/*____________________________________________________________ */



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




