/* File: MultimarkerMeasure.h */


#ifndef __MultimarkerMeasureHapUAndTUnknownHaps_cpp__
#define __MultimarkerMeasureHapUAndTUnknownHaps_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////



/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTUnknownHaps::MultimarkerMeasureHapUAndTUnknownHaps(TrioCounters* source, PhaseAlg phaseAlg, EMAlg emAlg)
{
trioCounters=source;
//setHaplotypeFreqsTab();
setHaplotypeFreqs(phaseAlg, emAlg);
}
/*_________________________________________________________________*/
/*
MultimarkerMeasureHapUAndTUnknownHaps::MultimarkerMeasureHapUAndTUnknownHaps(MultimarkerMeasureHapUAndT& source):MultimarkerMeasureHapUAndT(source)
{
setHaplotypeFreqsTab();
setHaplotypeFreqs();
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTUnknownHaps::MultimarkerMeasureHapUAndTUnknownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender, int affectation, BayesType  Bay, float alphaBayes, float distance, PhaseAlg phaseAlg, EMAlg emAlg):MultimarkerMeasureHapUAndT(Pos,  totalPos, samp, gender, affectation, Bay, alphaBayes, distance)
{
//setHaplotypeFreqsTab();
setHaplotypeFreqs(phaseAlg, emAlg);
}
/*_________________________________________________________________*/
/*
MultimarkerMeasureHapUAndTKnownHaps* MultimarkerMeasureHapUAndTUnknownHaps::convertToMultimarkerMeasureHapUAndTKnownHaps()
{
MultimarkerMeasure<TrioSample>* multimarkerMeasureNew=multimarkerMeasure->convertToKnownGenotypes(haplotypeFreqsTab, haplotypeFreqsTabU);
MultimarkerMeasureHapUAndTKnownHaps* result=new MultimarkerMeasureHapUAndTKnownHaps(multimarkerMeasureNew);
return result;
}
/*_______________________________________________________________*/

MultidimensionalTable<double>* MultimarkerMeasureHapUAndTUnknownHaps::getInitialEstimation(int type)
{
double value;
int *position;
intList* dimList=new intList();
for (int i=0; i<trioCounters->totalPos;i++) dimList->insertElement(trioCounters->totalAlleles[i]);
MultidimensionalTable<double>* currentEstimation=new MultidimensionalTable<double>(dimList);
zap(dimList);
double total=0;
for (int i=0; i<currentEstimation->getSize();i++) 
{
 position=currentEstimation->getPositions(i);
 switch(type)
{
case 0: //
 value=1;
 for (int j=0; j<trioCounters->totalPos; j++)
  value=value*trioCounters->SNPAbsFreqs[j][position[j]]/(trioCounters->totalGenotypes*2);
break;
case 1://
 value=1/(double)currentEstimation->getSize();
break;
}
 currentEstimation->setValue(i, value);
 zap(position);
 total=total+value;
}
return currentEstimation;
}

/*_______________________________________________________________*/

void MultimarkerMeasureHapUAndTUnknownHaps::setHaplotypeFreqs(PhaseAlg phaseAlg, EMAlg emAlg)
{
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPair=getHaplotypeFreqsTab(emAlg);
this->haplotypeFreqsTMother=new HeteroListPair<long long int, double>();
this->haplotypeFreqsUMother=new HeteroListPair<long long int, double>();
this->haplotypeFreqsTFather=new HeteroListPair<long long int, double>();
this->haplotypeFreqsUFather=new HeteroListPair<long long int, double>();
int totalConfigurations;
double maxFrequency=0, currentFrequency, total=0;
long long int solvedFatherT, solvedFatherU, solvedMotherT, solvedMotherU, chosenSolvedFatherT, chosenSolvedFatherU, chosenSolvedMotherT, chosenSolvedMotherU, ambiguousPosFather, ambiguousPosMother;
for (long long int i=0; i<trioCounters->genotypeCountsFather->size(); i++)
{ 
ambiguousPosFather=trioCounters->genotypeCountsFather->getElement(i);
ambiguousPosMother=trioCounters->genotypeCountsMother->getElement(i);
totalConfigurations=trioCounters->tableGenotypes->getTotalSolvedConfs(ambiguousPosFather);
for (int j=0; j<totalConfigurations; j++)
{
solvedFatherT=trioCounters->tableGenotypes->getSolvedConfPos(ambiguousPosFather, j, true,  this->haplotypeTable);
solvedFatherU=trioCounters->tableGenotypes->getSolvedConfPos(ambiguousPosFather, j, false, this->haplotypeTable);
solvedMotherT=trioCounters->tableGenotypes->getPartnerSolvedConfPos(solvedFatherT, ambiguousPosMother, ambiguousPosFather, true, this->haplotypeTable);
solvedMotherU=trioCounters->tableGenotypes->getPartnerSolvedConfPos(solvedFatherU, ambiguousPosMother, ambiguousPosFather, false, this->haplotypeTable);
currentFrequency=haplotypeFreqsTabPair->First->getValue(solvedFatherT)*haplotypeFreqsTabPair->First->getValue(solvedMotherT);
if (emAlg==classic)
currentFrequency=currentFrequency*haplotypeFreqsTabPair->First->getValue(solvedFatherU)*haplotypeFreqsTabPair->First->getValue(solvedMotherU);
else currentFrequency=currentFrequency*haplotypeFreqsTabPair->Second->getValue(solvedFatherU)*haplotypeFreqsTabPair->Second->getValue(solvedMotherU);
if (phaseAlg==maxFreq)
{
if (maxFrequency<=currentFrequency) {maxFrequency=currentFrequency; chosenSolvedFatherT=solvedFatherT; chosenSolvedMotherT=solvedMotherT; chosenSolvedFatherU=solvedFatherU; chosenSolvedMotherU=solvedMotherU;}
}
else 
{
this->haplotypeFreqsTMother->addValue(solvedMotherT, currentFrequency/totalConfigurations);
this->haplotypeFreqsUMother->addValue(solvedMotherU, currentFrequency/totalConfigurations);
this->haplotypeFreqsTFather->addValue(solvedFatherT, currentFrequency/totalConfigurations);
this->haplotypeFreqsUFather->addValue(solvedFatherU, currentFrequency/totalConfigurations);
total=total+currentFrequency/totalConfigurations;
}
}
if (phaseAlg==maxFreq)
{
this->haplotypeFreqsTMother->addValue(chosenSolvedMotherT, 1);
this->haplotypeFreqsUMother->addValue(chosenSolvedMotherU, 1);
this->haplotypeFreqsTFather->addValue(chosenSolvedFatherT, 1);
this->haplotypeFreqsUFather->addValue(chosenSolvedFatherU, 1);
}
}
zap(haplotypeFreqsTabPair->First);
zap(haplotypeFreqsTabPair->Second);
zap(haplotypeFreqsTabPair);
normalizeFreqs(total); 
}
/*_______________________________________________________________*/

Pair<MultidimensionalTable<double>*>* MultimarkerMeasureHapUAndTUnknownHaps::getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes, EMAlg emAlg)
{
Pair<MultidimensionalTable<double>*>* result=new Pair<MultidimensionalTable<double>*>();
result->First=this->getInitialEstimation(type);
result->Second=NULL;
if (emAlg!=classic) result->Second=new MultidimensionalTable<double>(*result->First);
switch (emAlg)
{
case classic:
this->trioCounters->tableGenotypes->estimateMLE(result->First, genotypeAbsFreqsTab, pointersToPartnerGenotypes, this->trioCounters->totalGenotypes, 1000, result->Second, this->haplotypeTable); break;
case UTBased:
this->trioCounters->tableGenotypes->estimateMLE(result->First, genotypeAbsFreqsTab, pointersToPartnerGenotypes, this->trioCounters->totalGenotypes, 1000, result->Second, this->haplotypeTable); break;
case triosBased: this->trioCounters->tableGenotypes->estimateMLE(result->First, genotypeAbsFreqsTab, pointersToPartnerGenotypes, this->trioCounters->totalGenotypes, 1000, result->Second, this->haplotypeTable); break;
}
return result;
}
/*_______________________________________________________________*/

Pair<MultidimensionalTable<double>*>* MultimarkerMeasureHapUAndTUnknownHaps::getHaplotypeFreqsTab(EMAlg emAlg)
{
MultidimensionalTable<double>* genotypeAbsFreqsTab;
MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes=NULL;
if (emAlg!=triosBased) genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(parent);
else
{
genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(father);
pointersToPartnerGenotypes=trioCounters->getPointersToPartnerGenotypes(mother);
trioCounters->getGenotypeAbsFreqs(mother);
}
Pair<MultidimensionalTable<double>*>* result=getHaplotypeFreqsTab(0, genotypeAbsFreqsTab, pointersToPartnerGenotypes, emAlg);
if (result->First==NULL) result=getHaplotypeFreqsTab(1, genotypeAbsFreqsTab, pointersToPartnerGenotypes, emAlg);
if (result->First==NULL)
throw NullValue(" at MultimarkerMeasureHapUAndTUnknownHaps::getHaplotypeFreqsTab");
longLongList* pointer;
if (emAlg==triosBased)
{
for (int i=0; i<genotypeAbsFreqsTab->getSize(); i++)
{
 pointer=pointersToPartnerGenotypes->getValue(i);
 zap(pointer);
}
zap(pointersToPartnerGenotypes);
}
zap(genotypeAbsFreqsTab);
return result;
}


/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTUnknownHaps::MultimarkerMeasureHapUAndTUnknownHaps():MultimarkerMeasureHapUAndT()
{
//haplotypeFreqsTab=NULL;
//haplotypeFreqsTabU=NULL;
}

/*_________________________________________________________________*/

MultimarkerMeasureHapUAndTUnknownHaps * MultimarkerMeasureHapUAndTUnknownHaps::getPermutation ()
{
TrioCounters *tempResult=this->trioCounters->getPermutation();
MultimarkerMeasureHapUAndTUnknownHaps* result=new MultimarkerMeasureHapUAndTUnknownHaps(tempResult);
return result;
//zap (tempResult);
}


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




