
/* File: GetMultimarkerMeasuresByBlocks.cpp */


#ifndef __MultimarkerMeasuresByBlocks_cpp__
#define __MultimarkerMeasuresByBlocks_cpp__



/*______________________________________________________________________________*/



namespace BIOS {



/*___________________________________________________________________________*/

doubleList** MultimarkerMeasuresByBlocks::getPermutationResults (TrioCountersHapUAndT *TM, int totalPermutations, int totalPermutationMeasures, bool maxHap, intList* ignoreMeasures)
{
double* measuresP;
TrioCountersHapUAndT *TMP=NULL;
doubleList** distr= new doubleList*[totalPermutationMeasures];
for (int i=0; i<totalPermutationMeasures; i++)
 distr[i]=new doubleList();
for (int j=0;j<totalPermutations;j++)// 1000
{
if (j%10==0) cout <<  "permutation" << j+1 <<"\n";;
TMP=TM->getPermutation();
if (TMP->haplotypeCounts!=NULL) 
{
measuresP=getMeasureValues(TMP, totalPermutationMeasures, maxHap, ignoreMeasures);
//measuresP=Initialize(totalMeasures, 0.0);
for (int i=0; i<totalPermutationMeasures; i++)
 distr[i]->insertElement(measuresP[i]);
zaparr(measuresP);
zap(TMP);
}
}
return distr;
}
/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::updateMeasures (TrioCountersHapUAndT *TM, int totalPermutations, int totalMeasures, int totalPermutationMeasures, int subblockSize, const int * const pos, const double * const measures, double **measuresP, int iniBlock, bool maxHap, intList* ignoreMeasures, bool useOnlyKnownDistributions, bool onlyHetero, int iniPos) throw (NonProb,NonDefined)
{
double*distribution=NULL, p, totalUsedDifferentHaplotypesInG1, totalUsedHaplotypesInG1;
//for (int i=0; i<totalMeasures; i++)
//if (((i<2 || i==16) && (phaseAlg!=2)) || (i>=2 && i<16))
doubleList** distr=NULL;
if (useOnlyKnownDistributions==false) distr=getPermutationResults(TM, totalPermutations, totalPermutationMeasures, maxHap, ignoreMeasures);
doubleList* weights;
for (int i=0; i<totalMeasures; i++)
if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
p=-1;
if (i<totalPermutationMeasures)
{
if (!useOnlyKnownDistributions)
{
order(distr[i]);
//cout << "\n"<< getAlgorithmName(i) << ": " << measures[i] << " versus " << *distr[i];
distribution=distr[i]->getTable();
p=getPValue(distribution, distr[i]->size(), measures[i]);
}
}
else
switch (i)
{
case 17: case 18: case 25: case 26: case 34: case 35:
p=pdfTestChiSquare(measures[i], 1); break;
case 19: case 20: case 21: case 22: case 23: case 24: case 27: case 30:
p=pdfTestChiSquare(measures[i], (int)TM->totalUsedDifferentHaplotypes-1); break;
case 29:p=pdfTestChiSquare(measures[i], 9); break;
case 28: case 31: case 32:
if (i==28) weights=TM->getWeightsInWTDT(parent);
if (i==31) weights=TM->getWeightsInWTDT(parent,1);
if (i==32) weights=TM->getWeightsInWTDT(parent,2);
p=pdfTestWeightedChiSquare(measures[i], weights); 
zap (weights);
break;
}


if ((p>(1+zero) || p<(0-zero))) cout <<"error in p" << p <<"for measure:" << i <<"\n";

for (int j=0;j<subblockSize;j++)
{
if (measuresP[pos[j]-iniBlock][i]==-1.0) measuresP[pos[j]-iniBlock][i]=0;
measuresP[pos[j]-iniBlock][i]=measuresP[pos[j]-iniBlock][i]+p;
//if (i==(totalMeasures-1)) cout <<"\nupdated measure at pos: " << pos[j]-iniBlock;
}
if (i==25)//grouping
{
totalUsedDifferentHaplotypesInG1=TM->getTotalUsedDifferentHaplotypesInG1();
totalUsedHaplotypesInG1=TM->getTotalUsedHaplotypesInG1();
 OutputFile2 << iniPos+1 <<"\t" << p <<"\t";
 OutputFile3 << iniPos+1 <<"\t" << p <<"\t";

OutputFile2  << totalUsedDifferentHaplotypesInG1 <<"\t" << TM->totalUsedDifferentHaplotypes <<"\t" << totalUsedHaplotypesInG1 <<"\t" << TM->totalUsedHaplotypes <<"\t";
OutputFile3  << totalUsedDifferentHaplotypesInG1 <<"\t" << TM->totalUsedDifferentHaplotypes <<"\t" << totalUsedHaplotypesInG1 <<"\t" << TM->totalUsedHaplotypes <<"\t";


if (totalUsedHaplotypesInG1<TM->totalUsedHaplotypes/2)  
{
OutputFile2 << totalUsedDifferentHaplotypesInG1 <<"\t" << TM->printTotalUsedDifferentHaplotypesInG(t)   << "\n";
OutputFile3 << TM->totalUsedDifferentHaplotypes-totalUsedDifferentHaplotypesInG1 <<"\t" << TM->printTotalUsedDifferentHaplotypesInG(u)   << "\n";
}
else 
{
OutputFile3 << totalUsedDifferentHaplotypesInG1 <<"\t" << TM->printTotalUsedDifferentHaplotypesInG(t)   << "\n";
OutputFile2 << TM->totalUsedDifferentHaplotypes-totalUsedDifferentHaplotypesInG1 <<"\t" << TM->printTotalUsedDifferentHaplotypesInG(u)   << "\n";
}
}
if (!useOnlyKnownDistributions && i<totalPermutationMeasures) 
{
zap(distr[i]);
zaparr(distribution);
}
}// for each measure
 zaparr(distr);
//OutputFile <<"\n";

} // for each subblock with snps

/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::printResults (int totalMeasures, int size, const int* const totalOverlaps, const int* const totalOverlapsLogTDT, double **measuresP, intList* ignoreMeasures)
{
double alpha;


for (int i=0; i<totalMeasures; i++)
if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
 OutputFile << getAlgorithmName(i);
if (i<(totalMeasures-1)) OutputFile <<"\t";  
}
OutputFile <<"\n";
if (measuresP==NULL) 
OutputFile << "singleSNP\n";
else 
for (int s=0;s<size; s++)
{
//cout <<"\ntotal overlaps snp " << s+1 <<": " << totalOverlaps[s];
for (int i=0; i<totalMeasures; i++)

if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
// OutputFile << getAlgorithmName(i);
 if (i!=29) alpha=measuresP[s][i]/(double)totalOverlaps[s];
else 
{
if (totalOverlapsLogTDT[s]>0) alpha=measuresP[s][i]/(double)totalOverlapsLogTDT[s];
else alpha=-1;
}
//cout <<"bef alpha is:" << alpha;
// if (alpha<0.9) alpha=0; else alpha=0.1+floor(100*(alpha-0.9))/10;
//cout <<"now alpha is:" << alpha;
  OutputFile << alpha <<"\t";
 //OutputFile <<"\t" << getAlgorithmName(i);
// OutputFile << " p:\t" << alpha  <<"\t" ;
}
OutputFile <<"\n";

}
}

/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::getMeasures (char* filename, stringSample* blocks,  int windowOffset, int width, bool knownPhase, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, int totalMeasures, int totalPermutationMeasures, int totalPermutations, AlleleOrderType alleleOrderType, int totalSNPs, bool maxHap, intList* ignoreMeasures, bool useOnlyKnownDistributions, bool onlyHetero, SNPPos firstPosition, SNPPos lastPosition)  throw (OutOfRange<long long int>, OutOfRange<int>, OutOfRange<int>, NonProb, NoMemory, NonDefined, ZeroValue)
{
TrioSample* sample=NULL;
stringList* row;
intList* rowInt;
int totalWindows, size, size2, ini, *pos, *pos2, iniBlock=0;
double* measures=NULL;
TrioCountersHapUAndT *TM=NULL;
double **measuresP=NULL;
int *totalOverlaps=NULL, *totalOverlapsLogTDT=NULL;
TrioCountersHapUAndT *TMKnown=NULL;
int totalBlocks=1;
if (blocks!=NULL) totalBlocks=blocks->size();


 OutputFile2 << "FirstSNP\tpVal\tTotalUsedDifferentHaplotypesInG1\tTotalUsedDifferentHaplotypes";
OutputFile2 << "\tTotalFreqG1\tTotalFreq";
OutputFile2 << "\tTotalListSize\thaplotypeList\n";

 OutputFile3 << "FirstSNP\tpVal\tTotalUsedDifferentHaplotypesInG1\tTotalUsedDifferentHaplotypes";
OutputFile3 << "\tTotalFreqG1\tTotalFreq";
OutputFile3 << "\tTotalListSize\thaplotypeList\n";


if (lastPosition==-1) lastPosition=totalSNPs-1;

totalSNPs=lastPosition-firstPosition+1;

iniBlock=firstPosition;

for (int i=0; i<totalBlocks;i++)
{
if (blocks!=NULL) row=blocks->getElement(i);
else 
{
if (firstPosition==0) rowInt=new intList(totalSNPs, 1);
else
{
rowInt=new intList();
for (int pos=firstPosition; pos<=lastPosition; pos++)
rowInt->insertElement(pos+1);
//cout <<"row int:" << *rowInt <<"\n";
}
row=rowInt->getStringList();
zap(rowInt);
}
size=row->size();
//if (i>=82)
//cout <<"\nsize is:" << size <<"\n"; 
if (size>1) 
{
measuresP=new double*[size];
for (int j=0; j<size; j++)
measuresP[j]=Initialize(totalMeasures, -1.0);
totalOverlaps=Initialize(size, 0);
totalOverlapsLogTDT=Initialize(size, 0);

totalWindows=size/windowOffset-(int)ceil(width/windowOffset)+1;//+(size%width>0);
cout <<"totalwindows: " << totalWindows <<"\n";
if (size<width) totalWindows=1;

for (int b=0; b<totalWindows; b++)
{
ini=b*windowOffset;
size2=width;//min(width,size-ini);
//if (size%width>0 && b==totalWindows-1) size2=min(size%width, size-ini);
//if ((size<width && size2>1) || size2==width)
//if (size2>=1)
//cout <<"size for window " << b <<": " << size2 <<"\n";

if (size2==width)
{
//cout <<"size is:" << size <<"\n";
if (blocks!=NULL) cout <<"\nBlock " << i+1 <<", subblock " << b+1 <<"\n";
else cout <<"\nWindow: " << ini+1 <<"\n";
pos=new int[size2];
pos2=new int[size2];
//cout <<"size2is:" << size2 <<"\n";

for (int j=0;j<size2;j++)
{
//cout << " iniBlock:" << iniBlock << ", j is: " << j <<", size2 is:" << size2 <<"\n";
 if (blocks!=NULL) pos[j]=atoi(row->getElement(ini+j).c_str())-1;
else pos[j]=atoi(row->getElement(ini+j).c_str())-1;
 pos2[j]=j;
//cout << " and pos[j] is: " << pos[j] <<"\n";
if ((pos[j]-iniBlock) >=size)
{
cout <<"error, size is " << size << " and accesing to " << pos[j] << " plus " << iniBlock <<"\n";
exit (0);
}
 totalOverlaps[pos[j]-iniBlock]++;
 totalOverlapsLogTDT[pos[j]-iniBlock]++;
//cout <<"updating ovrlsp at pos: " << pos[j] <<" total is:" << totalOverlaps[pos[j]-iniBlock] <<"\n";
//cout <<"\npos2 is: " << pos2[j];
}
sample=new TrioSample(filename, pos, size2, alleleOrderType);
TM=new TrioCountersHapUAndT(pos2, size2, sample, allAffectation, phaseAlg, emDistributions, emRestriction, false, onlyHetero);

if (TM->haplotypeCounts!=NULL)
{
measures=getMeasureValues(TM, totalMeasures, maxHap, ignoreMeasures);
if (totalMeasures>=30 && measures[29]==-1) 
for (int j=0;j<size2;j++)
 totalOverlapsLogTDT[pos[j]-iniBlock]--;
//cout <<"measures computed for size: " << size2 <<"starting at " << pos[0] <<"\n";
updateMeasures(TM, totalPermutations, totalMeasures, totalPermutationMeasures, size2, pos, measures, measuresP, iniBlock, maxHap, ignoreMeasures, useOnlyKnownDistributions, onlyHetero, ini);
//zaparr(measures);
} // TM!=NULL
else 
{
TM=NULL;
cout << "not known haplotypes found\n";
}
zaparr(pos);
zaparr(pos2);
zap(TM);
zap(sample);
} // for each subblock > 1
} // for each window
} // if size > 1
printResults(totalMeasures, size, totalOverlaps, totalOverlapsLogTDT, measuresP, ignoreMeasures);

if (size>1)
{
for (int k=0; k<size; k++)
zaparr(measuresP[k], totalMeasures);
zaparr(measuresP, size);
zaparr(totalOverlaps, size);
zaparr(totalOverlapsLogTDT, size);
}
zap(row);
iniBlock=iniBlock+size;
} // for each block
}

} // end namespace

#endif




