/* File: PairGenotype.h */


#ifndef __PairGenotype_cpp__
#define __PairGenotype_cpp__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the First, one for the Second. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/




/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

PairGenotype::PairGenotype ()
{
}
/*____________________________________________________________ */

PairGenotype::PairGenotype (PairGenotype * Source)
{
FirstGenotype=Source->FirstGenotype;
SecondGenotype=Source->SecondGenotype;
}
/*____________________________________________________________ */

PairGenotype::PairGenotype (Genotype * Source1, Genotype * Source2)
{
FirstGenotype=Source1;
SecondGenotype=Source2;
}

/*____________________________________________________________ */

Genotype* PairGenotype::getFirstGenotype ()
{
	return FirstGenotype;
}
/*____________________________________________________________ */

Genotype* PairGenotype::getSecondGenotype ()
{
	return SecondGenotype;
}
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Homozygous1 (SNPPos position, allele ** allAlleles)      
{
return FirstGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]);
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Homozygous2 (SNPPos position, allele ** allAlleles)      
{
return FirstGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]);
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Homozygous2 (SNPPos position, allele ** allAlleles)      
{
return 
(FirstGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]))
||
(FirstGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Heterozygous (SNPPos position, allele ** allAlleles)      
{
return 
(FirstGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]))
||
(FirstGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Heterozygous (SNPPos position, allele ** allAlleles)      
{
return 
(FirstGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]))
||
(FirstGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]));
};

/*___________________________________________________*/

bool PairGenotype::IsHomozygousHeterozygous (const SNPPos position, allele ** allAlleles)      
{
return IsHomozygous1Heterozygous(position, allAlleles)
		|| IsHomozygous2Heterozygous(position, allAlleles);
};
/*___________________________________________________*/

bool PairGenotype::IsHeterozygousHeterozygous (const SNPPos position, allele ** allAlleles)      
{
return FirstGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]);
};


/*___________________________________________________*/

bool PairGenotype::IsMissingMissing (const SNPPos position)      
{
return FirstGenotype->getDiplotype(position)->IsAMissingSNP() && SecondGenotype->getDiplotype(position)->IsAMissingSNP();
};


/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Missing (const SNPPos position, allele ** allAlleles)      
{
return (FirstGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsAMissingSNP())
||
   (FirstGenotype->getDiplotype(position)->IsAMissingSNP() && SecondGenotype->getDiplotype(position)->IsHomozygous1(allAlleles[position][0]));
};

/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Missing (const SNPPos position, allele ** allAlleles)      
{
return (FirstGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsAMissingSNP())
||
   (FirstGenotype->getDiplotype(position)->IsAMissingSNP() && SecondGenotype->getDiplotype(position)->IsHomozygous2(allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHeterozygousMissing (const SNPPos position, allele ** allAlleles)      
{
return (FirstGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]) && SecondGenotype->getDiplotype(position)->IsAMissingSNP())
||
   (FirstGenotype->getDiplotype(position)->IsAMissingSNP() && SecondGenotype->getDiplotype(position)->IsHeterozygous(allAlleles[position][0]));
};


};  // End of Namespace

#endif

/* End of file: PairGenotype.h */




