/* File: PairwiseCI.h */


#ifndef __PairwiseCI_cpp__
#define __PairwiseCI_cpp__





//using namespace stats;

namespace BIOS {


     /** @name Operations on PairwiseCI 
        @memo Operations on a PairwiseCI 
    */

 map<long long int, float>* PairwiseCI::getUpperBound(){return upperBound;};
    map<long long int, float>* PairwiseCI::getLowerBound(){return lowerBound;};

	PairwiseCI::PairwiseCI(TrioSample * sample, Positions* pos, double width, BayesType  bayesMode, float alpha, bool *listOfUsedSNPs, SNPPos firstSNP, SNPPos lastSNP)
{
// preconditions: totalSNPs is the total number of snps in the sample

SNPPos totalSNPs=pos->VirtualPositions::GetTotalSNPs();

if (lastSNP==-1) lastSNP=totalSNPs-1;
upperBound=new map<long long int, float>();
lowerBound=new map<long long int, float>();
IndPos total=0, top;
Pair<double> pair;
intList* dimList=new intList();
dimList->insertElement(totalSNPs);
dimList->insertElement(totalSNPs);
long long int position;
int poss[2];
double distance;
MultidimensionalEmptyTable<int>* mm=new MultidimensionalEmptyTable<int>(dimList);
zap(dimList);
BidimensionalTable<double> * multiallelicFreqsUT=NULL;
MultiallelicPairwiseMeasure* MA=NULL;
TrioCountersHapUAndT* PM=NULL;
Table2x2 T2x2;
double fA, fB, fAB;
for (SNPPos SNP=firstSNP; SNP<=lastSNP;SNP++)
if (listOfUsedSNPs[SNP])
{
if (SNP%100==0) cout << "\nSNP " << SNP+1;
 distance=pos->GetTotalSNPs(SNP, width);

for (SNPPos SNP2=SNP+1; SNP2<(SNP+distance); SNP2++)
  if (SNP2<totalSNPs)
   if (listOfUsedSNPs[SNP2])
   {
poss[0]=SNP;
poss[1]=SNP2;
position=mm->getPos(poss);

PM=new TrioCountersHapUAndT (poss, 2, sample, allAffectation, weighted, UTDistributions, triosBasedRestriction);

multiallelicFreqsUT=PM->getMultiallelicFreqs(0, 1, ut);

MA=new MultiallelicPairwiseMeasure(multiallelicFreqsUT);

fAB=MA->getFreq(0,0);
 fA=MA->getFreq(0,0)+MA->getFreq(0,1);
 fB=MA->getFreq(0,0)+MA->getFreq(1,0);
	pair=T2x2.GetQuantilesDPrime(alpha, fA, fB, fAB, PM->totalMeiosis*MA->getFreq(0, 0), PM->totalMeiosis*MA->getFreq(0,1), PM->totalMeiosis*MA->getFreq(1,0), PM->totalMeiosis*MA->getFreq(1,1), 0);

(*upperBound)[position]=pair.Second;
(*lowerBound)[position]=pair.First;

zap(MA);
zap(multiallelicFreqsUT);

zap(PM);

}
}
zap (mm);
};


	PairwiseCI::~PairwiseCI()
	{
 zap(upperBound);
zap(lowerBound);
	};




};  // End of Namespace

#endif

/* End of file: PairwiseCI.h */




