/* File: ParentalHaplotypes.h */

#ifndef __ParentalHaplotypes_h__
#define __ParentalHaplotypes_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo ParentalHaplotype 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


	class ParentalHaplotypes: public ParentalHaplotypesForEachIndividual
{
public:
int trioCount;
double freq; 
ParentalHaplotypes():ParentalHaplotypesForEachIndividual()
{
outputSeparator='-'; delimiters=true; printTransmitted=true; printUntransmitted=true;
};
ParentalHaplotypes(long long int fatherT, long long int fatherU, long long int motherT, long long int motherU, int troCount, double freq, char outputSeparator, bool delimiters=false, bool printTransmitted=true, bool  printUntransitted=true): ParentalHaplotypesForEachIndividual(fatherT, fatherU, motherT, motherU, trioCount)
{
this->outputSeparator=outputSeparator; this->delimiters=delimiters; this->printTransmitted=printTransmitted; this->printUntransmitted=printUntransitted;
this->freq=freq;
this->trioCount=trioCount;
};
~ParentalHaplotypes(){};
static ParentalHaplotypes* fromString(string s)
{
throw NonImplemented("static ParentalHaplotypes* fromString(string s)");
};
};
	
/*______________________________________________________*/
/*
 template<> Container<vector,  ParentalHaplotypes>::iterator Container<vector,  ParentalHaplotypes>::removeNode(Container<vector,  ParentalHaplotypes>::iterator it, Container<vector,  ParentalHaplotypes>::iterator it2){
return this->erase(it, it2);};
	/*______________________________________________________*/

typedef Container<vector<ParentalHaplotypes*>, ParentalHaplotypes*>  ParentalHaplotypeList;
/*______________________________________________________*/

ostream& operator<<(ostream& out, struct ParentalHaplotypes& pm)
       {
 if (pm.delimiters)  out << "Father T-U: [";
 out << pm.fatherT << pm.outputSeparator << pm.fatherU;
 if (pm.delimiters)  out << "] Mother T-U: [";
 out << pm.motherT << pm.outputSeparator << pm.motherU;
 if (pm.delimiters) out <<"]: ";
out << pm.trioCount;
 if (pm.delimiters) out << "(";
out << pm.freq;
 if (pm.delimiters) out <<")";


return out;
};

typedef Container<vector<ParentalHaplotypes*>, ParentalHaplotypes*>  ParentalHaplotypesList;
/*______________________________________________________*/

   ostream& operator<<(ostream& out, ParentalHaplotypesList& lista)
  {
out <<lista.leftDelimiter;
    ParentalHaplotypesList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         out << **p;
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<"\n"; 
else 
{
out << lista.rightDelimiter;
out <<"\n";
}
    }
     out <<"\n";
 
    return out;
  }


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




