/* File: ParentalHaplotypesForEachIndividual.h */

#ifndef __ParentalHaplotypesForEachIndividual_h__
#define __ParentalHaplotypesForEachIndividual_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo ParentalHaplotype 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


	class ParentalHaplotypesForEachIndividual
{
public:
char outputSeparator;
bool delimiters, printTransmitted, printUntransmitted;
// -1 in a hap means the genotype was missing
// -2 in a hap means is unphased
long long int fatherT;
long long int fatherU;
long long int motherT;
long long int motherU;

void check(){if ((fatherT<0 && fatherT!=fatherU) || (motherT<0 && motherT!=motherU)) throw OutOfRange<int>(fatherT, "parentalHaplotypes.check()");};
bool allKnown() {this->check(); return fatherT>=0 && motherT>=0;}
bool isKnown(bool father){this->check(); return (father && fatherT>=0) || (!father && motherT>=0);}  
ParentalHaplotypesForEachIndividual(){outputSeparator='\n';delimiters=false; printTransmitted=true; printUntransmitted=true;}
ParentalHaplotypesForEachIndividual(long long int fatherT, long long int fatherU, long long int motherT, long long int motherU, int trioCount, char outputSeparator='\n', bool delimiters=false, bool printTransmitted=true, bool  printUntransitted=true)
{
this->fatherT=fatherT; this->fatherU=fatherU; this->motherT=motherT; this->motherU=motherU; this->outputSeparator=outputSeparator; this->delimiters=delimiters; this->printTransmitted=printTransmitted; this->printUntransmitted=printUntransmitted;
};
~ParentalHaplotypesForEachIndividual(){};
};
	
/*______________________________________________________*/
/*
 template<> Container<vector, struct ParentalHaplotypesForEachIndividual>::iterator Container<vector,  ParentalHaplotypesForEachIndividual>::removeNode(Container<vector, ParentalHaplotypesForEachIndividual>::iterator it, Container<vector, ParentalHaplotypesForEachIndividual>::iterator it2){
return this->erase(it, it2);};
	

/*______________________________________________________*/

ostream& operator<<(ostream& out, ParentalHaplotypesForEachIndividual& pm)
       {
   out << pm.fatherT << pm.outputSeparator << pm.fatherU << pm.outputSeparator << pm.motherT << pm.outputSeparator << pm.motherU << pm.outputSeparator;

return out;
};


typedef Container<vector<ParentalHaplotypesForEachIndividual*>, ParentalHaplotypesForEachIndividual*>  ParentalHaplotypesForEachIndividualList;
/*______________________________________________________*/

   ostream& operator<<(ostream& out, ParentalHaplotypesForEachIndividualList& lista)
  {
 out <<lista.leftDelimiter;
    ParentalHaplotypesForEachIndividualList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         out << *p;
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<lista.outputSeparator; 
else 
{
out <<lista.rightDelimiter;
}
    }
     out <<"\n";
 
    return out;
  }




};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




