/* File: Phenotype.cpp */


#ifndef __Phenotype_cpp__
#define __Phenotype_cpp__



#include "Phenotype.h"



namespace BIOS {

 

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


//


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

Phenotype::Phenotype (const PhenotypeS & PS)
{
phenotype=PS;
}

/*____________________________________________________________ */

bool Phenotype::IsMale ()
{
return phenotype.Gender==1;
}
/*____________________________________________________________ */

bool Phenotype::IsFemale ()
{
return phenotype.Gender==2;
}
/*____________________________________________________________ */

bool Phenotype::IsAChild ()
{
return phenotype.Father!=0 || phenotype.Mother!=0;
}
/*____________________________________________________________ */

bool Phenotype::IsAParent()
{
return IsAFather() || IsAMother();
}
/*____________________________________________________________ */

bool Phenotype::IsAMother()
{
return !IsAChild() && IsFemale();
}
/*____________________________________________________________ */

bool Phenotype::IsAFather()
{
return !IsAChild() && IsMale();
}
/*____________________________________________________________ */

bool Phenotype::IsAffected ()
{
 return phenotype.isAffected();
}
/*____________________________________________________________ */

affectation Phenotype::getAffectation ()
{
 return phenotype.getAffectation();
}

/*____________________________________________________________ */

string Phenotype::PrintPhenotype ()
{
//strcpy(line,"\0");
//cout <<"j";
//exit(0);
char line[100];
//cout <<phenotype.Code;// << phenotype.Code;// << phenotype.Father << phenotype.Mother;
//phenotype.Gender, phenotype.Affectation, phenotype.Code2;
//exit(0);
sprintf(line, "%d %d %d %d %d %d %d\0", phenotype.Pedigree, phenotype.Code, phenotype.Father, phenotype.Mother,
phenotype.Gender, phenotype.getAffectation(), phenotype.Code2);
string p=string(line);
return p;
}
/*____________________________________________________________ */

void Phenotype::SetPhenotype (const PhenotypeS & PS)
{
	phenotype=PS;
}


/*____________________________________________________________ */

bool  Phenotype::operator>(Phenotype & phe)
{
	return ((phenotype.Pedigree==phe.getPedigree() && phenotype.Code>phe.getCode()) || phenotype.Pedigree>phe.getPedigree());
}
/*____________________________________________________________ */

bool  Phenotype::operator<(Phenotype & phe)
{
	return ((phenotype.Pedigree==phe.getPedigree() && phenotype.Code<phe.getCode()) || phenotype.Pedigree<phe.getPedigree());
}
/*____________________________________________________________ */

bool  Phenotype::operator==(Phenotype & phe)
{
	return (phenotype.Pedigree==phe.getPedigree() && phenotype.Code==phe.getCode());
}

/*___________________________________________________________ */

Phenotype* Phenotype::fromString (string s)
{
	Phenotype::PhenotypeS pS;
sscanf(s.c_str(), "%d%d%d%d%d%d%d", &(pS.Pedigree), &(pS.Code), &(pS.Father), &(pS.Mother), 
	&(pS.Gender), &(pS.Affectation), &(pS.Code2));
	return (new Phenotype(pS));
}


};  // Fin del Namespace

#endif

/* Fin Fichero: Phenotype.h */
