/* File: positions.h */

#ifndef __Positions_h__
#define __Positions_h__

//#include <string>
//#include <math.h>
//#include <cassert>

//#include "fstream.h"

//#include <iostream>//
//#include <cassert>//
//#include <cstring>//
//#include <cstdio>//
//#include <cstdlib>//
//#include <cmath>//
//#include <ctime>//
//#include <malloc.h>//
//#include <fstream>//





//#include "VirtualPositions.cpp"


//using namespace std;
//using namespace string;


namespace BIOS {


/************************/
/* positions DEFINITION */
/************************/


/**
        @memo positions for SNPs

	@doc
        Definition:
        A set of positions' features 

        Memory space: O(TotalSNPs), which TotalSNPs being the number of SNPs in the sample
        Each positions in a sample has been genotyped for the same TotalSNPs SNPs.

        @author Maria M. Abad
	@version 1.0
*/

	class Positions: public VirtualPositions
	 {

  

/***************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      /* PUBLIC FUNCTIONS (INTERFACE) */




      public:

		  Positions(char* filename):VirtualPositions(filename){};

		  Positions():VirtualPositions(){};

	   /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

		void CheckFilename(char* filename);


	//	double getPosition(SNPPos SNP);

		unsigned long int GetTotalSNPs(iterator IniPos, float Width);

		unsigned long int GetTotalSNPs(SNPPos IniPos, float Width);


		bool IsEndReached(iterator IniPos, float Width);

		iterator MoveToPos(iterator InitialPos, float Pos);

		double GetDistance(SNPPos SNP, SNPPos SNP2);
		
		double GetDistance(Positions::iterator p1, Positions::iterator p2);

		void PosSampling (doubleList *pos);

		iterator GetPointerWithPos(float Pos);


};  // End of class positions


};  // Fin del Namespace

#endif

/* Fin Fichero: Positions.h */
