/* File: Trio.h */


#ifndef __Trio_h__
#define __Trio_h__





namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class Trio {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	


   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

TrioPhenotype* trioPhenotype;
TrioGenotype* trioGenotype;
GenotypeSample* genotypeSample;
PhenotypeSample* phenotypeSample;

      /** @name Operations on Genotype 
        @memo Operations on a Genotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */


		Trio(PhenotypeSample * phenotypeSample, GenotypeSample* genotypeSample);

		Trio (PhenotypeSample * phenotypeSample, PhenotypePointer FatherP, PhenotypePointer MotherP, PhenotypePointer ChildP, GenotypeSample* genotypeSample, GenotypePointer FatherG, GenotypePointer MotherG, GenotypePointer ChildG);                
		PhenotypeSample::iterator getChildPhenotype();
		PhenotypeSample::iterator getMotherPhenotype();
		PhenotypeSample::iterator getFatherPhenotype();
  PhenotypeSample::iterator getPhenotype(IndCategory ic);
		GenotypeSample::iterator getChildGenotype();
		GenotypeSample::iterator getMotherGenotype();
		GenotypeSample::iterator getFatherGenotype();
  GenotypeSample::iterator getGenotype(IndCategory ic);
//		Trio (
//			PhenotypeSample *ps, GenotypeSample *gs, 
//			PhenotypePointer IndPhenotype, GenotypePointer IndGenotype);


      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
      ~Trio () {zap(trioGenotype); zap(trioPhenotype);};


	  char* PrintTrio(SNPPos SNP);

	       bool operator!=(const Trio & g){cout <<"Not implemented yet"; exit(0);};;

	  bool  operator>(const Trio & di){cout <<"Not implemented yet"; exit(0);};;

	  bool  operator<(const Trio & di){cout <<"Not implemented yet"; exit(0);};;


};  // End of class Genotype

   ostream& operator<<(ostream& out, Trio& trio);

  

//template<> ostream& operator<<(ostream& out, Container<vector, Trio>& l){};

};  // End of Namespace

#endif

/* End of file: Genotype.h */




