/* File: TrioCounters.h */


#ifndef __TrioCounters_cpp__
#define __TrioCounters_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



/*____________________________________________________________ */

TrioCounters* TrioCounters::clone()
{
return new TrioCounters((TrioCounters&)*this);
} 
/*_________________________________________________________________*/

TrioCounters::TrioCounters(TrioCounters& source)
{
this->totalPos=source.totalPos;
this->totalGenotypes=source.totalGenotypes;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
fatherPedigrees=NULL;
motherPedigrees=NULL;
totalAlleles=NULL;
//allAlleles=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
tableGenotypes=NULL;
//if (source.genotypeFreqs!=NULL) genotypeFreqs=new HeteroListPair<long long int, double>(*source.genotypeFreqs);
//if (source.genotypeAbsFreqsTab!=NULL) genotypeAbsFreqsTab=new MultidimensionalTable<double>(*source.genotypeAbsFreqsTab);
if (source.genotypeCountsFather!=NULL) genotypeCountsFather=new longLongList(*source.genotypeCountsFather);
if (source.genotypeCountsMother!=NULL) genotypeCountsMother=new longLongList(*source.genotypeCountsMother);
if (source.fatherPedigrees!=NULL) fatherPedigrees=new intList(*source.fatherPedigrees);
if (source.motherPedigrees!=NULL) motherPedigrees=new intList(*source.motherPedigrees);

if (source.totalAlleles!=NULL)
{
totalAlleles=new int[totalPos];
for (int i=0; i<totalPos; i++)
 totalAlleles[i]=source.totalAlleles[i];
}
double** sourceSNPAbsFreqs=source.SNPAbsFreqsFather, **SNPAbsFreqs;
for (int parent=0; parent<2; parent++)
{
if (parent==1) {sourceSNPAbsFreqs=source.SNPAbsFreqsMother;}
if (sourceSNPAbsFreqs!=NULL)
{
if (parent==0) {SNPAbsFreqsFather=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsFather;} 
else {SNPAbsFreqsMother=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsMother;} 
for (int i=0; i<this->totalPos; i++)
{
 SNPAbsFreqs[i]=new double[this->totalAlleles[i]];
 for (int j=0; j<this->totalAlleles[i]; j++) SNPAbsFreqs[i][j]=sourceSNPAbsFreqs[i][j];
if (parent==0) SNPAbsFreqsFather[i]=SNPAbsFreqs[i]; 
else SNPAbsFreqsMother[i]=SNPAbsFreqs[i]; 
}
}
else if (parent==0) SNPAbsFreqsFather=NULL; else SNPAbsFreqsMother=NULL;
}
if (source.tableGenotypes!=NULL) tableGenotypes=new AmbiguousArray(*source.tableGenotypes);

}
/*_________________________________________________________________*/

MultidimensionalTable<longLongList*>* TrioCounters::getPointersToPartnerGenotypes(IndCategory icPartner)
{
if (icPartner!=father && icPartner!=mother) throw BadFormat(string("TrioCounters::getPointersToPartnerGenotypes"));
longLongList* list, *list2;
intList* dimList=new intList();
for (int i=0; i<this->totalPos; i++)
 dimList->insertElement(getTotalGenotypes(totalAlleles[i]));
MultidimensionalTable<longLongList*>*result=new MultidimensionalTable<longLongList*>(dimList);
zap(dimList);
for (int i=0; i<result->getSize(); i++) result->setValue(i, NULL);
longLongList* partner=genotypeCountsFather;
longLongList* current=genotypeCountsMother;
if (icPartner==mother)
{
partner=genotypeCountsMother;
current=genotypeCountsFather;
}
//else cout <<"for mother\n";
long long int currentValue, partnerValue;
longLongList * pointerList;
for (int i=0; i<current->size(); i++)
if (current->getElement(i)>=0)
{
currentValue=current->getElement(i);
partnerValue=partner->getElement(i);
//cout <<"current:" << currentValue <<" and partner" << partnerValue <<"\n";
pointerList=result->getValue(currentValue);
if (pointerList==NULL) {pointerList=new longLongList(); result->setValue(currentValue, pointerList);};
pointerList->insertElement(partnerValue);
//cout <<" result at pos " << currentValue <<" :  " << *result->getValue(currentValue);
}
//exit(0);
return result;
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters(SNPPos Pos[], SNPPos TotalPos,  TrioSample * samp, int affectation, bool includeMissing)  throw (OutOfRange<long long int>)
{
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
fatherPedigrees=NULL;
motherPedigrees=NULL;
totalAlleles=NULL;
tableGenotypes=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
set (Pos, TotalPos, samp, affectation, includeMissing);
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters()
{
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
fatherPedigrees=NULL;
motherPedigrees=NULL;
totalAlleles=NULL;
//allAlleles=NULL;
tableGenotypes=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
}
/*_______________________________________________________________*/

 void TrioCounters::empty()
{
zap(genotypeCountsFather);
zap(genotypeCountsMother);
zap(fatherPedigrees);
zap(motherPedigrees);
zaparr(totalAlleles);
zap(tableGenotypes);

for (int i=0; i<totalPos; i++)
{
if (SNPAbsFreqsFather!=NULL) zaparr(SNPAbsFreqsFather[i]);
if (SNPAbsFreqsMother!=NULL) zaparr(SNPAbsFreqsMother[i]);
}

zaparr(SNPAbsFreqsFather);
zaparr(SNPAbsFreqsMother);

}

/*_______________________________________________________________*/

MultidimensionalTable<double>*  TrioCounters::getGenotypeAbsFreqs(IndCategory member) throw (NoMemory)
{
longLongList* list, *list2;
intList* dimList=new intList();
for (int i=0; i<this->totalPos; i++)
 dimList->insertElement(getTotalGenotypes(totalAlleles[i]));


MultidimensionalTable<double> *result=new MultidimensionalTable<double>(dimList);


zap(dimList);
int cont=0;
if (member==offspring || member==everybody) throw BadFormat(string("TrioCounters::getGenotypeAbsFreqs"));

for (int i=0; i<2; i++)
if (member==father && i==0 || member==mother && i==1 || member==parent)
{
if (i==0) {list=genotypeCountsFather; list2=genotypeCountsMother;} else {list=genotypeCountsMother; list2=genotypeCountsFather;};
for (longLongList::iterator it=list->begin(); it<list->end(); it++)
if (list->getElement(it)!=-1)//missing when includeMissing=false are disregarded; homozygous when tdt=true are disregarded
{
result->addValue(list->getElement(it), 1);
cont++;
}
}
return result;
}


/*_________________________________________________________________*/

 void TrioCounters::set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, bool includeMissing)  throw (OutOfRange<long long int>)
{
this->totalPos=totalPos;
this->includeMissing=includeMissing;
set(samp, affectation, Pos);
}
/*_______________________________________________________________*/

 void TrioCounters::setGenotypeTableDimensions()
{
intList* dimList=new intList();
for (int i=0; i<totalPos; i++)
 dimList->insertElement(getTotalGenotypes(totalAlleles[i]));
tableGenotypes=new AmbiguousArray(dimList);
zap(dimList);
}

/*_______________________________________________________________*/
/*
 void TrioCounters::setGenotypeTable()
{
longLongList * genotypeCounts;
for (int i=0; i<2; i++)
{
if (i==0) genotypeCounts=genotypeCountsFather; else genotypeCounts=genotypeCountsMother;
for (longLongList::iterator it=genotypeCounts->begin(); it!=genotypeCounts->end(); it++)
 tableGenotypes->addValue(genotypeCounts->getElement(it), 1);
}
}
/*_______________________________________________________________*/

 longLongList*TrioCounters::permuteInParent(bool father)
{
// It returns a new list of genotype codes for each individual randomly changing between T/U
long int value, value2;
int transmitted;
longLongList* result=new longLongList(), *temp;
if (father) 
temp=genotypeCountsFather;
else temp=genotypeCountsMother;
for (longLongList::iterator it=temp->begin(); it<temp->end(); it++)
{
value=temp->getElement(it);
transmitted=ranbinom(1, 0.5);
if (transmitted)
{
result->insertElement(value);
}
else
{
value2=tableGenotypes->changePhase(value);
result->insertElement(value2);
//cout << "\npermutation: orig:"  << value << "new:" << value2;
}
}
return result;
}

/*___________________________________________________________________________________________________*/

 void TrioCounters::setSNPFreqs()  throw (OutOfRange<long long int>, OutOfRange<int>)
{
SNPAbsFreqsFather=new double*[totalPos];
SNPAbsFreqsMother=new double*[totalPos];
int al1, al2, al3, al4;
double totalSNP=0, freq=0;
for (int i=0; i<totalPos; i++)
{
 SNPAbsFreqsFather[i]=Initialize(totalAlleles[i], 0.0);
 SNPAbsFreqsMother[i]=Initialize(totalAlleles[i], 0.0);
}

int i=0, *position=NULL, *position2=NULL;
for (int i=0; i<genotypeCountsFather->size(); i++)
{
if (genotypeCountsFather->getElement(i)>=0)
{
position=tableGenotypes->getPositions(genotypeCountsFather->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al1=getAllelePos(position[j], j, true, tableGenotypes);
 al2=getAllelePos(position[j], j, false, tableGenotypes);
 SNPAbsFreqsFather[j][al1]=SNPAbsFreqsFather[j][al1]+1;
 SNPAbsFreqsFather[j][al2]=SNPAbsFreqsFather[j][al2]+1;
}
zaparr(position);
}
if (genotypeCountsMother->getElement(i)>=0)
{
position2=tableGenotypes->getPositions(genotypeCountsMother->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al3=getAllelePos(position2[j], j, true, tableGenotypes);
 al4=getAllelePos(position2[j], j, false, tableGenotypes);
 SNPAbsFreqsMother[j][al3]=SNPAbsFreqsMother[j][al3]+1;
 SNPAbsFreqsMother[j][al4]=SNPAbsFreqsMother[j][al4]+1;
}
zaparr(position2);
}
}
}
/*_______________________________________________________________*/
/*
 longLongList*TrioCounters::updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother)
{
// It updates the permutations in the children
longLongList* result=new longLongList();
long int valueMother, valueFather, valueChild;
int alMother, alFather, *positionsFather, *positionsMother, *positionsChild;
for (int cont=0; cont<genotypeCountsFather->size(); cont++)
{
valueMother=genotypeCountsMother->getElement(cont);
valueFather=genotypeCountsFather->getElement(cont);
positionsFather=tableGenotypes->getPositions(valueFather);
positionsMother=tableGenotypes->getPositions(valueMother);
positionsChild=tableGenotypes->getPositions(valueChild);
for (int i=0; i<totalPos; i++)
if (tableGenotypes->isAKnownPosition (positionsFather[i], i)) 
if (tableGenotypes->isAPositionWithDifferentValues(positionsFather[i], i) || tableGenotypes->isAPositionWithDifferentValues(positionsMother[i], i)) 
{
alFather=tableGenotypes->getKnownValue (positionsFather[i], i, true);
alMother=tableGenotypes->getKnownValue (positionsMother[i], i, true);
positionsChild[i]=tableGenotypes->getAmbiguousPos (alFather, alMother, i);
}
valueChild=tableGenotypes->getPos(positionsChild);
zaparr(positionsFather);
zaparr(positionsMother);
zaparr(positionsChild);
result->insertElement(valueChild);
}
return result;
}
/*_______________________________________________________________*/

TrioCounters*TrioCounters::getPermutation()
{
//if (Bayes!=MLE) throw BadFormat("TrioCounters<T>::getPermutation()");
longLongList
* tempGenotypeCountsFather=permuteInParent(true),
* tempGenotypeCountsMother=permuteInParent(false);


TrioCounters* result=clone();
zap(result->genotypeCountsFather);
zap(result->genotypeCountsMother);
result->genotypeCountsFather=tempGenotypeCountsFather;
result->genotypeCountsMother=tempGenotypeCountsMother;
//zap(result->genotypeFreqs);
//zap(result->genotypeAbsFreqsTab);
//result->setGenotypeFreqs();
//result->setGenotypeAbsFreqs();
return result;
}
/*_______________________________________________________________*/

 void TrioCounters::setTotalGenotypes()
{
longLongList* l;
totalGenotypes=0;
for (int parent=0; parent<2; parent++)
{
if (parent==0) l=genotypeCountsFather; else genotypeCountsMother;
for (longLongList::iterator it=l->begin(); it<l->end(); it++)
if (l->getElement(it)>=0) totalGenotypes++;
}
}
/*_________________________________________________________________*/

 void TrioCounters::set(TrioSample* sample, int affectation, int* pos)  throw (OutOfRange<long long int>)
{
setTotalAlleles(sample, pos);
setGenotypeTableDimensions();
setCounters(sample, affectation, pos);
//setGenotypeTable();
setTotalGenotypes();
setSNPFreqs();
}


/*_________________________________________________________________*/

 void TrioCounters::setTotalAlleles(TrioSample* sample, int* pos)
{

totalAlleles=Initialize(totalPos, 0);

for (int i=0; i<totalPos; i++)
{
//cout << "\npos at " << i << ": " << pos[i];
 totalAlleles[i]=sample->genotypeSample->totalAlleles[pos[i]];
//cout << "\nptotal " << i << ": " << totalAlleles[i];
//if (totalAlleles[i]==0) {cout <<"bad\n"; exit(0);}
}
}
/*____________________________________________________________ */

void TrioCounters::setCounters (TrioSample* sample, int affectation, int*pos)  throw (OutOfRange<long long int>)
{
genotypeCountsFather=sample->getGenotypeCounts(pos, totalPos, father, affectation, everyGender, tableGenotypes, false, includeMissing);
genotypeCountsMother=sample->getGenotypeCounts(pos, totalPos, mother, affectation, everyGender, tableGenotypes, false, includeMissing);
fatherPedigrees=sample->getPedigreeID(father);
motherPedigrees=sample->getPedigreeID(mother);

//cout <<"mother gens:\n" << *genotypeCountsMother;
}



};  // End of Namespace

#endif

/* End of file: TrioCounters.h */




