/* File: MultimarkerMeasure.h */

#ifndef __TrioCountersHapUAndT_h__
#define __TrioCountersHapUAndT_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/



typedef HeteroPair<double, long long int> FreqAndKey;
typedef Vector<FreqAndKey*>::Class FreqAndKeyVector;


 
class	TrioCountersHapUAndT {



//MultimarkerMeasureHap<TrioSample> *multimarkerMeasureTransmitted, *multimarkerMeasureUntransmitted;

public:

bool onlyHetero;
PhaseAlg phaseAlg;
EMDistributions emDistributions;
EMRestriction emRestriction;

TrioCounters* trioCounters;
FreqAndKeyVector* hapByFreqs, *hapByFreqsT, *hapByFreqsU;

	   double** SNPAbsFreqsFatherT, **SNPAbsFreqsFatherU, ** SNPAbsFreqsMotherT, **SNPAbsFreqsMotherU;

//   double** SNPFreqs;

int minFreq;

ParentalHaplotypeList* haplotypeCounts; // the number of parental haplotypes is the same of the number of trios for phaseAlg= onlyKnown or phaseAlg=maxFreq. For phaseAlg=weighted, there can be more parental haplotypes than the number of trios 

string printTotalUsedDifferentHaplotypesInG(Transmission trans);

double totalMeiosis, totalDifferentHaplotypes, totalUsedDifferentHaplotypes, totalUsedHaplotypes;

MultidimensionalEmptyTable<int>* haplotypeTable;


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:



	TrioCountersHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool includeMissing=true, bool onlyHetero=true, int minFreq=10)  throw (OutOfRange<long long int>, OutOfRange<int>, NoMemory, BadFormat);
	
 TrioCountersHapUAndT(TrioCountersHapUAndT& source);
 
TrioCountersHapUAndT(TrioCounters* source, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool onlyHetero=true, int minFreq=10);

 TrioCountersHapUAndT();

 void set(TrioCountersHapUAndT& source);
long long int getHapAtPosition (int hapPosition=1, Transmission transmissionHapPosition=t);

void setHapByFreqs();

void setSNPFreqs();

void setHaplotypeCounts();
Pair<Pair<MultidimensionalTable<double>*>*>*  getKnownHaplotypeFreqs();
long long int getHap(const long long int value, bool left);
Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab() throw (NoMemory, BadFormat);
double getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother);
ParentalHaplotypes* getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration);
double getCurrentFrequency(Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother, ParentalHaplotypes *parentalHaplotype);
Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes) throw (NoMemory, BadFormat);
MultidimensionalTable<double>* getInitialEstimation(int type);
double getIndependentLociFrequency (long long int key);
 ~TrioCountersHapUAndT()
{
empty();
	};

void normalizeFreqs(double total);

void empty ();

doubleList* getWeightsInWTDT(IndCategory ic, int type=0);

double getTotalHeteroGenotypes (IndCategory ic);

//virtual void setHaplotypeFreqs()=0;


void setTotalHaplotypes();

BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic=parent);

int getHapPositionByFreq (long long int hapCode, Transmission transmissionHapPosition);

int getTotalDifferentPhasing (int trioCount);

double getTotalUsedDifferentHaplotypesInG1();

double getTotalUsedHaplotypesInG1();

 TrioCountersHapUAndT* clone();

double getLengthMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U);

 void setHaplotypeTable();

 double getStandardizedSimilarityMeasure (IndCategory ic=parent);

 double getSignedRankTest(bool wilcoxon=true, IndCategory ic=parent);

 double getSimilarityMeasure (IndCategory ic=parent);

double getTotalHaplotypes (long long int hap, Transmission trans, IndCategory ic=parent) throw (BadFormat);

double getTotalMeiosis (long long int hap, long long int hap2, IndCategory ic) throw (BadFormat);

double getTotalHomoGenotypes (long long int hap, IndCategory ic) throw (BadFormat);

double getTotalHeteroGenotypes (long long int hap, IndCategory ic) throw (BadFormat);

double getTest (int testType, IndCategory ic=parent) throw (BadFormat);

TrioCountersHapUAndT* getPermutation(); //{throw NonImplemented("getPermutation");};

double getSquareSB (int type, int hapPosition=1, Transmission transmissionHapPosition=t);

double getSquareSB (int type, Transmission trans, int hapPosition=1, Transmission transmissionHapPosition=t);

double getEntropySB (bool df);

double getEntropySB (bool df, Transmission trans);

double getLinearSB (bool df, Transmission trans);

double getSignedRank (Container<vector<Pair<double>*>, Pair<double> *>* DList, double totalCounts, int testType);

double getEntropySE(bool df);

double getEntropyBasedLD (bool df, Transmission trans);

double getMultimarkerDPrime (int type, bool df);

double getMultimarkerDPrime (int measure, bool df, Transmission trans);

double getDPrime(BidimensionalTable<double> * multiallelicFreqs, int measure, bool df);

double getTDT (IndCategory ic=parent);

double getTTDT (IndCategory ic=parent);

double getUTDT (IndCategory ic=parent);

double getSimpleTDT(IndCategory ic=parent, int hapPosition=1, Transmission transmissionHapPosition=ut);

double getAbsVarTDT (IndCategory ic=parent);

double getSquareVarTDT (IndCategory ic=parent);

double getSNPAbsVarTDT (IndCategory ic=parent);

double getSNPSquareVarTDT (IndCategory ic=parent);

double getSNPSquareCorrectedVarTDT (IndCategory ic=parent);

double getNTDT (IndCategory ic=parent);

double getWTDT (IndCategory ic=parent) throw (NonDefined);

double getWWTDT (IndCategory ic=parent) throw (NonDefined);

double getEntropyTDT (IndCategory ic=parent);

double getGenericTDT (int test, IndCategory ic=parent, bool oneHap=false, int hapPosition=1, Transmission transmissionHapPosition=t, double alpha=0.0);

double getNEntropyTDT (IndCategory ic=parent);

double getSquareHapProbs (bool df, Transmission trans);

double getYateTDT (double alpha=1, bool basicYate=true, IndCategory ic=parent);

double getLaplaceTDT (double alpha=1, IndCategory ic=parent);

double getGrouping (IndCategory ic=parent);

long long int getMaxTDTDiff(Transmission trans);

double getSimpleEntropyTDT (IndCategory ic=parent, int hapPosition=1, Transmission transmissionHapPosition=ut);

int getPositionForHap (long long int hap, Transmission transmissionHapPosition);

int solve_logreg_tdt(dv2d &trials,dv2d &successes,dv2d &design,dv2d &beta,
  dv2d &SE,dv2d &corr,dv2d &fitted,double *ln_like0,double *ln_like1,double tol);

double getLogTDT(IndCategory ic=parent);

//HeteroListPair<long long int, double>* getComposedList(longLongList *fatherHaps, longLongList* motherHaps);

//double getSignedTDT ();

//TrioCountersHapUAndT * getPermutation ();

};  // End of class MultimarkerMeasure




ostream& operator<<(ostream& out, TrioCountersHapUAndT& pm)
       {
if (pm.trioCounters!=NULL)
   out << *pm.trioCounters <<"\n";

if (pm.haplotypeCounts!=NULL)
   out << *pm.haplotypeCounts << "\n";

return out;
};

/*______________________________________________________*/
/*
 template<> ParentalHaplotypeList::iterator ParentalHaplotypeList::removeNode(ParentalHaplotypeList::iterator it) 
{
return erase(it);//this->getNext(it);
//cout << "insiderem\n";
//return this->erase(it);
};
/*______________________________________________________*/



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




