/* File: TrioPhenotype.h */


#ifndef __TrioPhenotype_cpp__
#define __TrioPhenotype_cpp__





namespace BIOS {


/************************/
/* SNP'S PhenotypePointer DEFINITION */
/************************/
ostream& operator<<(ostream& out, TrioPhenotype& trioPhenotype)
       {

out << *trioPhenotype.phenotypeSample->getElement(trioPhenotype.FatherPhenotype) <<"\n";
out << *trioPhenotype.phenotypeSample->getElement(trioPhenotype.MotherPhenotype) <<"\n";
out << *trioPhenotype.phenotypeSample->getElement(trioPhenotype.ChildPhenotype) <<"\n";;
return out;
};

/**
        @memo PhenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TrioPhenotype::TrioPhenotype (PhenotypeSample* phenotypeSample)
{
this->phenotypeSample=phenotypeSample;
}

/*____________________________________________________________ */

TrioPhenotype::TrioPhenotype (PhenotypeSample* phenotypeSample, PhenotypePointer FatherP,  PhenotypePointer  MotherP,  PhenotypePointer ChildP)
{
this->phenotypeSample=phenotypeSample;
try
{
if (FatherP==phenotypeSample->end() || MotherP==phenotypeSample->end() || ChildP==phenotypeSample->end())
 throw NullValue();
}
 catch (NullValue nv) {nv.PrintMessage(" Trio::constructor");}

FatherPhenotype=FatherP;
MotherPhenotype=MotherP;
ChildPhenotype=ChildP;
}

/*____________________________________________________________ */

PhenotypePointer TrioPhenotype::GetFatherPhenotype ()
{
	return FatherPhenotype;
}
/*____________________________________________________________ */

PhenotypePointer TrioPhenotype::GetMotherPhenotype ()
{
	return MotherPhenotype;
}
/*____________________________________________________________ */

PhenotypePointer TrioPhenotype::GetChildPhenotype ()
{
	return ChildPhenotype;
}
/*____________________________________________________________ */

PhenotypePointer TrioPhenotype::GetPhenotype (IndCategory ic)
{
int i=(int) ic;
switch (ic)
{
case 0: // father 
 return FatherPhenotype;
case 1: // mother
 return MotherPhenotype;
case 2: // child
 return ChildPhenotype;
default: throw NullValue("TrioPhenotype::GetPhenotype (IndCategory ic)");
}
}
/*____________________________________________________________ */

void TrioPhenotype::SetFatherPhenotype (PhenotypePointer phenotype)
{
FatherPhenotype=phenotype;
}
/*____________________________________________________________ */

void TrioPhenotype::SetMotherPhenotype (PhenotypePointer phenotype)
{
MotherPhenotype=phenotype;
}/*____________________________________________________________ */

void TrioPhenotype::SetChildPhenotype (PhenotypePointer phenotype)
{
ChildPhenotype=phenotype;
}

/*______________________________________________________*/



};  // End of Namespace

#endif

/* End of file: PhenotypePointer.h */




