/* File: TrioGenotype.h */


#ifndef __TrioSNPGenotype_cpp__
#define __TrioSNPGenotype_cpp__





namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TrioSNPGenotype::TrioSNPGenotype ()
{
}

/*____________________________________________________________ */

TrioSNPGenotype::TrioSNPGenotype (Diplotype  FatherG, Diplotype  MotherG, Diplotype  ChildG, allele majorAllele)
{
fatherGenotype=FatherG;
motherGenotype=MotherG;
childGenotype=ChildG;
this->majorAllele=majorAllele;
}
/*____________________________________________________________ */

TrioSNPGenotype::TrioSNPGenotype (TrioGenotype* trio, SNPPos SNP)
{
fatherGenotype=(*trio->genotypeSample->getElement(trio->GetFatherGenotype())->GetGenotype())[SNP];
motherGenotype=(*trio->genotypeSample->getElement(trio->GetMotherGenotype())->GetGenotype())[SNP];
childGenotype=(*trio->genotypeSample->getElement(trio->GetChildGenotype())->GetGenotype())[SNP];
majorAllele=trio->genotypeSample->allAlleles[SNP][0];
}

/*____________________________________________________________ */

int TrioSNPGenotype::getInconsistencies ()
{
CoupleSNPGenotype* coupleGenotype=new CoupleSNPGenotype(fatherGenotype, motherGenotype);
//cout <<"next\n ";


if (!fatherGenotype.IsAMissingSNP() &&
!motherGenotype.IsAMissingSNP() &&
!childGenotype.IsAMissingSNP())
{
if (
	 ((coupleGenotype->IsHomozygous1Heterozygous (majorAllele)) && (childGenotype.IsHomozygous2(majorAllele)))
	  ||
	  ((coupleGenotype->IsHomozygous2Heterozygous(majorAllele)) && (childGenotype.IsHomozygous1(majorAllele))) 
	  ||
	  ((coupleGenotype->IsHomozygous1Homozygous1 (majorAllele)) &&  (childGenotype.IsHeterozygous(majorAllele)))
          ||
	  ((coupleGenotype->IsHomozygous2Homozygous2 (majorAllele)) &&  (childGenotype.IsHeterozygous(majorAllele)))
          ||
	  ((coupleGenotype->IsHomozygous1Homozygous2 (majorAllele)) && ((childGenotype.IsHomozygous1(majorAllele)) || (childGenotype.IsHomozygous2(majorAllele))))		  
     )
	
	/*		if (1==2)
{
				cout <<"\nInconsistence at ind " 
				<< Pos+1 << " SNP " << SNP+1 << " val file: " 
				
				<< T->GetChildGenotype()->element->GetLeftAllele(SNP) <<T->GetChildGenotype()->element->GetRightAllele(SNP) 
				<< "( " ;
				cout << T->GetChildPhenotype()->element.PrintPhenotype() ;
				cout << ") with parents "; 
				cout << T->GetFatherPhenotype()->element.PrintPhenotype() ;
				cout << " and " ;
				cout << T->GetMotherPhenotype()->element.PrintPhenotype() ;
				cout 
 				<< " with father "
				<< T->GetFatherGenotype()->element->GetLeftAllele(SNP) 
				<< T->GetFatherGenotype()->element->GetRightAllele(SNP) 
				<< " and mother " 
				<< T->GetMotherGenotype()->element->GetLeftAllele(SNP) 
				<< T->GetMotherGenotype()->element->GetRightAllele(SNP) ; 
}
*/
return 1;			

if (
	   ((coupleGenotype->IsHomozygous1Homozygous1 (majorAllele)) && (childGenotype.IsHomozygous2(majorAllele))) 
          ||
	  ((coupleGenotype->IsHomozygous2Homozygous2 (majorAllele)) && (childGenotype.IsHomozygous1(majorAllele)))
     )
return 2;

}
return 0;
}
/*____________________________________________________________ */

Diplotype TrioSNPGenotype::getFatherGenotype ()
{
	return fatherGenotype;
}
/*____________________________________________________________ */

Diplotype TrioSNPGenotype::getMotherGenotype ()
{
	return motherGenotype;
}
/*____________________________________________________________ */

void TrioSNPGenotype::setFatherGenotype (Diplotype genotype)
{
fatherGenotype=genotype;
}
/*____________________________________________________________ */

void TrioSNPGenotype::setMotherGenotype (Diplotype genotype)
{
motherGenotype=genotype;
}/*____________________________________________________________ */

void TrioSNPGenotype::setChildGenotype (Diplotype genotype)
{
childGenotype=genotype;
}
/*____________________________________________________________ */

Diplotype TrioSNPGenotype::getChildGenotype ()
{
	return childGenotype;
}

ostream& operator<<(ostream& out,TrioSNPGenotype& trio)
{
Diplotype f=trio.getFatherGenotype();
Diplotype m=trio.getMotherGenotype();
Diplotype c=trio.getChildGenotype();
out << f<<"\n";
out << m <<"\n";
out << c <<"\n";
return out;
  }




};  // End of Namespace

#endif

/* End of file: GenotypePointer.h */




