/* File: TrioSample.h */


#ifndef __TrioSample_cpp__
#define __TrioSample_cpp__

//#include <string.h>
//#include <cstdio>


//#include "GenomaSample.cpp"

//#include "CoupleGenotype.h"
namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/
template <> Trio* Container<vector<Trio*>, Trio*>::readElement (ifstream * source, const char* tokens, int* pos, int size){
cout << "Trio* Container<vector, Trio*>::readElement not implemented  yet";
end();
};

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// privates /////////////
 /*____________________________________________________________ */

void TrioSample::InitializeTrioSample ()
{
if (TrioList!=NULL)
{
if (genotypeSample!=NULL)
{
if (solveMIUsingChildren) solveMendelianInconsistenciesUsingChildren();
CheckInconsistenciesFromParents();
if (CompleteMissing) completeMissing();

}
if (phenotypeSample!=NULL && genotypeSample!=NULL)
{
 IndPos TotalInds=phenotypeSample->size();
 setMarked(parent);
 genotypeSample->setAllAlleles(Marked);	
 switch (genotypeSample->AlleleOrderMode)
 {
 case NotChanged: break;
 case MajorFirst: break; // already done in GenotypeSample
 case random: break;
 case LeftRight: 
 case LeftRightUsingTrios: 
OrderLeftRight();
break;
 };	
}	
}
}
/*____________________________________________________________ */

void TrioSample::CreateTrioList ()
{

 Trio *T; //=new Trio(phenotypeSample, genotypeSample);
 if (genotypeSample!=NULL)
 {
 TrioList=new Container<vector<Trio*>, Trio*>();
 GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
 PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
 while (IndGenotype!=genotypeSample->end() && IndPhenotype!=phenotypeSample->end())
  {
//cout <<"next\n";   
if (phenotypeSample->getElement(IndPhenotype)->IsAFather())
   {
//cout <<"here\n";
//cout << "F: " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";


   T=GetTrioMembers(IndPhenotype, IndGenotype);
  // cout <<*T <<"\n";
   TrioList->insertElement(T);
   }
//else cout <<"non a father\n";
// if (phenotypeSample->getElement(IndPhenotype)->IsAMother())
//  cout << ":M " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";


   IndGenotype=genotypeSample->getNext(IndGenotype);
   IndPhenotype=phenotypeSample->getNext(IndPhenotype);
 }
//cout <<"end\n";
//exit(0);
}
//cout <<"las\n";
}
/*__________________________________________________________________*/

void TrioSample::OrderLeftRight ()
{
int cont=0;
if (TrioList!=NULL)
{
// order alleles in the trio for offspring to be consistent with parents
  Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
  Genoma* G;
  SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();

while (TrioPos!=TrioList->end())
  {
   for (unsigned short int i=0;i<3;i++)
   {	 
   G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)i);
   for (SNPPos SNP=0; SNP<TotalSNPs;SNP++)
 if (genotypeSample->AlleleOrderMode==LeftRightUsingTrios)
{
if (G->getDiplotype(SNP)->IsANonMissingSNP())
    if (G->CanBeInferred(SNP, NotChanged)) // if not missing and at least one person is homozygotic
	{
  	 if (G->MustBeChanged(SNP))
	  G->ChangeAlleles(SNP);
	}
	else if (G->getDiplotype(SNP)->IsHeterozygous()) G->markAlleles(SNP);
   }
else // LeftRight
{
if (!allowRecombination)
{
if ((IndCategory)i==offspring) 
{
if (G->getDiplotype(SNP)->getLeftAllele()!=G->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)->getLeftAllele())
{
cout << *G->getDiplotype(SNP) << " and parent: " << *G->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP);
cout <<"\nfamily:" << cont+1 <<" and SNP: " << SNP+1;
throw Inconsistent("TrioSample::OrderLeftRightFather");
}
//G->ChangeAlleles(SNP);
if (G->getDiplotype(SNP)->getRightAllele()!=G->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP)->getLeftAllele())
{
cout << *G->getDiplotype(SNP) << " and parent: " << *G->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);
cout <<"\nfamily:" << cont+1 <<" and SNP: " << SNP+1;
throw Inconsistent("TrioSample::OrderLeftRightMother");
}
}
}
//G->ChangeAlleles(SNP);

}
zap(G);
   }
   TrioPos=TrioList->getNext(TrioPos);
cont++;
  }

 //   cout <<"Sorting left right has finished\n";
}
}
///////////////////
//// public ////////
///////////////////


TrioSample* TrioSample::clone()
{
return new TrioSample((TrioSample&)*this, this->CompleteMissing);
}
 
/***************************************************/

TrioSample::~TrioSample ()
{
zap(TrioList); 
zaparr(line); 
zaparr(inconsistencies);
zaparr(nonHeteroParents); 
zaparr(parentsNotInHWE); 
zaparr(childrenNotInHWE);
};

/***************************************************/

TrioSample::TrioSample(char* filename, int*pos, int size, AlleleOrderType AlleleOrderMode, bool CompleteMis, bool allowRecombination, bool solveMIUsingChildren): GenomaSample(filename, pos, size, parent, AlleleOrderMode) 
{
this->solveMIUsingChildren=solveMIUsingChildren;
line=NULL;
TrioList=NULL;
CompleteMissing=CompleteMis;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
this->allowRecombination=allowRecombination;
CreateTrioList();
InitializeTrioSample();
}

/*____________________________________________________________ */

TrioSample::TrioSample (TrioSample& source, Container<set<SNPPos>, SNPPos>* Sampling): GenomaSample(source)
{

line=NULL;
 TrioList=NULL;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
allowRecombination=source.allowRecombination;
if (1==0)
if (source.genotypeSample!=NULL && source.genotypeSample->AlleleOrderMode==LeftRightUsingTrios)
{
cout <<" Not available at TrioSample::TrioSample (GenomaSample& Source, intList* Sampling)";
exit(0);
}
int pos=0;

CompleteMissing=source.CompleteMissing;
solveMIUsingChildren=source.solveMIUsingChildren;
CreateTrioList();
if (genotypeSample!=NULL)
InitializeTrioSample();
if (Sampling!=NULL)
{
Trio*T;
intList *trioP, *trioG; 
for (int i=TrioList->size()-1; i>=0; i--)
if (Sampling->findElement(i)==Sampling->end())
{
T=TrioList->getElement(i);
trioP=new intList();
trioG=new intList();
if (T->getFatherGenotype()==genotypeSample->end()) cout <<"fathernul\n";
trioG->insertElement(genotypeSample->getPosition(T->getFatherGenotype()));
trioG->insertElement(genotypeSample->getPosition(T->getMotherGenotype()));
trioG->insertElement(genotypeSample->getPosition(T->getChildGenotype()));
order(trioG,false);
trioP->insertElement(phenotypeSample->getPosition(T->getFatherPhenotype()));
trioP->insertElement(phenotypeSample->getPosition(T->getMotherPhenotype()));
trioP->insertElement(phenotypeSample->getPosition(T->getChildPhenotype()));
order(trioP,false);
for (int c=0; c<3; c++)
{
	genotypeSample->removeNode(trioG->getElement(c));
	phenotypeSample->removeNode(trioP->getElement(c));
}
	TrioList->removeNode(i);
delete(trioG);
delete trioP;
}
if (currentIc!=nobody) 
setMarked(currentIc); 
};
}
/*____________________________________________________________ */

TrioSample::TrioSample (GenomaSample& Source, bool CompleteMis): GenomaSample(Source)
{
line=NULL;
TrioList=NULL;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
solveMIUsingChildren=false;

/*
if (Source.genotypeSample->AlleleOrderMode==LeftRightUsingTrios)
{
cout <<" Not available at TrioSample::TrioSample (GenomaSample& Source, bool CompleteMis)";
exit(0);
}
*/
 
 CompleteMissing=CompleteMis;
CreateTrioList();
if (genotypeSample!=NULL)
InitializeTrioSample();
}
/*____________________________________________________________ */

TrioSample::TrioSample (PhenotypeSample& SourceP, GenotypeSample& SourceG): GenomaSample(SourceP, SourceG)
{
 line=NULL;
 TrioList=NULL;
 //ic=i;
 CompleteMissing=true;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
solveMIUsingChildren=false;
 CreateTrioList();
 InitializeTrioSample();
}
/*____________________________________________________________ */

TrioSample* TrioSample::setAffectationRandomly ()
{
GenomaSample* genomaSample=GenomaSample::setAffectationRandomly();
TrioSample* trioSample=new TrioSample(*genomaSample, this->CompleteMissing);
zap(genomaSample);
return trioSample;
}


/*____________________________________________________________ */

TrioSample* TrioSample::permute ()
{
TrioSample* trioSample=this->clone();
if (trioSample->TrioList==NULL || trioSample->genotypeSample==NULL  || (trioSample->genotypeSample->AlleleOrderMode!=LeftRight && trioSample->genotypeSample->AlleleOrderMode!=LeftRightUsingTrios)) return trioSample; 
Container<vector<Trio*>, Trio*>::iterator TrioPos=trioSample->TrioList->getFirst();
Genoma*childG, *G;
SNPPos TotalSNPs=trioSample->genotypeSample->GetTotalSNPs();
int recomb;
while (TrioPos!=trioSample->TrioList->end())
  {
   for (unsigned short int i=0;i<2;i++) // only for parents
   {	 
   recomb=ranbinom(1, 0.5);
   if (recomb)
   {
   childG=new Genoma(trioSample->TrioList->getElement(TrioPos), offspring);
	G=new Genoma(trioSample->TrioList->getElement(TrioPos), (IndCategory)i);
   for (SNPPos SNP=0; SNP<TotalSNPs;SNP++)
{
    if (G->CanBeInferred(SNP, NotChanged)) // if not missing and at least one person is homozygotic
    if (G->getGenotype()->isHeterozygous(SNP)) 
	 {
/*
if (i==1)
{
cout <<"\bfefore SNP:"  << SNP << "\n:";
cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);

cout <<"\n";
}
*/
   childG->changeTransmittedAlleles(SNP, !i);
/*
if (i==1)
{
cout <<"\nafter\n:";
cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);
cout <<"\n";
exit(0);
}
*/
}

   }
  zap(childG);
zap(G);
}
   }
   TrioPos=trioSample->TrioList->getNext(TrioPos);
   }
return trioSample;
}
/*____________________________________________________________ */

void TrioSample::CheckParentsHWE ()
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
double observed[2], expected[2];
if (parentsNotInHWE==NULL) parentsNotInHWE=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
observed[0]=GetTotalAllele (SNP, (allele)1, father);
observed[1]=GetTotalAllele (SNP, (allele)1, mother);
expected[0]=(observed[0]+observed[1])/(double)2;
expected[1]=(observed[0]+observed[1])/(double)2;
if (chiTest(observed, expected, 1)<0.05) parentsNotInHWE[SNP]=1;
}
}
/*____________________________________________________________ */

void TrioSample::CheckChildrenHWE ()
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
if (childrenNotInHWE==NULL) childrenNotInHWE=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
if (parentsNotInHWE==NULL || parentsNotInHWE[SNP]==0)
{
if (getChildrenHWETest(SNP)<0.05) childrenNotInHWE[SNP]=1;
}
else childrenNotInHWE[SNP]=2;
}

/*____________________________________________________________ */

double TrioSample::getChildrenHWETest (SNPPos SNP)
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
double observed[3], expected[3], allele[2];
double allele1, allele2, total1, total2;
observed[0]=GetTotalHomozygous1 (SNP, offspring);
observed[1]=GetTotalHomozygous2 (SNP, offspring);
observed[2]=GetTotalHeterozygous (SNP, offspring);
total1=observed[0]+observed[1]+observed[2];
//if (total1==0) throw NanValue("TrioSample::getChildrenHWETest");
allele[0]=GetTotalAllele (SNP, genotypeSample->allAlleles[SNP][0], parent);
allele[1]=GetTotalAllele (SNP, genotypeSample->allAlleles[SNP][1], parent);
total2=allele[0]+allele[1];
expected[0]=total1*std::pow(allele[0]/total2,2);
expected[1]=total1*std::pow(allele[1]/total2,2);
expected[2]=total1*(allele[0]/total2)*(allele[1]/total2)*2;
if (expected[0]==0 || expected[1]==0 || expected[2]==0)
throw NanValue(" TrioSample2::getChildrenHWETest");
return chiTest(observed, expected, 2);
}

/*____________________________________________________________ */

int TrioSample::getNonHeteroParents (SNPPos SNP)
{
int nonHeteroParents=0;
Trio *T;
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);

if (!T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->IsAMissingSNP() &&
!T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->IsAMissingSNP() &&
!T->genotypeSample->getElement(T->getChildGenotype())->getDiplotype(SNP)->IsAMissingSNP())
{
 if (!T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->IsHeterozygous())
nonHeteroParents++;
 if (!T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->IsHeterozygous()) nonHeteroParents++;
}
TrioPos=TrioList->getNext(TrioPos);
}	
return nonHeteroParents;
}

/*____________________________________________________________ */

void TrioSample::solveMendelianInconsistenciesUsingChildren ()
{
Trio *T;
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);
if (T->trioGenotype->getInconsistencies(SNP)>0)
T->trioGenotype->solveMIUsingChild(SNP);	
TrioPos=TrioList->getNext(TrioPos);
}	
}
}
/*____________________________________________________________ */

int TrioSample::getInconsistenciesFromParents (SNPPos SNP)
{
Trio *T;
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
int inconsistencies=0;
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);
inconsistencies=inconsistencies+T->trioGenotype->getInconsistencies(SNP);	
TrioPos=TrioList->getNext(TrioPos);
}	
return inconsistencies;
}

/*____________________________________________________________ */

void TrioSample::CheckInconsistenciesFromParents ()
{
//cout << "Checking inconsistencies from parents...\n";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
inconsistencies=Initialize(TotalSNPs, 0);
nonHeteroParents=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
inconsistencies[SNP]=getInconsistenciesFromParents(SNP);
nonHeteroParents[SNP]=getNonHeteroParents(SNP);
}
}
/*____________________________________________________________ */

void TrioSample::completeMissing ()
{
//cout << "\nCompleting missing...";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
Trio *T;
allele MinorAllele;
Diplotype* D, *relative1D, *relative2D;
Genoma* G;
PairGenotype* PG;
while (TrioPos!=TrioList->end())
{
 T=TrioList->getElement(TrioPos);
for (int i=0; i<3; i++)
{
	G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)i);
 PG=G->getPairGenotype();
  for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
  D=G->getGenotype()->getDiplotype(SNP);
relative1D=PG->getFirstGenotype()->getDiplotype(SNP);
relative2D=PG->getSecondGenotype()->getDiplotype(SNP);
  if (D->IsAMissingSNP())
   {

    if (!relative1D->IsAMissingSNP() && relative1D->IsHomozygous2 (genotypeSample->allAlleles[SNP][0]))
		   MinorAllele=relative1D->getLeftAllele();
	else
    if (!relative2D->IsAMissingSNP() && relative2D->IsHomozygous2 (genotypeSample->allAlleles[SNP][0]))
		   MinorAllele=relative2D->getLeftAllele();
   
 if (!relative1D->IsAMissingSNP() && !relative2D->IsAMissingSNP())
{

	if (PG->IsHomozygous1Homozygous1 (SNP, genotypeSample->allAlleles)) 
	   D->setAlleles(genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][0]);

    if (PG->IsHomozygous2Homozygous2 (SNP, genotypeSample->allAlleles)) 
	   D->setAlleles(genotypeSample->allAlleles[SNP][1], genotypeSample->allAlleles[SNP][1]);

    if (PG->IsHomozygous1Homozygous2 (SNP, genotypeSample->allAlleles)) 
       D->setAlleles(genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][1]);
}
  } // end for each missing SNP
}
 zap(G);
}
 TrioPos=TrioList->getNext(TrioPos);
} // end for each trio
//cout <<"\nMissing data have been completed from parents\n";
}

/*__________________________________________________________*/

SNPPos TrioSample::getTotalType (SNPPos SNP, IndCategory ic, int genotypeValue, int gender, int affectation)
{
bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->getTotalType(SNP, genotypeValue, Marked);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHomozygous1 (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMajorAllele(SNP, ic, gender, affectation);
	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele1, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHomozygous2 (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMinorAllele(SNP, ic, gender, affectation);

	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele1, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHeterozygous (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMajorAllele(SNP, ic, gender, affectation);
allele allele2=getMinorAllele(SNP, ic, gender, affectation);
	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele2, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/
/*
SNPPos TrioSample::GetTotalMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
	return GetTotalType (SNP, ic, missing, gender, affectation);
}
/*___________________________________________________________*/
/*
SNPPos TrioSample::GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
	return GetTotalHomozygous1 (SNP, ic, gender, affectation)+GetTotalHomozygous2(SNP, ic)+GetTotalHeterozygous(SNP, ic, gender, affectation);
}
/*__________________________________________________________*/

SNPPos TrioSample::GetTotalAllele (SNPPos SNP, allele allele1, IndCategory ic, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
//for (int i=0;i<GetTotalSNPs();i++)
//cout <<"\n" << Marked[i];
//cout <<"total al:" << genotypeSample->GetTotalAllele(SNP, false, Marked);
//end();
return genotypeSample->GetTotalAllele(SNP, allele1, Marked);
}
/*__________________________________________________________*/

SNPPos TrioSample::GetTotalTrios ()
{
return TrioList->size();
}
/*____________________________________________________________ */
/*
SNPPos TrioSample::GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic=everybody, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->getDoubleHeterozygous(FirstSNP, LastSNP, i, j, Marked);
}
/*____________________________________________________________ */
/*
SNPPos TrioSample::GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool IsPartiallySolved, int gender, int affectation)
{
setMarked(ic, gender, affectation);
IndPos TotalInds=0;
TotalInds=genotypeSample->GetUnsolvedDoubleHeterozygous(FirstSNP, LastSNP, i, j, genotypeSample->AlleleOrderMode, Marked);
//cout <<" totalidns is\n";
//cout  << TotalInds <<" \n" ;
if (TotalInds>0)
{
Container<vector, Trio*>::iterator TrioPos=TrioList->getFirst();
Genoma* G;
Phenotype *phen;
bool coupleAffectation=false;
while (TrioPos!=TrioList->end())
{
for (int k=0; k<=2; k++)
{
if (ic==(IndCategory)k || ic==everybody || (ic==parent && k<2))
{
switch (k)
{
case 0: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype()); 
if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation())
|| affectation==allAffectation) coupleAffectation=true;
break;
case 1: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype()); 
if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
|| affectation==allAffectation) coupleAffectation=true;
break;
case 2: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getChildPhenotype()); 
if (((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
&& (phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation()))
|| affectation==allAffectation) coupleAffectation=true;
break;
}
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
	G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)k);
        if (G->getGenotype()->IsHeterozygousHeterozygous (FirstSNP, LastSNP, i, j, genotypeSample->allAlleles[FirstSNP], genotypeSample->allAlleles[LastSNP], genotypeSample->totalAlleles[FirstSNP], genotypeSample->totalAlleles[LastSNP])) 
	if (G->CanBeInferred(FirstSNP, LastSNP, genotypeSample->AlleleOrderMode) || (gender==everyGender && coupleAffectation && G->CanBePartiallySolved(FirstSNP, LastSNP, IsPartiallySolved)))
	TotalInds--;
	delete G;
}
}
}
TrioPos=TrioList->getNext(TrioPos);
}
}
return TotalInds;
}

/*____________________________________________________________ */

TrioSample* TrioSample::solvePhase (EMDistributions emDistributions, EMRestriction emRestriction, int windowSize)
{
// solve phase assigning that with maxFreq (PhaseAlg=maxFreq)
try
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
bool onlyHetero=false, includeMissing=true;
TrioSample* result=new TrioSample(*this);
TrioCountersHapUAndT*TM=NULL;
int *pos=NULL, size, trioCont=0;
Genotype* G;
Trio* trio;
SNPPos SNP=0, SNP2=0;
ParentalHaplotypes* haplotypes;
int* motherT, *motherU, *fatherT, *fatherU;


for (int i=0; i<(TotalSNPs/windowSize+(TotalSNPs%windowSize>0));i++)
{
trioCont=0;
if (i<TotalSNPs/windowSize) size=windowSize; else size=TotalSNPs-i*windowSize;
pos=new int[size];
for (int j=0; j<size; j++) 
pos[j]=SNP+j;
TM = new TrioCountersHapUAndT (pos, size, result, allAffectation, maxFreq, emDistributions, emRestriction, includeMissing, onlyHetero);

for (Container<vector<Trio*>, Trio*>::iterator it=result->TrioList->getFirst(); it<result->TrioList->end(); it++)
{
haplotypes=TM->haplotypeCounts->getElement(trioCont);
motherT=TM->haplotypeTable->getPositions(haplotypes->motherT);
fatherT=TM->haplotypeTable->getPositions(haplotypes->fatherT);
motherU=TM->haplotypeTable->getPositions(haplotypes->motherU);
fatherU=TM->haplotypeTable->getPositions(haplotypes->fatherU);
for (int ind=0; ind<3; ind++) // father, mother, offspring
{
SNP2=SNP;
G=getGenotype(it, (IndCategory)ind);
for (int j=0; j<size; j++) 
{
switch (ind)
{
case 0: // father
G->SetAlleles(genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], SNP2); break;
case 1: // mother
G->SetAlleles(genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], SNP2); break;
case 2: // offspring
G->SetAlleles(genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][motherT[j]], SNP2); break;
}
SNP2++;
}
}
zaparr(motherT);
zaparr(fatherT);
zaparr(motherU);
zaparr(fatherU);
trioCont++;
if (it==(result->TrioList->end()-1)) SNP=SNP+size;
}
zaparr(pos);
zap(TM);
}
return result;
}
catch (NonImplemented ni){ni.PrintMessage();}
catch (BadFormat bf){bf.PrintMessage();}
catch (NonProb n){n.PrintMessage();}
catch (ORI ori){ cout <<" at TrioSample::solvePhase"; ori.PrintMessage();}
catch (ORD ord){ord.PrintMessage();}
catch (Inconsistent in){in.PrintMessage();}
catch (NullValue nv){nv.PrintMessage();}
catch (NoMemory nm){}
catch (ORLLI e) {e.PrintMessage();};
} 

/*____________________________________________________________ */

Genotype* TrioSample::getGenotype(Container<vector<Trio*>, Trio*>::iterator TrioPos, IndCategory ind)
{
return ((GenotypeSample*)this)->getElement(TrioList->getElement(TrioPos)->getGenotype(ind));
}



/*____________________________________________________________ */

longLongList* TrioSample::getGenotypeCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing)  throw (OutOfRange<long long int>)
{
// It returns a list of the genotype codes of all the individuals in the sample who match ic, gender, affectation, onlyHetero and includeMissing
long long int position;
longLongList* result=new longLongList();
//cout <<"number of trios:" << TrioList->size();
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
Genotype* G;
Phenotype *phen;
int current=0, SNP;
Trio* T;
bool missing;
for (Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++)
{
T=TrioList->getElement(TrioPos);
missing=false;
for (int i=0; i<totalPos; i++)
{
SNP=pos[i];
if (T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->IsAMissingSNP() ||
T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->IsAMissingSNP() ||
T->genotypeSample->getElement(T->getChildGenotype())->getDiplotype(SNP)->IsAMissingSNP())
missing=true;
}
if (!missing || includeMissing)
for (int i=0; i<=2; i++)
{
if (ic==(IndCategory)i || ic==everybody || (ic==parent && i<2))
{
phen=phenotypeSample->getElement(T->getPhenotype((IndCategory)i)); 
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
G=getGenotype(TrioPos, (IndCategory)i);
position=G->getGenotypeCounts(pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, tableGenotypes, genotypeSample->AlleleOrderMode, onlyHetero, includeMissing);   
//cout <<"\npos is "<<position <<" for genotype " << *G;
//if (position>=0) 
result->insertElement(position);
}
}
}
current++;
}
return result;
}

/*____________________________________________________________ */
/*
int TrioSample::CountAlleles (SNPPos SNP, unsigned int Basis[5], IndCategory ic=parent, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->CountAlleles(SNP, Basis, Marked);

}
*/
/*_________________________________________________________________________*/

intList* TrioSample::getPedigreeID(IndCategory ic)
{
intList* result=new intList();
Phenotype* phen;
Trio* T;
for (Container<vector<Trio*>, Trio*>::iterator it=TrioList->begin(); it!=TrioList->end(); it++)
{
T=TrioList->getElement(it);
for (int i=0; i<2;i++)
if (ic==(IndCategory)i || ic==everybody || (ic==parent && i<2))
{
phen=phenotypeSample->getElement(T->getPhenotype((IndCategory)i)); 
result->insertElement(phen->getPedigree());
}
}
return result;
}
/*____________________________________________________________ */

allele TrioSample::getMajorAllele (SNPPos SNP, IndCategory ic=parent, int gender, int affectation)
{
//cout <<GenomaSample::getGenotypeSample->MajorAllele(SNP, ic) <<"";

return GenomaSample::getMajorAllele(SNP, ic, gender, affectation);
}
/*____________________________________________________________ */

allele TrioSample::getMinorAllele (SNPPos SNP, IndCategory ic=parent, int gender, int affectation)
{
//cout <<GenomaSample::getMinorAllele(SNP, ic) <<"\n";
return GenomaSample::getMinorAllele(SNP, ic, gender, affectation);
}

/*____________________________________________________________ */

TrioSample* TrioSample::copyElementsWithPositionsIn(intSet* positions, bool inThis)
{
GenomaSample* genomaResult=this->GenomaSample::copyElementsWithPositionsIn(positions, inThis);
TrioSample* result= new  TrioSample(*genomaResult, false);
zap(genomaResult);
return result;
}

/*____________________________________________________________ */


};
// End of Namespace

#endif

/* End of file: TrioSample.h */




