/* File: TrioSample.h */


#ifndef __TrioSample_h__
#define __TrioSample_h__

//#include <string.h>
//#include <cstdio>


//#include "GenomaSample.cpp"

//#include "CoupleGenotype.h"
namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class TrioSample: public GenomaSample {

	public:
   	Container<vector<Trio*>, Trio*> *TrioList;
	int* inconsistencies, *nonHeteroParents, *parentsNotInHWE, *childrenNotInHWE;

	protected:
    /** @name Implementation of class TrioSample
        @memo Private part.
    */
    	//IndCategory ic;
	char * line;
	bool CompleteMissing;	
    	bool allowRecombination, solveMIUsingChildren;

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

	     void CreateTrioList ();
             void InitializeTrioSample();

		/* PUBLIC FUNCTIONS (INTERFACE) */
      public:

      /** @name Operations on TrioSample 
        @memo Operations on a TrioSample 
    */

TrioSample* clone();
TrioSample* permute();
TrioSample* setAffectationRandomly();
		  TrioSample (PhenotypeSample& SourceP, GenotypeSample& SourceG);

intList* getPedigreeID(IndCategory ic);
TrioSample (GenomaSample& Source, bool CompleteMis=true);

double getChildrenHWETest (SNPPos SNP);
int getNonHeteroParents (SNPPos SNP);
int getInconsistenciesFromParents (SNPPos SNP);

		  TrioSample (TrioSample& source, Container<set<SNPPos>, SNPPos> *Sampling=NULL);
		  TrioSample(char* filename, int*pos=NULL, int size=0, AlleleOrderType AlleleOrderMode=MajorFirst, bool CompleteMiss=true, bool allowRecombination=false, bool solveMIUsingChildren=false); 
		  ~TrioSample ();
		  allele getMajorAllele (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		  allele getMinorAllele (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
	//	void PrintTrios (char* filename);
		void CheckInconsistenciesFromParents ();
		void completeMissing();
		SNPPos getTotalType (SNPPos SNP, IndCategory ic, int genotypePos, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHomozygous1 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHomozygous2 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHeterozygous (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
//		SNPPos GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
//		SNPPos GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool IsPartiallySolved, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalAllele (SNPPos SNP, allele allele1, IndCategory ic, int gender=everyGender, int affectation=allAffectation);

		SNPPos GetAllelePair(SNPPos SNP1, SNPPos SNP2, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		int CountAlleles (SNPPos SNP, unsigned int Basis[5], IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		IndPos GetTotalTrios();
		void OrderLeftRight ();

		TrioSample* solvePhase (EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int windowSize=10);

		void CheckParentsHWE ();
		void CheckChildrenHWE ();

void solveMendelianInconsistenciesUsingChildren ();

longLongList* getGenotypeCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero=false, bool includeMissing=false)  throw (OutOfRange<long long int>);

Genotype* getGenotype(Container<vector<Trio*>, Trio*>::iterator TrioPos, IndCategory ind);

TrioSample* copyElementsWithPositionsIn(intSet* positions, bool inThis=true);

};  // End of class TrioSample

};
// End of Namespace

#endif

/* End of file: TrioSample.h */





