
/* File: UnorderedRepeatedGenomaSample.cpp */


#ifndef __UnorderedRepeatedGenomaSample_cpp__
#define __UnorderedRepeatedGenomaSample_cpp__



#include "UnorderedRepeatedGenomaSample.h"
     
        



namespace BIOS {



/*____________________________________________________________ */

UnorderedRepeatedGenomaSample::UnorderedRepeatedGenomaSample(char* filename, bool  ExistPhen): 
				PhenotypeSample(filename), 
				UnorderedRepeatedGenotypeSample(filename, ExistPhen)

{
};
/*____________________________________________________________ */

void UnorderedRepeatedGenomaSample::PrintOrderedRepeatedGenoma (char* filename, bool PrintPhenotypes)
 {

		
  PhenotypeSample::iterator IndPhenotype=PhenotypeSample::getFirst(); 
  GenotypeSample::iterator IndGenotype=GenotypeSample::getFirst();
  Genotype* genotype;

  try
{
	  OutputFile.open (filename, ifstream::out);
	  if (!OutputFile)
	   throw ErrorFile();
}
catch (ErrorFile NoFile) {
        NoFile.PrintMessage();
      }

while (IndPhenotype!=PhenotypeSample::end() && IndGenotype!=GenotypeSample::end())
  {
   if (PrintPhenotypes)	OutputFile << PhenotypeSample::getElement(IndPhenotype)->PrintPhenotype();

	OutputFile << UnorderedRepeatedGenotypeSample::getElement(IndGenotype)->print();    
	OutputFile << "\n";
    IndGenotype=GenotypeSample::getNext(IndGenotype);
    IndPhenotype=PhenotypeSample::getNext(IndPhenotype);
  }
  OutputFile.close();

cout << "\nInformation about ordered genotype has been saved in file " << filename <<"\n";
 }




};  // Fin del Namespace

#endif

/* Fin Fichero: UnorderedRepeatedGenomaSample.h */
