/* File: UnorderedRepeatedGenotypeSample.h */


#ifndef __UnorderedRepeatedGenotypeSample_h__
#define __UnorderedRepeatedGenotypeSample_h__


//#include "GenotypeSample.cpp"



using namespace std;


namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class UnorderedRepeatedGenotypeSample: public GenotypeSample  {



protected:

	
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */
      /**
         @memo Destroy the vector of SNP genotypes for an individual
	 @doc
           release memory for this vector.

      */



		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



/**
         @memo From file constructor
         @param destino: UnorderedRepeatedGenotypeSample where will be copy
         @param origen: file with genotypes to copy
         @doc
           Make a copy of UnorderedRepeatedGenotypeSample
           Time complexity in time O(1).
        */
		  UnorderedRepeatedGenotypeSample (char * filename, bool ExistePhen);



};  // End of class UnorderedRepeatedGenotypeSample



/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// protected /////////////


///////////////////
//// public ////////
///////////////////


/*____________________________________________________________ */

UnorderedRepeatedGenotypeSample::UnorderedRepeatedGenotypeSample (char * filename, bool ExistPhen=true)
{

//MajorAllele=NULL;

ExistPhenotype=ExistPhen;

if (HasThisExtension(filename, "gen", 3)==false)
{
	cout <<"File gen is required";
	exit (0);
}

cout << "Reading genotypes ...\n";


getInfo(filename, "\t, \n");


cout << "Genotype reading of " << GetTotalSNPs() << " SNPs has finished ...\n";


}



};  // End of Namespace

#endif

/* End of file: UnorderedRepeatedGenotypeSample.h */




