/* File: block.h */


#ifndef __blockCI_cpp__
#define __blockCI_cpp__


namespace BIOS {


/************************/
/* block SNP*/
/************************/


/**
        @memo block

	@doc
        Definition:
        An array SampleValues of Size values

        Memory space: O(size). 

        @author Maria M. Abad
	@version 1.0
*/
 
/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// privates /////////////



/*______________________________________________________________________________*/

struct blockCI::Counters blockCI::GetCounters(SNPPos SNP, SNPPos SNP2, struct blockCI::Counters ci, SNPPos TotalSNPs)
{
int pos[2];
long long int position;
Counters c=ci;
float upperbound, lowerbound;
map<long long int, float>::iterator pointer;

float MinLowStrongLD;

switch (TotalSNPs)
{
 case 2: MinLowStrongLD=MinLowerStrongLD2SNPs; break;
 case 3: if (EuropeanOrAsian==true) MinLowStrongLD=MinLowerStrongLD3SNPsEuropeanAsian; 
		 else MinLowStrongLD=MinLowerStrongLD3SNPsYorubanAfricanA; break;
 default: MinLowStrongLD=MinLowerStrongLD; break;
}

//MinLowStrongLD=MinLowerStrongLD;
pos[0]=SNP;
pos[1]=SNP2;
position=mm->getPos(pos);
pointer=UpperBound->find(position);
if (pointer!=UpperBound->end())
{
   upperbound=pointer->second;
   lowerbound=UpperBound->find(position)->second;
}
else
{
cout <<"error in blockCI::Counters blockCI::GetCounters\n";
exit(0);
upperbound=2;
lowerbound=2;
}

   if (upperbound<=1.0  && lowerbound<=1.0) // Bounds have maxreal if this position is not used
   {
	c.TotalChecked++;
	if (upperbound>MinUpperStrongLD  && lowerbound>MinLowStrongLD) c.TotalStrongLD++;
	else if (upperbound<MaxUpperStrongRecombination) c.TotalStrongRecombination++;
	 	 else  c.TotalInconclusive++;
   }
 return c;
}
/*______________________________________________________________________________*/

Block* blockCI::GetMaxBlock(SNPPos FirstPos, SNPPos LastPos)
{
map<long long int, float>::iterator pointer, pointer2;
long long int position;
int pos[2];
float up, low;
Block *BestBlock;
SNPPos Ini=FirstPos, End=FirstPos, TotalInformative;
float MaxRatio=0, ratio, distance;
SNPPos MaxChecked=0, TotalMarkers, MaxInformative=0;
Counters c;
BestBlock=new Block(Ini, End);
for (SNPPos SNP=FirstPos; SNP<maxi(LastPos+1, FirstPos+1);SNP++)
if (ListUsedSNPs[SNP]==true)
{
 c.TotalStrongLD=0;
 c.TotalStrongRecombination=0;
 c.TotalInconclusive=0;
 c.TotalChecked=0;

 TotalMarkers=1;
 SNPPos trueLast=mini(LastPos, (SNPPos)(SNP+Pos->GetTotalSNPs(0, MaxWidth)-1));
trueLast=mini(trueLast, TotalSNPs-1);
 for (SNPPos SNP2=SNP+1; SNP2<=trueLast;SNP2++)
 {
 distance=poss->GetDistance(SNP, SNP2-1); 

 if (distance<MaxWidth)
 if (ListUsedSNPs[SNP2]==true)
 {
pos[0]=SNP;
pos[1]=SNP2;
position=mm->getPos(pos);
pointer=UpperBound->find(position);
pointer2=LowerBound->find(position);
if (pointer!=UpperBound->end() && pointer2!=LowerBound->end())
{
up=pointer->second;
low=pointer2->second;
 TotalMarkers++;
 if   ((TotalMarkers==2 && EuropeanOrAsian && distance<=minDistance2SNPsEuropeanAsian)
	|| (TotalMarkers==2 && !EuropeanOrAsian && distance<=minDistance2SNPsAfrican)
	|| (TotalMarkers==3 && EuropeanOrAsian && distance<=minDistance3SNPsEuropeanAsian)
	|| (TotalMarkers==3 && !EuropeanOrAsian && distance<=minDistance3SNPsAfrican)
	|| (TotalMarkers==4 && distance<=minDistance4SNPs)
	|| (TotalMarkers>=5))
if (up>MinUpperStrongLD  && 
 low>MinLowerStrongLD) 
 {
  c=GetCounters(SNP, SNP2, c, TotalMarkers);
  TotalInformative=c.TotalStrongLD + c.TotalStrongRecombination;
  if ((TotalMarkers<=4 && c.TotalStrongLD==c.TotalChecked) || (TotalMarkers >4 && TotalInformative>=6))
  {
  if ((c.TotalStrongLD/(float)TotalInformative)>MinStrongOverInformative || TotalMarkers<5)
  if (c.TotalChecked>=MaxChecked)
  {
	MaxChecked=c.TotalChecked;
	Ini=SNP;
	End=SNP2;
  }
  }
  }
}
 }
 }
}
TotalMarkers=End-Ini+1;
BestBlock->set(Ini, End);
return BestBlock;




}
/*********************************************************************/
void blockCI::AddBlock(SNPPos FirstPos, SNPPos LastPos)
{
Block *OneBlock=GetMaxBlock(FirstPos, LastPos);
insertElement(OneBlock);
//cout <<"over\n";
//cout <<"First pos:" << FirstPos <<", LastPos: " << LastPos << "blockini: " << OneBlock->IniPos <<", block end: " << OneBlock->LastPos << ", totalsnps:" << TotalSNPs <<"\n";
if (FirstPos<(OneBlock->IniPos)) AddBlock(FirstPos,OneBlock->IniPos-1);
if (OneBlock->LastPos<(TotalSNPs-1))
if (LastPos>(OneBlock->LastPos)) AddBlock(OneBlock->LastPos+1, LastPos);
}
/*********************************************************************/


///////////////////
//// public ////////
///////////////////


blockCI::blockCI(Positions* Pos, map<long long int, float> * UpperB, map<long long int, float> * LowerB, SNPPos TotalS, float MaxW, bool EurOrAs=true, bool * UsedSNPs=NULL, SNPPos firstSNP=0, SNPPos lastSNP=-1):BlockList()
{
//cout << *UpperB <<"\n";
//cout << *LowerB <<"\n";
intList*dimList=new intList();
dimList->insertElement(TotalS);
dimList->insertElement(TotalS);
mm=new MultidimensionalEmptyTable<int>(dimList);
zap(dimList);
this->Pos=Pos;
//TableCounters=NULL;
ListUsedSNPs=&UsedSNPs[0];
poss=Pos;
EuropeanOrAsian=EurOrAs;
UpperBound=UpperB;
LowerBound=LowerB;
TotalSNPs=TotalS;
MaxWidth=MaxW;
SNPPos lastPos=TotalSNPs-1;
if (lastSNP!=-1) lastPos=lastSNP; 
AddBlock(firstSNP, lastPos);
order((Container<vector<Block*>, Block*>* const &)this, true);
zap(dimList);
}
/*********************************************************************/

blockCI::~blockCI()
{
zap(mm);
}

};  // End of Namespace

#endif

/* End of file: blockCI.h */




