/* File: block.h */


#ifndef __blockCI_h__
#define __blockCI_h__




#define MinUpperStrongLD 0.98
#define MinLowerStrongLD 0.7
#define MinLowerStrongLD2SNPs 0.8
#define MinLowerStrongLD3SNPsEuropeanAsian 0.5
#define MinLowerStrongLD3SNPsYorubanAfricanA 0.75
#define MaxUpperStrongRecombination 0.9
#define MinStrongOverInformative 0.95
#define minDistance2SNPsEuropeanAsian 20000.0
#define minDistance2SNPsAfrican 10000.0
#define minDistance3SNPsEuropeanAsian 30000.0
#define minDistance3SNPsAfrican 20000.0
#define minDistance4SNPs 30000.0


namespace BIOS {


/************************/
/* block SNP*/
/************************/


/**
        @memo block

	@doc
        Definition:
        An array SampleValues of Size values

        Memory space: O(size). 

        @author Maria M. Abad
	@version 1.0
*/
 class blockCI : public BlockList
 {

 

protected:
    /** @name Implementation of class block
        @memo Private part.
    */
Positions* Pos;
struct Counters
	{
	SNPPos TotalStrongLD;
	SNPPos TotalStrongRecombination;
	SNPPos TotalInconclusive;
	SNPPos TotalChecked;
	};

MultidimensionalEmptyTable<int>* mm;

	//map<long long int, Counters> *TableCounters;
	map<long long int, float> *UpperBound, *LowerBound;

    bool EuropeanOrAsian;

	Positions* poss;

	Block* GetMaxBlock(SNPPos FirstPos, SNPPos LastPos);

	void AddBlock(SNPPos FirstPos, SNPPos LastPos);

	struct Counters GetCounters(SNPPos SNP, SNPPos SNP2, struct Counters ci, SNPPos TotalSNPs);


	//void InitializeTableCounters();


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      
/* PUBLIC FUNCTIONS (INTERFACE) */

    public:

	blockCI(Positions *Pos, map<long long int, float> * UpperB, map<long long int, float> * LowerB, SNPPos TotalS, float MaxW, bool EurOrAs, bool *UsedSNPs, SNPPos firstSNP, SNPPos lastSNP);

	~blockCI();//if (TableCounters!=NULL) delete TableCounters;};


};  // End of class block



};  // End of Namespace

#endif

/* End of file: blockCI.h */




