/* File: GBN.h */


#ifndef __GBN_h__
#define __GBN_h__




//using namespace std;

namespace BIOS
{


  /************************/
  /* GBN DEFINITION */
  /************************/


  /**
          @memo GBN 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */


  class GBN
  {


  
  private:
  

	Clique *clique;

   int totalAttributos;
    
   
    void createClique();
    void init();

  protected:

	intMLSample* discreteSample;
  
  //double* getProbs(intList* selectedAtts, PotentialList* potentialList, intList* inputPattern);

      floatList* algorithm;

    bool directMethod;
    
    UndirectedBN* undirectedBN;

    float alpha;

	BayesType bayesType;

//floatList* positions;

    VerbosityClass *verbosity;

    intList** parents; // it is an array of pointers to lists of integers

public:    CPT** probTables; // it is an array of pointers to ProbabilityMeasures

  protected:   void setParents();


  void setParents(AlgTypeClassBN algBN);

    bool isSet();


    double getAttributeProb(int att, intList* inputPattern);

    void setUndirectedBN(VerbosityClass* verbosity);
    
     PotentialTable* marginalize(intList* vars, PotentialList* cliquePotentials,  intList* inputPattern, PotentialList::iterator p, PotentialList::iterator p2);

	intList* addMissingVarList(intList* vars, PotentialTable* pT, intList* inputPattern);

    /* PUBLIC FUNCTIONS (INTERFACE) */


  floatList* getAlphaNumerators(int att, intList* totalMarginals, float alphaDenominator);
  float getAlphaDenominator(int att);
  //virtual float getSNPDistance(int att)=0;


  public:


    double* getPosteriorProb(int attribute, intList* inputPattern);

    double* getNewPosteriorProb(int att, intList* inputPattern);

    double* getClassicPosteriorProb(int att, intList* inputPattern);

    double* getJunctionTreePosteriorProb(int att, intList* inputPattern);

  void report();

    GBN();

    void set();

    GBN(floatMLSample* sample, floatList* algorithm, VerbosityClass *verbosity, int alphaDefault);

    GBN(intMLSample* sample, floatList* algorithm, VerbosityClass *verbosity, int alphaDefault);

    virtual ~GBN();


    void setProbTables();

    void printParents();




  }
  ;  // End of class GBN



}
;  // Fin del Namespace

#endif

//#include "GBN.cpp"
/* Fin Fichero: GBN.h */
