
#ifndef __Excep__
#define __Excep__
#include <string>


using namespace std;


class NullValue {
public:
        void PrintMessage() {
                cout << "\nTrying to reach a null value (pointer == NULL).\n";
		exit(1);
	}
};

class MultiAllelic {
public:
        void PrintMessage(int pos) {
                cout << "\nThere is a Multiallelic SNP at position " << pos<<".\n";
		exit(1);
	}
		        void PrintMessage() {
                cout << "\nThere is a Multiallelic SNP.\n";
		exit(1);
	}

};
class MonoAllelic {
public:
        void PrintMessage(int pos) {
                cout << "\nThere is a Monoallelic SNP at position " << pos<<".\n";
		exit(1);
	}
		        void PrintMessage() {
                cout << "\nThere is a Monoallelic SNP.\n";
		exit(1);
	}

};

class Inconsistent {
public:
        void PrintMessage(int pos) {
                cout << "\nThere is an inconsistent SNP at position " << pos<<".\n";
		exit(1);
	}
		        void PrintMessage() {
                cout << "\nThere is an inconsistent SNP \n";
		exit(1);
	}

};
class NonSNP {
public:
        void PrintMessage(char value) {
                cout << value << " is not a nucleotide value.\n";
		exit(1);
		}
		   void PrintMessage(short int value) {
                cout << value << " is not a nucleotide value.\n";
		exit(1);
	}
};

class UnorderedPos {
public:
        void PrintMessage() {
                cout << " Positions are not ordered.\n";
		exit(1);
	}
};

class NoMemory {
public:
        void PrintMessage() {
                cout << "\nNot enough memory.\n";
		exit(1);
	}
};


class BadSize {
public:
        void PrintMessage() {
                cout << "\nDifferent size.\n";
		exit(1);
	}
};

class EOFile {
public:
        void PrintMessage() {
                cout << "\nEnd of file error.\n";
		exit(1);
	}
};

class BadFile {
public:
        void PrintMessage() {
                cout << "\nIncorrect file format.\n";
		exit(1);
	}
};


class ErrorFile {
public:
        void PrintMessage() {
                cout << "\nFile does not exist, is damaged or cannot be created.\n";
		exit(1);
	}
};

class EmptyFile {
public:
        void PrintMessage(char* filename) {
                cout << "\nFile " << filename << " does not have data.\n";
		exit(1);
	}
};


class IncorrectParameters {
public:
        void PrintMessage() {
                cout << "\nEspecified number of individuals y/or number of SNPs do not match with those in the file.\n";
		exit(1);
	}
};


class IncorrectAlgorithm {
public:
        void PrintMessage() {

         cout << "Error, algorithm must be PHASE, SNPHAP or HTYPER";
	exit(1);
	}
};


class IncorrectWay {
public:
        void PrintMessage() {

         cout << "Error, way must be e (for Export) or i (for import)";
	exit(1);
	}
};



class NonBoolean {
public:
        void PrintMessage() {

         cout << "Error, must be a boolean value (0 or 1)";
	exit(1);
	}
};

class NonHetero {
public:
        void PrintMessage(unsigned int position) {

         cout << "Error, the position " << position << " is not heterozygous";
	exit(1);
	}
};

class NonExist {
public:
        void PrintMessage(unsigned int position) {

         cout << "Error, the position " << position << " does not exist";
	exit(1);
	}
};

class OverflowedSNP {
public:
        void PrintMessage(int SNP) {

         cout << "Error, the SNP number " << SNP << " overpass the total number of SNPs";
	exit(1);
	}
};
class NonFound {
public:
        void PrintMessage() {

         cout << "Error, individual has not been found";
	exit(1);
	}
};



class BadFormat {
public:
        void PrintMessage() {

         cout << "Error, incorrect format";
	exit(1);
	}
};


class ZeroValue {
public:
        void PrintMessage() {

         cout << "Error, denominator is zero";
	exit(1);
	}
};

#endif
